/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.service.common;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.ContentHandlerAdapter;
import org.dcm4che2.io.SAXWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTUtils {
    public static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
    protected static final Logger log = LoggerFactory.getLogger(XSLTUtils.class);

    public static void xslt(DicomObject attrs, Templates tpl, OutputStream out, Map<String, String> parameter) throws TransformerConfigurationException, SAXException, IOException {
        TransformerHandler th = tpl == null ? transformerFactory.newTransformerHandler() : transformerFactory.newTransformerHandler(tpl);
        Transformer t = th.getTransformer();
        XSLTUtils.setParameter(parameter, t);
        th.setResult(new StreamResult(out));
        SAXWriter writer = new SAXWriter((ContentHandler)th, null);
        writer.write(attrs);
    }

    public static void xslt(DicomObject attrs, Templates tpl, DicomObject out, Map<String, String> parameter) throws TransformerConfigurationException, SAXException, IOException {
        TransformerHandler th = tpl == null ? transformerFactory.newTransformerHandler() : transformerFactory.newTransformerHandler(tpl);
        ContentHandlerAdapter cha = new ContentHandlerAdapter(out);
        Transformer t = th.getTransformer();
        XSLTUtils.setParameter(parameter, t);
        th.setResult(new SAXResult((ContentHandler)cha));
        SAXWriter writer = new SAXWriter((ContentHandler)th, null);
        writer.write(attrs);
    }

    public static void xslt(DicomObject attrs, Templates[] tpls, DicomObject out, Map<String, String> parameter) throws TransformerConfigurationException, SAXException, IOException {
        if (tpls != null && tpls.length > 1) {
            TransformerHandler[] thChain = XSLTUtils.toTransformerHandlerChain(tpls);
            if (parameter != null) {
                for (int i = 0; i < thChain.length; ++i) {
                    XSLTUtils.setParameter(parameter, thChain[i].getTransformer());
                }
            }
            XSLTUtils.xslt(attrs, thChain, out);
        } else {
            XSLTUtils.xslt(attrs, tpls == null ? null : tpls[0], out, parameter);
        }
    }

    public static void xslt(DicomObject attrs, Templates[] tpls, OutputStream out, Map<String, String> parameter) throws TransformerConfigurationException, SAXException, IOException {
        if (tpls != null && tpls.length > 1) {
            TransformerHandler[] thChain = XSLTUtils.toTransformerHandlerChain(tpls);
            if (parameter != null) {
                for (int i = 0; i < thChain.length; ++i) {
                    XSLTUtils.setParameter(parameter, thChain[i].getTransformer());
                }
            }
            XSLTUtils.xslt(attrs, thChain, out);
        } else {
            XSLTUtils.xslt(attrs, tpls == null ? null : tpls[0], out, parameter);
        }
    }

    public static void xslt(DicomObject attrs, TransformerHandler[] thChain, OutputStream out) throws SAXException, IOException {
        thChain[thChain.length - 1].setResult(new StreamResult(out));
        SAXWriter writer = new SAXWriter((ContentHandler)thChain[0], null);
        writer.write(attrs);
    }

    public static void xslt(DicomObject attrs, TransformerHandler[] thChain, Result result) throws SAXException, IOException {
        thChain[thChain.length - 1].setResult(result);
        SAXWriter writer = new SAXWriter((ContentHandler)thChain[0], null);
        writer.write(attrs);
    }

    public static void xslt(DicomObject attrs, TransformerHandler[] thChain, DicomObject out) throws SAXException, IOException {
        ContentHandlerAdapter cha = new ContentHandlerAdapter(out);
        thChain[thChain.length - 1].setResult(new SAXResult((ContentHandler)cha));
        SAXWriter writer = new SAXWriter((ContentHandler)thChain[0], null);
        writer.write(attrs);
    }

    public static TransformerHandler[] toTransformerHandlerChain(Templates[] tpls) throws TransformerConfigurationException, SAXException, IOException {
        if (tpls == null || tpls.length < 1) {
            return null;
        }
        TransformerHandler[] thChain = new TransformerHandler[tpls.length];
        thChain[0] = transformerFactory.newTransformerHandler(tpls[0]);
        int i = 1;
        int prev = 0;
        while (i < tpls.length) {
            thChain[i] = transformerFactory.newTransformerHandler(tpls[i]);
            thChain[prev].setResult(new SAXResult(thChain[i]));
            ++i;
            ++prev;
        }
        return thChain;
    }

    private static void setParameter(Map<String, String> parameter, Transformer t) {
        if (parameter != null) {
            for (Map.Entry<String, String> e : parameter.entrySet()) {
                t.setParameter(e.getKey(), e.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(DicomObject attrs, Templates tpl, String filename, boolean comment) throws TransformerConfigurationException, SAXException, IOException {
        TransformerHandler th = tpl == null ? transformerFactory.newTransformerHandler() : transformerFactory.newTransformerHandler(tpl);
        FileOutputStream out = new FileOutputStream(filename);
        th.setResult(new StreamResult(out));
        SAXWriter writer = new SAXWriter((ContentHandler)th, (LexicalHandler)(comment ? th : null));
        try {
            writer.write(attrs);
        }
        finally {
            out.close();
        }
    }
}

