/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.service.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.Executor;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4chee.archive.entity.AE;
import org.dcm4chee.web.dao.ae.AEHomeLocal;
import org.jboss.system.ServiceMBeanSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScuService
extends ServiceMBeanSupport {
    private Device device;
    protected NetworkConnection localConn;
    protected NetworkApplicationEntity localNAE;
    private boolean bindToCallingAET;
    protected int priority;
    private AEHomeLocal aeHome;
    private Executor executor;
    private ObjectName tlsCfgServiceName;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractScuService.class);
    protected static final String NONE = "NONE";
    public static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    public static final String[] PRIORITIES = new String[]{"MEDIUM", "HIGH", "LOW"};
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    public AbstractScuService() {
        String scuName = ((Object)((Object)this)).getClass().getSimpleName();
        this.log.info((Object)("SCU Devicename:" + scuName));
        this.executor = new NewThreadExecutor(scuName);
        this.device = new Device(scuName);
        this.localConn = new NetworkConnection();
        this.localNAE = new NetworkApplicationEntity();
        this.localNAE.setNetworkConnection(this.localConn);
        this.localNAE.setAssociationInitiator(true);
        this.device.setNetworkApplicationEntity(this.localNAE);
        this.device.setNetworkConnection(this.localConn);
    }

    public boolean isBindToCallingAET() {
        return this.bindToCallingAET;
    }

    public void setBindToCallingAET(boolean bindToCallingAET) {
        this.bindToCallingAET = bindToCallingAET;
    }

    public int getMaxPDULengthReceive() {
        return this.localNAE.getMaxPDULengthReceive();
    }

    public void setMaxPDULengthReceive(int maxPDULength) {
        this.localNAE.setMaxPDULengthReceive(maxPDULength);
    }

    public int getMaxOpsInvoked() {
        return this.localNAE.getMaxOpsInvoked();
    }

    public void setMaxOpsInvoked(int maxOpsInvoked) {
        this.localNAE.setMaxOpsInvoked(maxOpsInvoked);
    }

    public int getDimseRspTimeout() {
        return this.localNAE.getDimseRspTimeout();
    }

    public void setDimseRspTimeout(int retrieveRspTimeout) {
        this.localNAE.setDimseRspTimeout(retrieveRspTimeout);
    }

    public int getRetrieveRspTimeout() {
        return this.localNAE.getRetrieveRspTimeout();
    }

    public void setRetrieveRspTimeout(int retrieveRspTimeout) {
        this.localNAE.setRetrieveRspTimeout(retrieveRspTimeout);
    }

    public boolean isPackPDV() {
        return this.localNAE.isPackPDV();
    }

    public void setPackPDV(boolean packPDV) {
        this.localNAE.setPackPDV(packPDV);
    }

    public int getAcceptTimeout() {
        return this.localConn.getAcceptTimeout();
    }

    public void setAcceptTimeout(int timeout) {
        this.localConn.setAcceptTimeout(timeout);
    }

    public int getConnectTimeout() {
        return this.localConn.getConnectTimeout();
    }

    public void setConnectTimeout(int timeout) {
        this.localConn.setConnectTimeout(timeout);
    }

    public int getReleaseTimeout() {
        return this.localConn.getReleaseTimeout();
    }

    public void setReleaseTimeout(int timeout) {
        this.localConn.setReleaseTimeout(timeout);
    }

    public int getRequestTimeout() {
        return this.localConn.getRequestTimeout();
    }

    public void setRequestTimeout(int timeout) {
        this.localConn.setRequestTimeout(timeout);
    }

    public int getSocketCloseDelay() {
        return this.localConn.getSocketCloseDelay();
    }

    public void setSocketCloseDelay(int timeout) {
        this.localConn.setSocketCloseDelay(timeout);
    }

    public boolean isTcpNoDelay() {
        return this.localConn.isTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.localConn.setTcpNoDelay(tcpNoDelay);
    }

    public String getCallingAET() {
        return this.localNAE.getAETitle();
    }

    public void setCallingAET(String callingAET) {
        this.localNAE.setAETitle(callingAET);
        this.device.setDeviceName(callingAET);
    }

    public String getPriority() {
        return PRIORITIES[this.priority];
    }

    public void setPriority(String priorityName) {
        this.priority = PRIORITIES[1].equals(priorityName) ? 1 : (PRIORITIES[2].equals(priorityName) ? 2 : 0);
    }

    public ObjectName getTlsCfgServiceName() {
        return this.tlsCfgServiceName;
    }

    public void setTlsCfgServiceName(ObjectName name) {
        this.tlsCfgServiceName = name;
    }

    public Association open(String aet) throws IOException, GeneralSecurityException {
        AE ae;
        try {
            ae = this.lookupAEHome().findByTitle(aet);
        }
        catch (Exception x) {
            throw new RuntimeException("AET not found:" + aet);
        }
        return this.open(ae);
    }

    public Association open(AE ae) throws IOException, GeneralSecurityException {
        NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
        NetworkConnection remoteConn = new NetworkConnection();
        remoteConn.setHostname(ae.getHostName());
        remoteConn.setPort(ae.getPort());
        remoteAE.setAETitle(ae.getTitle());
        remoteAE.setInstalled(true);
        remoteAE.setAssociationAcceptor(true);
        remoteAE.setNetworkConnection(remoteConn);
        List ciphers = ae.getCipherSuites();
        LOG.info("Open association to {} url:{} Ciphers:{}", new Object[]{ae.getTitle(), ae, ciphers});
        if (ciphers.size() > 0) {
            String[] ciphers1 = ciphers.toArray(new String[ciphers.size()]);
            try {
                this.server.invoke(this.tlsCfgServiceName, "initTLS", new Object[]{remoteConn, this.device, ciphers1}, new String[]{NetworkConnection.class.getName(), Device.class.getName(), ciphers1.getClass().getName()});
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to initialize TLS! AE:" + ae + " ciphers:" + ciphers), (Throwable)e);
                throw new IOException("Failed to initialize TLS aet:" + ae.getTitle());
            }
        } else {
            remoteConn.setTlsCipherSuite(new String[0]);
            this.localConn.setTlsCipherSuite(new String[0]);
        }
        if (this.bindToCallingAET) {
            try {
                AE callingAE = this.lookupAEHome().findByTitle(this.localNAE.getAETitle());
                this.log.info((Object)("Try to bind socket to callingAE:" + callingAE + " hostname:" + callingAE.getHostName()));
                this.localConn.setHostname(callingAE.getHostName());
                this.log.info((Object)("Socket bound to " + callingAE.getHostName()));
            }
            catch (Exception x) {
                this.log.warn((Object)"Socket can not be bound to IP of calling AET!", (Throwable)x);
            }
        }
        try {
            return this.localNAE.connect(remoteAE, this.executor, true);
        }
        catch (AAssociateRJ t) {
            throw t;
        }
        catch (Throwable t) {
            this.log.error((Object)"localNAE.connect failed!", t);
            throw new IOException("Failed to establish Association aet:" + ae.getTitle());
        }
    }

    public TransferCapability[] getTransferCapability() {
        return this.localNAE.getTransferCapability();
    }

    public void setTransferCapability(TransferCapability[] tc) {
        this.localNAE.setTransferCapability(tc);
    }

    public TransferCapability selectTransferCapability(Association assoc, String[] cuid) {
        for (int i = 0; i < cuid.length; ++i) {
            TransferCapability tc = assoc.getTransferCapabilityAsSCU(cuid[i]);
            if (tc == null) continue;
            return tc;
        }
        return null;
    }

    public AEHomeLocal lookupAEHome() {
        if (this.aeHome == null) {
            try {
                InitialContext jndiCtx = new InitialContext();
                this.aeHome = (AEHomeLocal)jndiCtx.lookup("dcm4chee-web-ear/AEHomeBean/local");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.aeHome;
    }
}

