/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.service.common;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.ObjectName;
import org.dcm4chee.web.service.common.AbstractScuService;
import org.dcm4chee.web.service.common.DicomActionOrder;
import org.dcm4chee.web.service.common.RetryIntervalls;
import org.dcm4chee.web.service.common.delegate.JMSDelegate;

public abstract class AbstractScheduledScuService
extends AbstractScuService
implements MessageListener {
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private static int MESSAGE_PRIORITY_MIN = 0;
    private int concurrency;
    private String queueName;

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String s) {
        this.retryIntervalls = new RetryIntervalls(s);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
    }

    protected void stopService() throws Exception {
        this.jmsDelegate.stopListening(this.queueName);
    }

    public void schedule(DicomActionOrder order) throws Exception {
        this.jmsDelegate.queue(this.queueName, order, 4, 0L);
    }

    public void onMessage(Message message) {
        block6: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                DicomActionOrder order = (DicomActionOrder)om.getObject();
                this.log.info((Object)("Start processing " + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Finished processing " + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block6;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, MESSAGE_PRIORITY_MIN, System.currentTimeMillis() + delay);
                }
            }
            catch (JMSException e) {
                this.log.error((Object)("jms error during processing message: " + message), (Throwable)e);
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    public abstract void process(DicomActionOrder var1) throws Exception;
}

