/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.apache.wicket.Application;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Classes {
    private static final Logger log = LoggerFactory.getLogger(Classes.class);

    public static String name(Class<?> c) {
        return c != null ? c.getName() : null;
    }

    public static Class<?> relativeClass(Class<?> scope, String path) throws ClassNotFoundException {
        return Class.forName(Packages.absolutePath(scope, path).replace('/', '.'));
    }

    public static <T> Class<T> resolveClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            if (Application.exists()) {
                return Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not resolve class: " + className);
            return null;
        }
    }

    public static <C> String simpleName(Class<C> c) {
        return Strings.lastPathComponent(c.getName(), '.');
    }

    private Classes() {
    }
}

