/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.apache.wicket.AbortException;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPageFactory
implements IPageFactory {
    private final Map<Class<? extends Page>, Constructor<? extends Page>> constructorForPageParameterClass = Generics.newConcurrentHashMap();

    @Override
    public final <C extends Page> Page newPage(Class<C> pageClass) {
        Constructor<Page> constructor = this.constructor(pageClass, null, new Class[0]);
        if (constructor != null) {
            return this.createPage(constructor, new Object[0]);
        }
        constructor = this.constructor(pageClass, this.constructorForPageParameterClass, PageParameters.class);
        if (constructor != null) {
            return this.createPage(constructor, new PageParameters());
        }
        throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does neither have a constructor with PageParameter nor a default constructor");
    }

    @Override
    public final <C extends Page> Page newPage(Class<C> pageClass, PageParameters parameters) {
        if (parameters == null) {
            return this.newPage(pageClass);
        }
        Constructor<Page> constructor = this.constructor(pageClass, this.constructorForPageParameterClass, PageParameters.class);
        if (constructor != null) {
            return this.createPage(constructor, parameters);
        }
        constructor = this.constructor(pageClass, null, new Class[0]);
        if (constructor != null) {
            return this.createPage(constructor, new Object[0]);
        }
        throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does neither have a constructor with PageParameter nor a default constructor");
    }

    @Override
    public <C extends Page> Page newPage(Class<C> pageClass, Throwable throwable, Page responsePage) {
        Constructor<Page> constructor = this.constructor(pageClass, null, Throwable.class, Page.class);
        if (constructor != null) {
            return this.createPage(constructor, throwable, responsePage);
        }
        constructor = this.constructor(pageClass, null, new Class[0]);
        if (constructor != null) {
            return this.createPage(constructor, new Object[0]);
        }
        throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does neither have a constructor with PageParameter nor a default constructor");
    }

    private final <C extends Page> Constructor<? extends Page> constructor(Class<C> pageClass, Map<Class<? extends Page>, Constructor<? extends Page>> constructorCache, Class<?> ... argumentTypes) {
        Constructor<Page> constructor;
        Constructor<? extends Page> constructor2 = constructor = constructorCache == null ? null : constructorCache.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getConstructor(argumentTypes);
                if (constructorCache != null) {
                    constructorCache.put(pageClass, constructor);
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return constructor;
    }

    private final Page createPage(Constructor<? extends Page> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, arguments), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, arguments), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AbortException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, arguments), e);
        }
    }

    private String createDescription(Constructor<? extends Page> constructor, Object[] arguments) {
        if (arguments != null) {
            return "Can't instantiate page using constructor " + constructor + " and arguments " + Arrays.toString(arguments);
        }
        return "Can't instantiate page using constructor " + constructor;
    }
}

