/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.file.File;

public final class FileResponse
extends Response {
    private final File file;
    private OutputStream out;
    private PrintWriter printWriter;

    public FileResponse(File file) {
        this.file = file;
    }

    public void close() {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                throw new WicketRuntimeException("Unable to close to file " + this.file, e);
            }
        }
    }

    public OutputStream getOutputStream() {
        try {
            if (this.out == null) {
                this.out = new FileOutputStream(this.file);
            }
            return this.out;
        }
        catch (FileNotFoundException e) {
            throw new WicketRuntimeException("Unable to get output stream to file " + this.file, e);
        }
    }

    public void write(CharSequence string) {
        try {
            this.getPrintWriter().print(string);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to write to file " + this.file, e);
        }
    }

    private PrintWriter getPrintWriter() throws IOException {
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
        }
        return this.printWriter;
    }
}

