/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketSessionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WicketSessionFilter.class);
    private String filterName;
    private String sessionKey;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getInitParameter("filterName");
        if (this.filterName == null) {
            throw new ServletException("you must provide init parameter 'filterName if you want to use " + this.getClass().getName());
        }
        log.debug("filterName/ application key set to {}", (Object)this.filterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            Session session;
            if (this.sessionKey == null) {
                WebApplication application = (WebApplication)Application.get(this.filterName);
                if (application == null) {
                    throw new IllegalStateException("Could not find wicket application mapped to filter: " + this.filterName + ". Make sure you set filterName attribute to the name of the wicket filter " + "for the wicket application whose session you want to access.");
                }
                this.sessionKey = application.getSessionAttributePrefix(null, this.filterName) + "session";
                log.debug("will use {} as the session key to get the Wicket session", (Object)this.sessionKey);
            }
            if ((session = (Session)httpSession.getAttribute(this.sessionKey)) != null) {
                Session.set(session);
                if (log.isDebugEnabled()) {
                    log.debug("session " + session + " set as current for " + httpServletRequest.getContextPath() + "," + httpServletRequest.getServerName());
                }
            } else if (log.isDebugEnabled()) {
                log.debug("could not set Wicket session: key " + this.sessionKey + " not found in http session for " + httpServletRequest.getContextPath() + "," + httpServletRequest.getServerName());
            }
        } else {
            log.debug("could not set Wicket session: no http session was created yet for {},{}", (Object)httpServletRequest.getContextPath(), (Object)httpServletRequest.getServerName());
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            Session.unset();
        }
    }

    public void destroy() {
    }
}

