/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageMap
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final List<ShapeLink> shapeLinks = new ArrayList<ShapeLink>();

    public ImageMap(String id) {
        super(id);
    }

    public ImageMap addCircleLink(int x1, int y1, int radius, Link<?> link) {
        this.add(link);
        this.shapeLinks.add(new CircleLink(x1, y1, radius, link));
        return this;
    }

    public ImageMap addPolygonLink(int[] coordinates, Link<?> link) {
        this.add(link);
        this.shapeLinks.add(new PolygonLink(coordinates, link));
        return this;
    }

    public ImageMap addRectangleLink(int x1, int y1, int x2, int y2, Link<?> link) {
        this.add(link);
        this.shapeLinks.add(new RectangleLink(x1, y1, x2, y2, link));
        return this;
    }

    @Override
    protected void onRender(MarkupStream markupStream) {
        ComponentTag tag = markupStream.getTag().mutable();
        this.checkComponentTag(tag, "img");
        tag.put("usemap", "#" + this.getPath());
        this.renderComponentTag(tag);
        markupStream.next();
        StringBuffer imageMap = new StringBuffer();
        imageMap.append("\n<map name=\"").append(this.getPath()).append("\"> ");
        for (ShapeLink shapeLink : this.shapeLinks) {
            imageMap.append('\n');
            imageMap.append(shapeLink.toString());
            this.getPage().componentRendered(shapeLink.link);
        }
        imageMap.append("\n</map>");
        this.getResponse().write(imageMap.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ShapeLink
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final Link<?> link;

        public ShapeLink(Link<?> link) {
            this.link = link;
        }

        public String toString() {
            String popupJavaScript = this.link.getPopupSettings() != null ? this.link.getPopupSettings().getPopupJavaScript() : null;
            return "<area shape=\"" + this.getType() + "\"" + " coords=\"" + this.getCoordinates() + "\"" + " href=\"" + this.link.getURL() + "\"" + (this.link.getOutputMarkupId() ? " id=\"" + this.link.getMarkupId() + "\"" : "") + (popupJavaScript == null ? "" : " onClick = \"" + popupJavaScript + "\"") + ">";
        }

        abstract String getCoordinates();

        abstract String getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RectangleLink
    extends ShapeLink {
        private static final long serialVersionUID = 1L;
        private final int x1;
        private final int x2;
        private final int y1;
        private final int y2;

        public RectangleLink(int x1, int y1, int x2, int y2, Link<?> link) {
            super(link);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        String getCoordinates() {
            return this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2;
        }

        @Override
        String getType() {
            return "rectangle";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PolygonLink
    extends ShapeLink {
        private static final long serialVersionUID = 1L;
        private final int[] coordinates;

        public PolygonLink(int[] coordinates, Link<?> link) {
            super(link);
            this.coordinates = coordinates;
        }

        @Override
        String getCoordinates() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.coordinates.length; ++i) {
                buffer.append(this.coordinates[i]);
                if (i >= this.coordinates.length - 1) continue;
                buffer.append(',');
            }
            return buffer.toString();
        }

        @Override
        String getType() {
            return "polygon";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CircleLink
    extends ShapeLink {
        private static final long serialVersionUID = 1L;
        private final int radius;
        private final int x;
        private final int y;

        public CircleLink(int x, int y, int radius, Link<?> link) {
            super(link);
            this.x = x;
            this.y = y;
            this.radius = radius;
        }

        @Override
        String getCoordinates() {
            return this.x + "," + this.y + "," + this.radius;
        }

        @Override
        String getType() {
            return "circle";
        }
    }
}

