/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Request;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.upload.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileUploadField
extends FormComponentPanel<Collection<FileUpload>>
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    public static final int UNLIMITED = -1;
    public static final String RESOURCE_LIMITED = "org.apache.wicket.mfu.caption.limited";
    public static final String RESOURCE_UNLIMITED = "org.apache.wicket.mfu.caption.unlimited";
    private static final String NAME_ATTR = "name";
    private static final String MAGIC_SEPARATOR = "_mf_";
    private static final ResourceReference JS = new JavascriptResourceReference(MultiFileUploadField.class, "MultiFileUploadField.js");
    private final WebComponent upload;
    private final WebMarkupContainer container;
    private final int max;
    private transient String[] inputArrayCache = null;

    public MultiFileUploadField(String id) {
        this(id, null, -1);
    }

    public MultiFileUploadField(String id, int max) {
        this(id, null, max);
    }

    public MultiFileUploadField(String id, IModel<Collection<FileUpload>> model) {
        this(id, model, -1);
    }

    public MultiFileUploadField(String id, IModel<Collection<FileUpload>> model, int max) {
        super(id, model);
        this.max = max;
        this.upload = new WebComponent("upload");
        this.upload.setOutputMarkupId(true);
        this.add(this.upload);
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(this.container);
        this.container.add(new Label("caption", new CaptionModel()));
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getAttributes().containsKey(NAME_ATTR)) {
            tag.getAttributes().remove(NAME_ATTR);
        }
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        Form form = this.findParent(Form.class);
        if (form == null) {
            throw new IllegalStateException("Component " + this.getClass().getName() + " must have a " + Form.class.getName() + " component above in the hierarchy");
        }
    }

    @Override
    public boolean isMultiPart() {
        return true;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(JS);
        response.renderOnDomReadyJavascript("new MultiSelector('" + this.getInputName() + "', document.getElementById('" + this.container.getMarkupId() + "'), " + this.max + ",'" + this.getString("org.apache.wicket.mfu.delete") + "').addElement(document.getElementById('" + this.upload.getMarkupId() + "'));");
    }

    @Override
    public String[] getInputAsArray() {
        if (this.inputArrayCache == null) {
            ArrayList names = null;
            Request request = this.getRequest();
            if (request instanceof IMultipartWebRequest) {
                Map<String, FileItem> itemNameToItem = ((IMultipartWebRequest)((Object)request)).getFiles();
                for (Map.Entry<String, FileItem> entry : itemNameToItem.entrySet()) {
                    String name = entry.getKey();
                    FileItem item = entry.getValue();
                    if (Strings.isEmpty(name) || !name.startsWith(this.getInputName() + MAGIC_SEPARATOR) || Strings.isEmpty(item.getName())) continue;
                    names = names != null ? names : new ArrayList();
                    names.add(name);
                }
            }
            if (names != null) {
                this.inputArrayCache = names.toArray(new String[names.size()]);
            }
        }
        return this.inputArrayCache;
    }

    @Override
    protected Collection<FileUpload> convertValue(String[] value) throws ConversionException {
        ArrayList<FileUpload> uploads = null;
        String[] filenames = this.getInputAsArray();
        if (filenames != null) {
            IMultipartWebRequest request = (IMultipartWebRequest)((Object)this.getRequest());
            uploads = new ArrayList<FileUpload>(filenames.length);
            for (int i = 0; i < filenames.length; ++i) {
                uploads.add(new FileUpload(request.getFile(filenames[i])));
            }
        }
        return uploads;
    }

    @Override
    public void updateModel() {
        Collection collection = (Collection)this.getModelObject();
        if (collection == null) {
            this.setDefaultModelObject(this.getConvertedInput());
        } else {
            collection.clear();
            if (this.getConvertedInput() != null) {
                collection.addAll((Collection)this.getConvertedInput());
            }
            this.setDefaultModelObject(collection);
        }
    }

    @Override
    protected void onDetach() {
        Collection uploads = (Collection)this.getConvertedInput();
        if (uploads != null) {
            for (FileUpload upload : uploads) {
                upload.closeStreams();
            }
        }
        this.inputArrayCache = null;
        Collection modelObject = (Collection)this.getModelObject();
        if (modelObject != null) {
            modelObject.clear();
        }
        super.onDetach();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CaptionModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 1L;

        private CaptionModel() {
        }

        @Override
        public String getObject() {
            if (MultiFileUploadField.this.max == -1) {
                return MultiFileUploadField.this.getString(MultiFileUploadField.RESOURCE_UNLIMITED);
            }
            HashMap<String, Integer> vars = new HashMap<String, Integer>(1);
            vars.put("max", MultiFileUploadField.this.max);
            return MultiFileUploadField.this.getString(MultiFileUploadField.RESOURCE_LIMITED, new Model(vars));
        }
    }
}

