/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.HeaderPartContainer;
import org.apache.wicket.markup.html.IHeaderPartContainerProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.response.NullResponse;
import org.apache.wicket.util.lang.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerWithAssociatedMarkupHelper
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private boolean noMoreWicketHeadTagsAllowed = false;
    private final WebMarkupContainer container;

    public ContainerWithAssociatedMarkupHelper(IHeaderPartContainerProvider container) {
        this.container = (WebMarkupContainer)((Object)container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderHeadFromAssociatedMarkupFile(HtmlHeaderContainer htmlContainer) {
        MarkupStream markupStream = this.container.getAssociatedMarkupStream(false);
        if (markupStream == null) {
            return;
        }
        this.noMoreWicketHeadTagsAllowed = false;
        while (this.nextHeaderMarkup(markupStream) != -1) {
            HeaderPartContainer headerPart;
            Class<? extends Component> markupClass = ((WicketTag)markupStream.getTag()).getMarkupClass();
            if (markupClass == null) {
                markupClass = markupStream.getContainerClass();
            }
            if ((headerPart = this.getHeaderPart(markupClass, markupStream.getCurrentIndex())) != null) {
                if (htmlContainer.okToRenderComponent(headerPart.getScope(), headerPart.getId())) {
                    htmlContainer.autoAdd(headerPart, null);
                } else {
                    Response response = this.container.getRequestCycle().getResponse();
                    try {
                        this.container.getRequestCycle().setResponse(NullResponse.getInstance());
                        htmlContainer.autoAdd(headerPart, null);
                    }
                    finally {
                        this.container.getRequestCycle().setResponse(response);
                    }
                }
            }
            markupStream.skipComponent();
        }
    }

    private final HeaderPartContainer getHeaderPart(Class<?> markupClass, int index) {
        WicketTag wTag;
        MarkupStream markupStream = this.container.getAssociatedMarkupStream(false);
        markupStream.setCurrentIndex(index);
        MarkupElement element = markupStream.get();
        if (element instanceof WicketTag && (wTag = (WicketTag)element).isHeadTag() && wTag.getNamespace() != null) {
            String headerId = "_" + Classes.simpleName(markupClass) + (this.container.getVariation() == null ? "" : this.container.getVariation().replace(':', '_')) + "Header" + index;
            String scope = wTag.getAttributes().getString(markupStream.getWicketNamespace() + ":scope");
            HeaderPartContainer headerContainer = ((IHeaderPartContainerProvider)((Object)this.container)).newHeaderPartContainer(headerId, scope);
            headerContainer.setMyMarkupStream(markupStream);
            headerContainer.setRenderBodyOnly(true);
            return headerContainer;
        }
        throw new WicketRuntimeException("Programming error: expected a WicketTag: " + markupStream.toString());
    }

    private final int nextHeaderMarkup(MarkupStream associatedMarkupStream) {
        if (associatedMarkupStream == null) {
            return -1;
        }
        MarkupElement elem = associatedMarkupStream.get();
        while (elem != null) {
            ComponentTag tag;
            if (elem instanceof WicketTag) {
                tag = (WicketTag)elem;
                if (tag.isOpen() && ((WicketTag)tag).isHeadTag()) {
                    if (this.noMoreWicketHeadTagsAllowed) {
                        throw new MarkupException("<wicket:head> tags are only allowed before <body>, </head>, <wicket:panel> etc. tag");
                    }
                    return associatedMarkupStream.getCurrentIndex();
                }
                if (tag.isOpen() && (((WicketTag)tag).isPanelTag() || ((WicketTag)tag).isBorderTag() || ((WicketTag)tag).isExtendTag())) {
                    this.noMoreWicketHeadTagsAllowed = true;
                }
            } else if (elem instanceof ComponentTag) {
                tag = (ComponentTag)elem;
                if (tag.isClose() && TagUtils.isHeadTag(tag)) {
                    this.noMoreWicketHeadTagsAllowed = true;
                } else if (tag.isOpen() && TagUtils.isBodyTag(tag)) {
                    this.noMoreWicketHeadTagsAllowed = true;
                }
            }
            elem = associatedMarkupStream.next();
        }
        return -1;
    }
}

