/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceData;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedMarkup
extends Markup {
    private static final Logger log = LoggerFactory.getLogger(MergedMarkup.class);

    public MergedMarkup(Markup markup, Markup baseMarkup, int extendIndex) {
        super(new MarkupResourceData());
        this.getMarkupResourceData().setResource(markup.getMarkupResourceData().getResource());
        this.getMarkupResourceData().setXmlDeclaration(markup.getMarkupResourceData().getXmlDeclaration());
        this.getMarkupResourceData().setEncoding(markup.getMarkupResourceData().getEncoding());
        this.getMarkupResourceData().setWicketNamespace(markup.getMarkupResourceData().getWicketNamespace());
        this.getMarkupResourceData().setBaseMarkup(baseMarkup);
        if (log.isDebugEnabled()) {
            String derivedResource = Strings.afterLast(markup.getMarkupResourceData().getResource().toString(), '/');
            String baseResource = Strings.afterLast(baseMarkup.getMarkupResourceData().getResource().toString(), '/');
            log.debug("Merge markup: derived markup: " + derivedResource + "; base markup: " + baseResource);
        }
        this.merge(markup, baseMarkup, extendIndex);
        this.initialize();
        if (log.isDebugEnabled()) {
            log.debug("Merge markup: " + this.toString());
        }
    }

    public String locationAsString() {
        return this.getMarkupResourceData().getBaseMarkup().locationAsString() + ":" + this.getMarkupResourceData().getResource().locationAsString();
    }

    private void merge(Markup markup, Markup baseMarkup, int extendIndex) {
        ComponentTag tag;
        MarkupElement element;
        int baseIndex;
        boolean wicketHeadProcessed = false;
        boolean foundHeadTag = false;
        WicketTag childTag = null;
        for (baseIndex = 0; baseIndex < baseMarkup.size(); ++baseIndex) {
            element = baseMarkup.get(baseIndex);
            if (element instanceof RawMarkup) {
                this.addMarkupElement(element);
                continue;
            }
            tag = (ComponentTag)element;
            if (baseMarkup.getMarkupResourceData().getResource() != null && tag.getMarkupClass() == null) {
                tag.setMarkupClass(baseMarkup.getMarkupResourceData().getResource().getMarkupClass());
            }
            if (element instanceof WicketTag) {
                WicketTag wtag = (WicketTag)element;
                if (wtag.isChildTag() && tag.getMarkupClass() == baseMarkup.getMarkupResourceData().getResource().getMarkupClass()) {
                    if (wtag.isOpenClose()) {
                        childTag = wtag;
                        WicketTag childOpenTag = (WicketTag)wtag.mutable();
                        childOpenTag.getXmlTag().setType(XmlTag.OPEN);
                        childOpenTag.setMarkupClass(baseMarkup.getMarkupResourceData().getResource().getMarkupClass());
                        this.addMarkupElement(childOpenTag);
                        break;
                    }
                    if (wtag.isOpen()) {
                        this.addMarkupElement(wtag);
                        break;
                    }
                    throw new WicketRuntimeException("Did not expect a </wicket:child> tag in " + baseMarkup.toString());
                }
                if (!wicketHeadProcessed) {
                    if (wtag.isClose() && wtag.isHeadTag() && !foundHeadTag) {
                        wicketHeadProcessed = true;
                        this.addMarkupElement(wtag);
                        this.copyWicketHead(markup, extendIndex);
                        continue;
                    }
                    if (wtag.isOpen() && wtag.isMajorWicketComponentTag()) {
                        wicketHeadProcessed = true;
                        this.copyWicketHead(markup, extendIndex);
                    }
                }
            }
            if (!wicketHeadProcessed) {
                if (tag.isOpen() && TagUtils.isHeadTag(tag)) {
                    foundHeadTag = true;
                }
                if (tag.isClose() && TagUtils.isHeadTag(tag) || tag.isOpen() && TagUtils.isBodyTag(tag)) {
                    wicketHeadProcessed = true;
                    this.copyWicketHead(markup, extendIndex);
                }
            }
            this.addMarkupElement(element);
        }
        if (baseIndex == baseMarkup.size()) {
            throw new WicketRuntimeException("Expected to find <wicket:child/> in base markup: " + baseMarkup.toString());
        }
        while (extendIndex < markup.size()) {
            WicketTag wtag;
            element = markup.get(extendIndex);
            this.addMarkupElement(element);
            if (element instanceof WicketTag && (wtag = (WicketTag)element).isExtendTag() && wtag.isClose()) break;
            ++extendIndex;
        }
        if (extendIndex == markup.size()) {
            throw new WicketRuntimeException("Missing close tag </wicket:extend> in derived markup: " + markup.toString());
        }
        if (((ComponentTag)baseMarkup.get(baseIndex)).isOpen()) {
            ++baseIndex;
            while (baseIndex < baseMarkup.size()) {
                element = baseMarkup.get(baseIndex);
                if (element instanceof WicketTag) {
                    tag = (WicketTag)element;
                    if (((WicketTag)tag).isChildTag() && tag.isClose()) {
                        tag.setMarkupClass(baseMarkup.getMarkupResourceData().getResource().getMarkupClass());
                        this.addMarkupElement(tag);
                        break;
                    }
                    throw new WicketRuntimeException("Wicket tags like <wicket:xxx> are not allowed in between <wicket:child> and </wicket:child> tags: " + markup.toString());
                }
                if (element instanceof ComponentTag) {
                    throw new WicketRuntimeException("Wicket tags identified by wicket:id are not allowed in between <wicket:child> and </wicket:child> tags: " + markup.toString());
                }
                ++baseIndex;
            }
            if (baseIndex == baseMarkup.size()) {
                throw new WicketRuntimeException("Expected to find </wicket:child> in base markup: " + baseMarkup.toString());
            }
        } else {
            WicketTag childCloseTag = (WicketTag)childTag.mutable();
            childCloseTag.getXmlTag().setType(XmlTag.CLOSE);
            childCloseTag.setMarkupClass(baseMarkup.getMarkupResourceData().getResource().getMarkupClass());
            this.addMarkupElement(childCloseTag);
        }
        ++baseIndex;
        while (baseIndex < baseMarkup.size()) {
            element = baseMarkup.get(baseIndex);
            this.addMarkupElement(element);
            if (element instanceof ComponentTag && baseMarkup.getMarkupResourceData().getResource() != null) {
                tag = (ComponentTag)element;
                tag.setMarkupClass(baseMarkup.getMarkupResourceData().getResource().getMarkupClass());
            }
            ++baseIndex;
        }
        if (Page.class.isAssignableFrom(markup.getMarkupResourceData().getResource().getMarkupClass())) {
            int hasOpenWicketHead = -1;
            int hasCloseWicketHead = -1;
            int hasHead = -1;
            for (int i = 0; i < this.size(); ++i) {
                MarkupElement element2 = this.get(i);
                if (hasOpenWicketHead == -1 && element2 instanceof WicketTag && ((WicketTag)element2).isHeadTag()) {
                    hasOpenWicketHead = i;
                    continue;
                }
                if (element2 instanceof WicketTag && ((WicketTag)element2).isHeadTag() && ((WicketTag)element2).isClose()) {
                    hasCloseWicketHead = i;
                    continue;
                }
                if (hasHead == -1 && element2 instanceof ComponentTag && TagUtils.isHeadTag((ComponentTag)element2)) {
                    hasHead = i;
                    continue;
                }
                if (hasHead != -1 && hasOpenWicketHead != -1) break;
            }
            if (hasOpenWicketHead != -1 && hasHead == -1) {
                XmlTag headOpenTag = new XmlTag();
                headOpenTag.setName("head");
                headOpenTag.setType(XmlTag.OPEN);
                ComponentTag openTag = new ComponentTag(headOpenTag);
                openTag.setId("_header_");
                openTag.setAutoComponentTag(true);
                XmlTag headCloseTag = new XmlTag();
                headCloseTag.setName(headOpenTag.getName());
                headCloseTag.setType(XmlTag.CLOSE);
                ComponentTag closeTag = new ComponentTag(headCloseTag);
                closeTag.setOpenTag(openTag);
                closeTag.setId("_header_");
                this.addMarkupElement(hasOpenWicketHead, openTag);
                this.addMarkupElement(hasCloseWicketHead + 2, closeTag);
            }
        }
    }

    private void copyWicketHead(Markup markup, int extendIndex) {
        boolean copy = false;
        for (int i = 0; i < extendIndex; ++i) {
            WicketTag etag;
            MarkupElement elem = markup.get(i);
            if (elem instanceof WicketTag && (etag = (WicketTag)elem).isHeadTag()) {
                if (etag.isOpen()) {
                    copy = true;
                } else {
                    this.addMarkupElement(elem);
                    break;
                }
            }
            if (!copy) continue;
            this.addMarkupElement(elem);
        }
    }
}

