/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.audit.logger;

import java.io.File;
import java.io.FilenameFilter;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.ApplicationActivityMessage;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.AuditSource;
import org.dcm4che2.audit.message.SecurityAlertMessage;
import org.jboss.security.SecurityAssociation;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AuditLogger
extends ServiceMBeanSupport {
    private static final String MBEAN_SERVER_DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    private static final String REGISTER_ACNL = "Register ACN Listener to ";
    private static final String DEFER_REGISTER_ACNL = "Defer to register ACN Listener to ";
    private static final String UNREGISTER_ACNL = "Unregister ACN Listener from ";
    private static final String FAILED_TO_REGISTER_ACNL = "Failed to register ACN Listener to ";
    private static final String FAILED_TO_UNREGISTER_ACNL = "Failed to unregister ACN Listener from ";
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private static final String[] TYPES = new String[]{"Network", "Security", "Hardware"};
    private static final AuditEvent.TypeCode[] TYPE_CODES = new AuditEvent.TypeCode[]{SecurityAlertMessage.SOFTWARE_CONFIGURATION, SecurityAlertMessage.NETWORK_CONFIGURATION, SecurityAlertMessage.SECURITY_CONFIGURATION, SecurityAlertMessage.HARDWARE_CONFIGURATION};
    private static final NotificationFilter REG_NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 6373294028145260060L;

        public boolean isNotificationEnabled(Notification notif) {
            return notif.getType().equals("JMX.mbean.registered");
        }
    };
    private static final NotificationFilter UNREG_NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 6373294028145260060L;

        public boolean isNotificationEnabled(Notification notif) {
            return notif.getType().equals("JMX.mbean.unregistered");
        }
    };
    private AuditSource auditSource = AuditSource.getDefaultAuditSource();
    private String configDir;
    private HashMap<ObjectName, AttributeChangeNotificationFilter[]> notRegisteredAcnSources;
    private HashMap<ObjectName, AttributeChangeNotificationFilter[]> registeredAcnSources = new HashMap();
    private final NotificationListener regl = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName source = mbsn.getMBeanName();
            AttributeChangeNotificationFilter[] acnf = (AttributeChangeNotificationFilter[])AuditLogger.this.notRegisteredAcnSources.get(source);
            if (acnf != null && AuditLogger.this.registerAcnListener(source, acnf)) {
                AuditLogger.this.notRegisteredAcnSources.remove(source);
                AuditLogger.this.registeredAcnSources.put(source, acnf);
            }
        }
    };
    private final NotificationListener unregl = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName source = mbsn.getMBeanName();
            AttributeChangeNotificationFilter[] acnf = (AttributeChangeNotificationFilter[])AuditLogger.this.registeredAcnSources.remove(source);
            if (acnf != null) {
                AuditLogger.this.unregisterAcnListener(source);
                AuditLogger.this.notRegisteredAcnSources.put(source, acnf);
            }
        }
    };
    private final NotificationListener acnl = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            AttributeChangeNotification scn = (AttributeChangeNotification)notif;
            Object newValue = scn.getNewValue();
            Object oldValue = scn.getOldValue();
            if (newValue instanceof String && oldValue instanceof String ? ((String)newValue).trim().equals(((String)oldValue).trim()) : newValue.equals(oldValue)) {
                return;
            }
            this.auditAttributeChange(scn, (AuditEvent.TypeCode)handback);
        }

        private void auditAttributeChange(AttributeChangeNotification scn, AuditEvent.TypeCode typeCode) {
            String text;
            boolean stateChanged = scn.getAttributeName().equals("State");
            if (stateChanged) {
                int newState = (Integer)scn.getNewValue();
                if (SecurityAssociation.getPrincipal() == null || newState != 3 && newState != 0) {
                    return;
                }
                text = ServiceMBean.states[newState];
            } else {
                text = this.toText(scn);
            }
            SecurityAlertMessage msg = new SecurityAlertMessage(typeCode);
            msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
            msg.addPerformingPerson(AuditLogger.this.getPrincipal(), null, null, AuditLogger.getHostname());
            msg.addAlertSubjectWithURI(this.toURI(scn), text);
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }

        private String toURI(AttributeChangeNotification scn) {
            return "jmx:" + scn.getSource();
        }

        private String toText(AttributeChangeNotification scn) {
            return "Change " + scn.getAttributeName() + " from '" + scn.getOldValue() + "' to '" + scn.getNewValue() + "'.";
        }
    };

    public boolean isIHEYr4() {
        return false;
    }

    public String getAuditSourceID() {
        return this.auditSource.getAuditSourceID();
    }

    public void setAuditSourceID(String id) {
        this.auditSource.setAuditSourceID(id);
    }

    private static String maskNull(String val, String nullVal) {
        return val == null ? nullVal : val;
    }

    private static String umaskNull(String val, String nullVal) {
        return nullVal.equals(val) ? null : val;
    }

    public String getAuditEnterpriseSiteID() {
        return AuditLogger.maskNull(this.auditSource.getAuditEnterpriseSiteID(), "-");
    }

    public void setAuditEnterpriseSiteID(String id) {
        this.auditSource.setAuditEnterpriseSiteID(AuditLogger.umaskNull(id, "-"));
    }

    public String getAuditSourceTypeCodes() {
        List l = this.auditSource.getAuditSourceTypeCodes();
        if (l.isEmpty()) {
            return "-";
        }
        StringBuffer sb = new StringBuffer();
        for (AuditSource.TypeCode typeCode : l) {
            sb.append(typeCode.getCode()).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void setAuditSourceTypeCodes(String codes) {
        int i;
        if (codes == null || codes.length() == 0 || "-".equals(codes)) {
            this.auditSource.clearAuditSourceTypeCodes();
            return;
        }
        String[] ss = codes.split(",");
        AuditSource.TypeCode[] types = new AuditSource.TypeCode[ss.length];
        for (i = 0; i < types.length; ++i) {
            types[i] = AuditSource.TypeCode.valueOf((String)ss[i]);
        }
        this.auditSource.clearAuditSourceTypeCodes();
        for (i = 0; i < types.length; ++i) {
            this.auditSource.addAuditSourceTypeCode(types[i]);
        }
    }

    public String getProcessID() {
        return AuditMessage.getProcessID();
    }

    public String getProcessName() {
        return AuditMessage.getProcessName();
    }

    public void setProcessName(String processName) {
        AuditMessage.setProcessName((String)processName);
    }

    public String getLocalAETitles() {
        return this.formatAETs(AuditMessage.getLocalAETitles());
    }

    private String formatAETs(String[] aets) {
        if (aets == null || aets.length == 0) {
            return "-";
        }
        if (aets.length == 1) {
            return aets[0];
        }
        StringBuffer sb = new StringBuffer(aets[0]);
        for (int i = 1; i < aets.length; ++i) {
            sb.append('\\').append(aets[i]);
        }
        return null;
    }

    public void setLocalAETitles(String aets) {
        AuditMessage.setLocalAETitles((String[])this.splitAETs(aets));
    }

    private String[] splitAETs(String aets) {
        if (aets == null) {
            return null;
        }
        String trim = aets.trim();
        if (trim.length() == 0 || "-".equals(trim)) {
            return null;
        }
        return trim.split("\\\\");
    }

    public boolean isEnableDNSLookups() {
        return AuditMessage.isEnableDNSLookups();
    }

    public void setEnableDNSLookups(boolean enableDNSLookups) {
        AuditMessage.setEnableDNSLookups((boolean)enableDNSLookups);
    }

    public boolean isIncludeXMLDeclaration() {
        return AuditMessage.isIncludeXMLDeclaration();
    }

    public void setIncludeXMLDeclaration(boolean incXMLDecl) {
        AuditMessage.setIncludeXMLDeclaration((boolean)incXMLDecl);
    }

    public boolean isTimezonedDateTime() {
        return AuditMessage.isTimezonedDateTime();
    }

    public void setTimezonedDateTime(boolean timezonedDateTime) {
        AuditMessage.setTimezonedDateTime((boolean)timezonedDateTime);
    }

    public boolean isUtcDateTime() {
        return AuditMessage.isUtcDateTime();
    }

    public void setUtcDateTime(boolean utcDateTime) {
        AuditMessage.setUtcDateTime((boolean)utcDateTime);
    }

    public boolean isQualifyHostname() {
        return AuditMessage.isQualifyHostname();
    }

    public void setQualifyHostname(boolean qualifyHostname) {
        AuditMessage.setQualifyHostname((boolean)qualifyHostname);
    }

    public boolean isEncodeUserIsRequestorTrue() {
        return ActiveParticipant.isEncodeUserIsRequestorTrue();
    }

    public void setEncodeUserIsRequestorTrue(boolean enable) {
        ActiveParticipant.setEncodeUserIsRequestorTrue((boolean)enable);
    }

    public boolean isAllowMultipleRequestors() {
        return AuditMessage.isAllowMultipleRequestors();
    }

    public void setAllowMultipleRequestors(boolean enable) {
        AuditMessage.setAllowMultipleRequestors((boolean)enable);
    }

    public final String getConfigurationDirectory() {
        return this.configDir;
    }

    public final void setConfigurationDirectory(String configDir) throws Exception {
        boolean started;
        File dir = new File(configDir.replace('/', File.separatorChar));
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("jboss.server.home.dir"), dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("no such directroy: " + dir);
        }
        ConfigHandler configHandler = new ConfigHandler();
        SAXParser p = SAXParserFactory.newInstance().newSAXParser();
        File[] configFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("-xmbean.xml");
            }
        });
        for (int i = 0; i < configFiles.length; ++i) {
            p.parse(configFiles[i], (DefaultHandler)configHandler);
        }
        boolean bl = started = this.getState() == 3;
        if (started) {
            this.unregisterAcnListeners();
        }
        this.configDir = configDir;
        this.notRegisteredAcnSources = configHandler.sources();
        if (started) {
            this.registerAcnListeners();
        }
    }

    protected void startService() throws Exception {
        this.registerMBeanServerListeners();
        this.registerAcnListeners();
        this.auditApplicationStart();
    }

    public void auditApplicationStart() {
        this.auditApplicationActivity(ApplicationActivityMessage.APPLICATION_START);
    }

    protected void stopService() {
        this.unregisterAcnListeners();
        this.unregisterMBeanServerListeners();
        this.auditApplicationStop();
    }

    public void auditApplicationStop() {
        this.auditApplicationActivity(ApplicationActivityMessage.APPLICATION_STOP);
    }

    private void auditApplicationActivity(AuditEvent.TypeCode type) {
        ApplicationActivityMessage msg = new ApplicationActivityMessage(type);
        msg.addApplication(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
        msg.addApplicationLauncher(this.getPrincipal(), null, null, AuditLogger.getHostname());
        Logger.getLogger((String)"auditlog").info((Object)msg);
    }

    private String getPrincipal() {
        Principal p = SecurityAssociation.getPrincipal();
        return p != null ? p.getName() : System.getProperty("user.name");
    }

    private static String getHostname() {
        try {
            HttpServletRequest rq = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
            return rq != null ? rq.getRemoteHost() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void registerAcnListeners() {
        Iterator<Map.Entry<ObjectName, AttributeChangeNotificationFilter[]>> iter = this.notRegisteredAcnSources.entrySet().iterator();
        while (iter.hasNext()) {
            AttributeChangeNotificationFilter[] acnf;
            Map.Entry<ObjectName, AttributeChangeNotificationFilter[]> entry = iter.next();
            ObjectName source = entry.getKey();
            if (!this.registerAcnListener(source, acnf = entry.getValue())) continue;
            this.registeredAcnSources.put(source, acnf);
            iter.remove();
        }
    }

    private void registerMBeanServerListeners() throws Exception {
        ObjectName serverDelegate = new ObjectName(MBEAN_SERVER_DELEGATE);
        this.server.addNotificationListener(serverDelegate, this.regl, REG_NOTIF_FILTER, null);
        this.server.addNotificationListener(serverDelegate, this.unregl, UNREG_NOTIF_FILTER, null);
    }

    private void unregisterMBeanServerListeners() {
        ObjectName serverDelegate;
        try {
            serverDelegate = new ObjectName(MBEAN_SERVER_DELEGATE);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        try {
            this.server.removeNotificationListener(serverDelegate, this.regl);
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.server.removeNotificationListener(serverDelegate, this.unregl);
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean registerAcnListener(ObjectName source, AttributeChangeNotificationFilter[] acnf) {
        if (!this.server.isRegistered(source)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(DEFER_REGISTER_ACNL + source));
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(REGISTER_ACNL + source));
        }
        int registered = 0;
        for (int i = 0; i < acnf.length; ++i) {
            if (acnf[i] == null) continue;
            try {
                this.server.addNotificationListener(source, this.acnl, (NotificationFilter)acnf[i], (Object)TYPE_CODES[i]);
                ++registered;
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)(FAILED_TO_REGISTER_ACNL + source), (Throwable)e);
                if (registered != 0) continue;
                return false;
            }
        }
        return true;
    }

    private void unregisterAcnListeners() {
        Iterator<Map.Entry<ObjectName, AttributeChangeNotificationFilter[]>> iter = this.registeredAcnSources.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ObjectName, AttributeChangeNotificationFilter[]> entry = iter.next();
            ObjectName source = entry.getKey();
            this.unregisterAcnListener(source);
            this.notRegisteredAcnSources.put(source, entry.getValue());
            iter.remove();
        }
    }

    private void unregisterAcnListener(ObjectName source) {
        if (this.server.isRegistered(source)) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(UNREGISTER_ACNL + source));
                }
                this.server.removeNotificationListener(source, this.acnl);
            }
            catch (Exception e) {
                this.log.warn((Object)(FAILED_TO_UNREGISTER_ACNL + source), (Throwable)e);
            }
        }
    }

    static /* synthetic */ String[] access$700() {
        return TYPES;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigHandler
    extends DefaultHandler {
        private final HashMap<ObjectName, AttributeChangeNotificationFilter[]> sources = new HashMap();
        private ObjectName source;
        private AttributeChangeNotificationFilter[] acnf = new AttributeChangeNotificationFilter[4];
        private List<String> types = Arrays.asList(AuditLogger.access$700());

        private ConfigHandler() {
        }

        public HashMap<ObjectName, AttributeChangeNotificationFilter[]> sources() {
            return this.sources;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            try {
                if (this.source != null) {
                    if (qName.equals("attribute")) {
                        int type = this.types.indexOf(attrs.getValue("type")) + 1;
                        if (this.acnf[type] == null) {
                            this.acnf[type] = new AttributeChangeNotificationFilter();
                        }
                        this.acnf[type].enableAttribute(attrs.getValue("name"));
                    }
                } else if (qName.equals("mbean")) {
                    this.source = new ObjectName(attrs.getValue("name"));
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private boolean hasAcnf() {
            return this.acnf[0] != null || this.acnf[1] != null || this.acnf[2] != null || this.acnf[3] != null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("mbean")) {
                if (this.hasAcnf()) {
                    this.sources.put(this.source, this.acnf);
                    this.acnf = new AttributeChangeNotificationFilter[4];
                }
                this.source = null;
            }
        }
    }
}

