/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTUtils {
    public static final String USER = "arr-user.xsl";
    public static final String OBJECT = "arr-object.xsl";
    public static final String DETAILS = "arr-details.xsl";
    private static HashMap<String, Templates> templates = new HashMap(4);
    private static SAXTransformerFactory tf;

    public static String render(String name, byte[] xmldata) {
        StringWriter writer = new StringWriter(512);
        XSLTUtils.render(name, xmldata, (Writer)writer);
        return writer.toString();
    }

    public static void render(String name, byte[] xmldata, Writer out) {
        try {
            XSLTUtils.render(XSLTUtils.getTemplates(name), xmldata, out);
        }
        catch (Exception e) {
            XSLTUtils.renderErrorMessage(e, out);
        }
    }

    private static void renderErrorMessage(Exception e, Writer out) {
        PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        pw.print("<u>");
        pw.print(e.getMessage());
        pw.print("</u> <pre>");
        e.printStackTrace(pw);
        pw.print("</pre>");
    }

    private static void render(Templates tpl, byte[] xmldata, Writer out) throws TransformerException {
        tpl.newTransformer().transform(new StreamSource(new ByteArrayInputStream(xmldata)), new StreamResult(out));
    }

    private static Templates getTemplates(String name) throws TransformerException {
        Templates tpl = templates.get(name);
        if (tpl == null) {
            tpl = XSLTUtils.loadTemplates(name);
            templates.put(name, tpl);
        }
        return tpl;
    }

    private static Templates loadTemplates(String name) throws TransformerException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return XSLTUtils.transfomerFactory().newTemplates(new StreamSource(cl.getResource(name).toString()));
    }

    private static SAXTransformerFactory transfomerFactory() {
        if (tf == null) {
            tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return tf;
    }
}

