/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.util.TagUtils;

public class DicomUtils {
    public static void format(InputStream in, String tsuid, int maxWidth, int maxValLen, StringBuffer out) throws IOException {
        DicomInputStream din = new DicomInputStream(in, tsuid);
        din.setHandler((DicomInputHandler)new FormatDicomInputHandler(maxWidth, maxValLen, out));
        din.readDicomObject();
    }

    public static String format(byte[] in, String tsuid, int maxWidth, int maxValLen) throws IOException {
        StringBuffer out = new StringBuffer(512);
        DicomUtils.format(new ByteArrayInputStream(in), tsuid, maxWidth, maxValLen, out);
        return out.toString();
    }

    static class FormatDicomInputHandler
    implements DicomInputHandler {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
        private final StringBuffer out;
        private final int maxWidth;
        private final int maxValLen;
        private final char[] cbuf = new char[64];
        private int maxEnd;

        public FormatDicomInputHandler(int maxWidth, int maxValLen, StringBuffer out) {
            this.maxWidth = maxWidth;
            this.maxValLen = maxValLen;
            this.out = out;
        }

        public boolean readValue(DicomInputStream in) throws IOException {
            switch (in.tag()) {
                case -73728: {
                    if (in.sq().vr() != VR.SQ && in.valueLength() != -1) {
                        this.formatFragment(in);
                        break;
                    }
                    this.formatItem(in);
                    break;
                }
                case -73715: 
                case -73507: {
                    if (in.level() <= 0) break;
                    this.formatItem(in);
                    break;
                }
                default: {
                    this.formatElement(in);
                }
            }
            return true;
        }

        private void formatElement(DicomInputStream in) throws IOException {
            this.appendTag(in);
            this.appendVR(in);
            this.appendLen(in);
            if (this.hasItems(in)) {
                this.appendName(in);
                this.readItems(in);
            } else {
                this.appendValue(in);
                this.appendName(in);
            }
        }

        private void appendValue(DicomInputStream in) throws IOException {
            int tag = in.tag();
            VR vr = in.vr();
            byte[] val = in.readBytes(in.valueLength());
            DicomObject dcmobj = in.getDicomObject();
            boolean bigEndian = in.getTransferSyntax().bigEndian();
            this.out.append(" [");
            vr.promptValue(val, bigEndian, dcmobj.getSpecificCharacterSet(), this.cbuf, this.maxValLen, this.out);
            this.out.append("]");
            if (tag == 524293 || tag == 131088 || TagUtils.isPrivateCreatorDataElement((int)tag)) {
                dcmobj.putBytes(tag, vr, val, bigEndian);
            }
            if (tag == 131072) {
                in.setEndOfFileMetaInfoPosition(in.getStreamPosition() + (long)vr.toInt(val, bigEndian));
            }
        }

        private boolean hasItems(DicomInputStream in) {
            return in.valueLength() == -1 || in.vr() == VR.SQ;
        }

        private void readItems(DicomInputStream in) throws IOException {
            in.readValue(in);
            in.getDicomObject().remove(in.tag());
        }

        private void formatItem(DicomInputStream in) throws IOException {
            this.appendTag(in);
            this.appendLen(in);
            this.appendName(in);
            in.readValue(in);
        }

        private void formatFragment(DicomInputStream in) throws IOException {
            this.appendTag(in);
            this.appendLen(in);
            in.readValue(in);
            DicomElement sq = in.sq();
            byte[] data = sq.removeFragment(0);
            boolean bigEndian = in.getTransferSyntax().bigEndian();
            this.out.append(" [");
            sq.vr().promptValue(data, bigEndian, null, this.cbuf, this.maxValLen, this.out);
            this.out.append("]");
            this.appendName(in);
        }

        private void appendTag(DicomInputStream in) {
            this.maxEnd = this.out.length() + this.maxWidth;
            for (int i = in.level(); i > 0; --i) {
                this.out.append('>');
            }
            TagUtils.toStringBuffer((int)in.tag(), (StringBuffer)this.out);
        }

        private void appendVR(DicomInputStream in) {
            this.out.append(" ").append(in.vr());
        }

        private void appendLen(DicomInputStream in) {
            this.out.append(" #").append(in.valueLength());
        }

        private void appendName(DicomInputStream in) {
            this.out.append(" ").append(in.getDicomObject().nameOf(in.tag()));
            if (this.out.length() > this.maxEnd) {
                this.out.setLength(this.maxEnd);
            }
            this.out.append(LINE_SEPARATOR);
        }
    }
}

