/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.io.UnsupportedEncodingException;

public class Base64Decoder {
    private static final byte[] BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String decodeToUTF8(String s) {
        try {
            return new String(Base64Decoder.decode(s), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decode(String s) {
        KillWhiteSpace kws = new KillWhiteSpace(s);
        int sLen = kws.length();
        int groups = sLen / 4;
        if (4 * groups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missing = 0;
        int fullGroups = groups;
        if (sLen != 0 && kws.last() == '=') {
            missing = kws.lastButOne() == '=' ? 2 : 1;
            --fullGroups;
        }
        byte[] out = new byte[3 * groups - missing];
        int writePos = 0;
        for (int i = 0; i < fullGroups; ++i) {
            byte b1 = BYTES[kws.next()];
            byte b12 = BYTES[kws.next()];
            byte b23 = BYTES[kws.next()];
            byte b3 = BYTES[kws.next()];
            out[writePos++] = (byte)(b1 << 2 | b12 >> 4);
            out[writePos++] = (byte)(b12 << 4 | b23 >> 2);
            out[writePos++] = (byte)(b23 << 6 | b3);
        }
        if (missing != 0) {
            byte b1 = BYTES[kws.next()];
            byte b12 = BYTES[kws.next()];
            out[writePos++] = (byte)(b1 << 2 | b12 >> 4);
            if (missing == 1) {
                byte b23 = BYTES[kws.next()];
                out[writePos++] = (byte)(b12 << 4 | b23 >> 2);
            }
        }
        return out;
    }

    private static class KillWhiteSpace {
        private final String s;
        private int index;

        KillWhiteSpace(String s) {
            this.s = s;
        }

        public char next() {
            char c;
            while ((c = this.s.charAt(this.index++)) <= ' ') {
            }
            return c;
        }

        public char last() {
            char c;
            int i = this.s.length();
            while ((c = this.s.charAt(--i)) <= ' ') {
            }
            return c;
        }

        public char lastButOne() {
            char c;
            int i = this.s.length();
            while ((c = this.s.charAt(--i)) <= ' ') {
            }
            while ((c = this.s.charAt(--i)) <= ' ') {
            }
            return c;
        }

        public int length() {
            int sLen = this.s.length();
            int n = sLen;
            for (int i = 0; i < n; ++i) {
                if (this.s.charAt(i) > ' ') continue;
                --sLen;
            }
            return sLen;
        }
    }
}

