/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.seam.ejb.AuditLogUsedLocal;
import org.dcm4chee.arr.seam.ejb.AuditRecordQueryLocal;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AuditRecordQueryBean
implements AuditRecordQueryLocal {
    @EJB
    private transient AuditLogUsedLocal auditLogUsed;
    @PersistenceContext(unitName="dcm4chee-arr")
    private transient Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> findRecords(HttpServletRequest rq) {
        AuditEvent.OutcomeIndicator outcome = AuditEvent.OutcomeIndicator.MINOR_FAILURE;
        try {
            Criteria criteria = this.session.createCriteria(AuditRecord.class);
            AuditRecordQueryBean.buildCriteria(criteria, rq);
            outcome = AuditEvent.OutcomeIndicator.MAJOR_FAILURE;
            List result = criteria.list();
            outcome = AuditEvent.OutcomeIndicator.SUCCESS;
            List list = result;
            return list;
        }
        finally {
            this.auditLogUsed.log(rq, outcome);
        }
    }

    private static void buildCriteria(Criteria criteria, HttpServletRequest rq) {
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
        criteria.setProjection((Projection)Projections.property((String)"xmldata"));
        AuditRecordQueryBean.addCriteriaForEvent(criteria, rq);
        AuditRecordQueryBean.addCriteriaForActiveParticipant(criteria, rq);
        AuditRecordQueryBean.addCriteriaForAuditSource(criteria, rq);
        AuditRecordQueryBean.addCriteriaForParticipantObject(criteria, rq);
        criteria.addOrder(Order.desc((String)"eventDateTime"));
        AuditRecordQueryBean.setMaxResults(criteria, rq);
    }

    private static void addCriteriaForEvent(Criteria criteria, HttpServletRequest rq) {
        Object[] eventActions;
        Object[] eventOutcomes;
        String[][] eventTypes;
        String[][] eventIDs;
        Date upperDateTime;
        Date lowerDateTime = AuditRecordQueryBean.getDateTime(rq, "lowerDateTime");
        if (lowerDateTime != null) {
            criteria.add((Criterion)Expression.ge((String)"eventDateTime", (Object)lowerDateTime));
        }
        if ((upperDateTime = AuditRecordQueryBean.getDateTime(rq, "upperDateTime")) != null) {
            criteria.add((Criterion)Expression.le((String)"eventDateTime", (Object)upperDateTime));
        }
        if ((eventIDs = AuditRecordQueryBean.getCodes(rq, "eventID")) != null) {
            criteria.createAlias("eventID", "ei").add((Criterion)AuditRecordQueryBean.getCodeStringCriteria("ei", eventIDs));
        }
        if ((eventTypes = AuditRecordQueryBean.getCodes(rq, "eventTypeCode")) != null) {
            criteria.createAlias("eventType", "et").add((Criterion)AuditRecordQueryBean.getCodeStringCriteria("et", eventTypes));
        }
        if ((eventOutcomes = AuditRecordQueryBean.getIntegers(rq, "eventOutcomeIndicator")) != null) {
            criteria.add(Expression.in((String)"eventOutcome", (Object[])eventOutcomes));
        }
        if ((eventActions = rq.getParameterValues("eventActionCode")) != null) {
            criteria.add(Expression.in((String)"eventAction", (Object[])eventActions));
        }
    }

    private static void addCriteriaForActiveParticipant(Criteria criteria, HttpServletRequest rq) {
        String userID = rq.getParameter("userID");
        String altUserID = rq.getParameter("alternativeUserID");
        String userName = rq.getParameter("userName");
        Boolean userIsRequestor = AuditRecordQueryBean.getBoolean(rq, "userIsRequestor");
        String[][] roleIDs = AuditRecordQueryBean.getCodes(rq, "roleIDCode");
        String napID = rq.getParameter("networkAccessPointID");
        Object[] napTypes = rq.getParameterValues("networkAccessPointTypeCode");
        if (userID != null || altUserID != null || userName != null || userIsRequestor != null || roleIDs != null || napID != null || napTypes != null) {
            criteria.createAlias("activeParticipants", "ap1");
            Conjunction criterion = Expression.conjunction();
            if (userID != null) {
                criterion.add((Criterion)Expression.like((String)"ap1.userID", (Object)userID));
            }
            if (altUserID != null) {
                criterion.add((Criterion)Expression.like((String)"ap1.alternativeUserID", (Object)altUserID));
            }
            if (userName != null) {
                criterion.add(Expression.ilike((String)"ap1.userName", (Object)userName));
            }
            if (userIsRequestor != null) {
                criterion.add((Criterion)Expression.eq((String)"ap1.userIsRequestor", (Object)userIsRequestor));
            }
            if (roleIDs != null) {
                criteria.createAlias("ap1.roleID", "rid1");
                criterion.add((Criterion)AuditRecordQueryBean.getCodeStringCriteria("rid1", roleIDs));
            }
            if (napID != null) {
                criterion.add((Criterion)Expression.like((String)"ap1.networkAccessPointID", (Object)napID));
            }
            if (napTypes != null) {
                criterion.add(Expression.in((String)"ap1.networkAccessPointType", (Object[])napTypes));
            }
            criteria.add((Criterion)criterion);
        }
    }

    private static void addCriteriaForAuditSource(Criteria criteria, HttpServletRequest rq) {
        Object[] sourceTypes;
        String siteID;
        String sourceID = rq.getParameter("auditSourceID");
        if (sourceID != null) {
            criteria.add((Criterion)Expression.like((String)"sourceID", (Object)sourceID));
        }
        if ((siteID = rq.getParameter("auditEnterpriseSiteID")) != null) {
            criteria.add((Criterion)Expression.like((String)"enterpriseSiteID", (Object)siteID));
        }
        if ((sourceTypes = AuditRecordQueryBean.getIntegers(rq, "auditSourceTypeCode")) != null) {
            criteria.add(Expression.in((String)"sourceType", (Object[])sourceTypes));
        }
    }

    private static void addCriteriaForParticipantObject(Criteria criteria, HttpServletRequest rq) {
        String objectID = rq.getParameter("participantObjectID");
        String[] objectIDTypes = rq.getParameterValues("participantObjectTypeCode");
        String objectName = rq.getParameter("participantObjectName");
        Object[] objectTypes = AuditRecordQueryBean.getIntegers(rq, "participantObjectTypeCode");
        Object[] objectRoles = AuditRecordQueryBean.getIntegers(rq, "participantObjectTypeCodeRole");
        Object[] lifeCycles = AuditRecordQueryBean.getIntegers(rq, "participantObjectDataLifeCycle");
        if (objectID != null || objectIDTypes != null || objectName != null || objectTypes != null || objectRoles != null || lifeCycles != null) {
            criteria.createAlias("participantObjects", "po");
            if (objectID != null) {
                criteria.add((Criterion)Expression.like((String)"po.objectID", (Object)objectID));
            }
            if (objectIDTypes != null) {
                ArrayList<Integer> rfcIDTypes = new ArrayList<Integer>(objectIDTypes.length);
                ArrayList<String[]> codeIDTypes = new ArrayList<String[]>(objectIDTypes.length);
                for (String idType : objectIDTypes) {
                    String[] code = idType.split("\\^");
                    if (code.length >= 2) {
                        codeIDTypes.add(code);
                        continue;
                    }
                    try {
                        rfcIDTypes.add(Integer.valueOf(idType));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Error:participantObjectTypeCode parameter is invalid! Must be an integer or in format code^codeSystemName");
                    }
                }
                if (!codeIDTypes.isEmpty()) {
                    criteria.createAlias("po.objectIDType", "pooit");
                }
                if (!rfcIDTypes.isEmpty()) {
                    if (!codeIDTypes.isEmpty()) {
                        criteria.add((Criterion)Expression.or((Criterion)AuditRecordQueryBean.getCodeStringCriteria("pooit", (String[][])codeIDTypes.toArray((T[])new String[0][])), (Criterion)Expression.in((String)"po.objectIDTypeRFC", (Object[])rfcIDTypes.toArray(new Integer[0]))));
                    } else {
                        criteria.add(Expression.in((String)"po.objectIDTypeRFC", (Object[])rfcIDTypes.toArray(new Integer[0])));
                    }
                } else {
                    criteria.add((Criterion)AuditRecordQueryBean.getCodeStringCriteria("pooit", (String[][])codeIDTypes.toArray((T[])new String[0][])));
                }
            }
            if (objectName != null) {
                criteria.add(Expression.ilike((String)"po.objectName", (Object)objectName));
            }
            if (objectTypes != null) {
                criteria.add(Expression.in((String)"po.objectType", (Object[])objectTypes));
            }
            if (objectRoles != null) {
                criteria.add(Expression.in((String)"po.objectRole", (Object[])objectRoles));
            }
            if (lifeCycles != null) {
                criteria.add(Expression.in((String)"po.dataLifeCycle", (Object[])lifeCycles));
            }
        }
    }

    private static Disjunction getCodeStringCriteria(String alias, String[][] codeStrings) {
        Disjunction disjuncation = Expression.disjunction();
        for (String[] codeString : codeStrings) {
            disjuncation.add((Criterion)Expression.conjunction().add((Criterion)Expression.eq((String)(alias + ".value"), (Object)codeString[0])).add((Criterion)Expression.eq((String)(alias + ".designator"), (Object)codeString[1])));
        }
        return disjuncation;
    }

    private static void setMaxResults(Criteria criteria, HttpServletRequest rq) {
        int mostRecentResults = AuditRecordQueryBean.getInt(rq, "mostRecentResults");
        if (mostRecentResults > 0) {
            criteria.setMaxResults(mostRecentResults);
        }
    }

    private static int getInt(HttpServletRequest rq, String name) {
        String s = rq.getParameter(name);
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error: " + name + " parameter is invalid! Must be an integer");
        }
    }

    private static Boolean getBoolean(HttpServletRequest rq, String name) {
        String s = rq.getParameter(name);
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Error: " + name + " parameter is invalid! Must be \"true\" or \"false\"");
    }

    private static Integer[] getIntegers(HttpServletRequest rq, String name) {
        String[] ss = rq.getParameterValues(name);
        if (ss == null) {
            return null;
        }
        try {
            Integer[] is = new Integer[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                is[i] = Integer.valueOf(ss[i]);
            }
            return is;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error: " + name + " parameter is invalid! Must be an integer");
        }
    }

    private static Date getDateTime(HttpServletRequest rq, String name) {
        String s = rq.getParameter(name);
        if (s == null) {
            return null;
        }
        try {
            Calendar cal;
            int tzindex = AuditRecordQueryBean.indexOfTimeZone(s);
            if (tzindex == -1) {
                cal = Calendar.getInstance();
            } else {
                cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.set(15, AuditRecordQueryBean.timeZoneOffset(s, tzindex));
                s = s.substring(0, tzindex);
            }
            cal.set(1, Integer.parseInt(s.substring(0, 4)));
            cal.set(2, Integer.parseInt(s.substring(5, 7)) - 1);
            cal.set(5, Integer.parseInt(s.substring(8, 10)));
            cal.set(11, Integer.parseInt(s.substring(11, 13)));
            cal.set(12, Integer.parseInt(s.substring(14, 16)));
            cal.set(13, Integer.parseInt(s.substring(17, 19)));
            cal.set(14, s.length() <= 20 ? 0 : (int)(Float.parseFloat(s.substring(19)) * 1000.0f));
            return cal.getTime();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error: " + name + " parameter is invalid! Must be in format yyyy-mm-ddThh:mm:ss.");
        }
    }

    private static int indexOfTimeZone(String s) {
        int len = s.length();
        int index = len - 1;
        char c = s.charAt(index);
        if (c == 'Z') {
            return index;
        }
        index = len - 6;
        c = s.charAt(index);
        if (c == '-' || c == '+') {
            return index;
        }
        return -1;
    }

    private static int timeZoneOffset(String s, int tzindex) {
        char c = s.charAt(tzindex);
        if (c == 'Z') {
            return 0;
        }
        int off = Integer.parseInt(s.substring(tzindex + 1, tzindex + 3)) * 3600000 + Integer.parseInt(s.substring(tzindex + 4)) * 60000;
        return c == '-' ? -off : off;
    }

    private static String[][] getCodes(HttpServletRequest rq, String name) {
        String[] ss = rq.getParameterValues(name);
        if (ss == null) {
            return null;
        }
        String[][] codes = new String[ss.length][];
        for (int i = 0; i < ss.length; ++i) {
            codes[i] = ss[i].split("\\^");
            if (codes[i].length >= 2) continue;
            throw new IllegalArgumentException("Error: " + name + " parameter is invalid! Must be in format code^codeSystemName");
        }
        return codes;
    }
}

