/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.PersistenceContext;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.seam.ejb.AuditLogUsedLocal;
import org.dcm4chee.arr.seam.ejb.AuditRecordEntry;
import org.dcm4chee.arr.seam.ejb.AuditRecordList;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.jboss.annotation.ejb.cache.simple.CacheConfig;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.log.Log;

@Stateful
@Name(value="auditRecordList")
@Scope(value=ScopeType.SESSION)
@CacheConfig(idleTimeoutSeconds=900L)
public class AuditRecordListAction
implements Serializable,
AuditRecordList {
    private static final long serialVersionUID = 8681124252579882410L;
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int YEAR = 4;
    private static final int MONTH = 7;
    private static final int DAY_OF_MONTH = 10;
    private static final int HOUR_OF_DAY = 13;
    private static final int MINUTE = 16;
    private static final int SECOND = 19;
    @Logger
    private transient Log log;
    @EJB
    private transient AuditLogUsedLocal auditLogUsed;
    @PersistenceContext(unitName="dcm4chee-arr")
    private transient Session session;
    @DataModel
    private List<AuditRecordEntry> records;
    @RequestParameter
    private Integer page;
    private int curPage = 1;
    private int pageSize = 20;
    private int count = 0;
    private boolean orderByEventDateTime = true;
    private String dateTimeRange = AuditRecordListAction.today();
    private String[] eventIDs = new String[]{""};
    private String[] eventTypes = new String[]{""};
    private String[] eventActions = new String[]{""};
    private String[] eventOutcomes = new String[]{""};
    private String userID1 = "";
    private String altUserID1 = "";
    private String userName1 = "";
    private String userIsRequestor1 = "any";
    private String[] roleIDs1 = new String[]{""};
    private String[] napTypes1 = new String[]{""};
    private String napID1 = "";
    private String userID2 = "";
    private String altUserID2 = "";
    private String userName2 = "";
    private String userIsRequestor2 = "any";
    private String[] roleIDs2 = new String[]{""};
    private String[] napTypes2 = new String[]{""};
    private String napID2 = "";
    private String siteID = "";
    private String sourceID = "";
    private String[] sourceTypes = new String[]{""};
    private String[] objectTypes = new String[]{""};
    private String[] objectRoles = new String[]{""};
    private String[] lifeCycles = new String[]{""};
    private String[] objectIDTypes = new String[]{""};
    private String objectID = "";
    private String objectName = "";

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCount() {
        return this.count;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getMinPage() {
        return Math.max(1, Math.min(this.curPage, this.getLastPage() - 5) - 4);
    }

    public int getMaxPage() {
        return Math.min(this.getLastPage(), Math.max(5, this.curPage) + 4);
    }

    public int getLastPage() {
        return (this.count - 1) / this.pageSize + 1;
    }

    public int getFirstResult() {
        return (this.curPage - 1) * this.pageSize;
    }

    private static String today() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    public String getDateTimeRange() {
        return this.dateTimeRange;
    }

    public void setDateTimeRange(String dt) {
        this.dateTimeRange = dt;
    }

    public boolean isOrderByEventDateTime() {
        return this.orderByEventDateTime;
    }

    public void setOrderByEventDateTime(boolean enable) {
        this.orderByEventDateTime = enable;
    }

    public String[] getEventIDs() {
        return this.eventIDs;
    }

    public void setEventIDs(String[] ids) {
        this.eventIDs = ids;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(String[] types) {
        this.eventTypes = types;
    }

    public String[] getEventActions() {
        return this.eventActions;
    }

    public void setEventActions(String[] actions) {
        this.eventActions = actions;
    }

    public String[] getEventOutcomes() {
        return this.eventOutcomes;
    }

    public void setEventOutcomes(String[] outcomes) {
        this.eventOutcomes = outcomes;
    }

    public String getUserID1() {
        return this.userID1;
    }

    public void setUserID1(String id) {
        this.userID1 = id;
    }

    public String getAltUserID1() {
        return this.altUserID1;
    }

    public void setAltUserID1(String id) {
        this.altUserID1 = id;
    }

    public String getUserName1() {
        return this.userName1;
    }

    public void setUserName1(String name) {
        this.userName1 = name;
    }

    public String getUserIsRequestor1() {
        return this.userIsRequestor1;
    }

    public void setUserIsRequestor1(String requestor) {
        this.userIsRequestor1 = requestor;
    }

    public String[] getRoleIDs1() {
        return this.roleIDs1;
    }

    public void setRoleIDs1(String[] ids) {
        this.roleIDs1 = ids;
    }

    public String[] getNapTypes1() {
        return this.napTypes1;
    }

    public void setNapTypes1(String[] types) {
        this.napTypes1 = types;
    }

    public String getNapID1() {
        return this.napID1;
    }

    public void setNapID1(String id) {
        this.napID1 = id;
    }

    public String getUserID2() {
        return this.userID2;
    }

    public void setUserID2(String id) {
        this.userID2 = id;
    }

    public String getAltUserID2() {
        return this.altUserID2;
    }

    public void setAltUserID2(String id) {
        this.altUserID2 = id;
    }

    public String getUserName2() {
        return this.userName2;
    }

    public void setUserName2(String name) {
        this.userName2 = name;
    }

    public String getUserIsRequestor2() {
        return this.userIsRequestor2;
    }

    public void setUserIsRequestor2(String requestor) {
        this.userIsRequestor2 = requestor;
    }

    public String[] getRoleIDs2() {
        return this.roleIDs2;
    }

    public void setRoleIDs2(String[] ids) {
        this.roleIDs2 = ids;
    }

    public String[] getNapTypes2() {
        return this.napTypes2;
    }

    public void setNapTypes2(String[] types) {
        this.napTypes2 = types;
    }

    public String getNapID2() {
        return this.napID2;
    }

    public void setNapID2(String id) {
        this.napID2 = id;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public void setSiteID(String id) {
        this.siteID = id;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(String id) {
        this.sourceID = id;
    }

    public String[] getSourceTypes() {
        return this.sourceTypes;
    }

    public void setSourceTypes(String[] types) {
        this.sourceTypes = types;
    }

    public String[] getObjectTypes() {
        return this.objectTypes;
    }

    public void setObjectTypes(String[] types) {
        this.objectTypes = types;
    }

    public String[] getObjectRoles() {
        return this.objectRoles;
    }

    public void setObjectRoles(String[] roles) {
        this.objectRoles = roles;
    }

    public String[] getLifeCycles() {
        return this.lifeCycles;
    }

    public void setLifeCycles(String[] lifeCycles) {
        this.lifeCycles = lifeCycles;
    }

    public String[] getObjectIDTypes() {
        return this.objectIDTypes;
    }

    public void setObjectIDTypes(String[] types) {
        this.objectIDTypes = types;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String id) {
        this.objectID = id;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Factory(value="records")
    public void find() {
        this.curPage = 1;
        this.updateResults();
        this.sendAuditLogUsedMessage();
    }

    private void sendAuditLogUsedMessage() {
        try {
            this.auditLogUsed.log((HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY), AuditEvent.OutcomeIndicator.SUCCESS);
        }
        catch (PolicyContextException e) {
            this.log.warn((Object)"Failed to create Audit Log Used message", (Throwable)e, new Object[0]);
        }
    }

    public void selectPage() {
        this.curPage = this.page;
        this.updateResults();
    }

    private void updateResults() {
        Criteria recordsCriteria = this.buildCriteria(this.session.createCriteria(AuditRecord.class));
        this.count = (Integer)recordsCriteria.setProjection(Projections.rowCount()).list().iterator().next();
        int from = this.getFirstResult();
        List result = recordsCriteria.setProjection(null).setResultTransformer(Criteria.ROOT_ENTITY).setFirstResult(from).setMaxResults(this.pageSize).addOrder(Order.desc((String)(this.orderByEventDateTime ? "eventDateTime" : "receiveDateTime"))).list();
        this.records = new ArrayList<AuditRecordEntry>(result.size());
        for (AuditRecord record : result) {
            this.records.add(new AuditRecordEntry(record));
        }
    }

    private Criteria buildCriteria(Criteria criteria) {
        this.addCriteriaForEvent(criteria);
        this.addCriteriaForAuditSource(criteria);
        this.addCriteriaForParticipantObject(criteria);
        if (this.hasCriteriaForActiveParticipant1()) {
            if (this.hasCriteriaForActiveParticipant2()) {
                criteria.add((Criterion)Expression.disjunction().add(this.addCriteriaForActiveParticipant1(criteria)).add(this.addCriteriaForActiveParticipant2(criteria)));
            } else {
                criteria.add(this.addCriteriaForActiveParticipant1(criteria));
            }
        } else if (this.hasCriteriaForActiveParticipant2()) {
            criteria.add(this.addCriteriaForActiveParticipant2(criteria));
        }
        return criteria;
    }

    private Criteria addCriteriaForEvent(Criteria criteria) {
        Date[] dtRange;
        try {
            dtRange = this.parseDateTimeRange();
        }
        catch (Exception e) {
            this.dateTimeRange = AuditRecordListAction.today();
            try {
                dtRange = this.parseDateTimeRange();
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        if (dtRange != null) {
            criteria.add(Expression.between((String)(this.orderByEventDateTime ? "eventDateTime" : "receiveDateTime"), (Object)dtRange[0], (Object)dtRange[1]));
        }
        if (this.hasCriteria(this.eventIDs)) {
            criteria.createAlias("eventID", "ei").add((Criterion)AuditRecordListAction.getCodeStringCriteria("ei", this.eventIDs));
        }
        if (this.hasCriteria(this.eventTypes)) {
            criteria.createAlias("eventType", "et").add((Criterion)AuditRecordListAction.getCodeStringCriteria("et", this.eventTypes));
        }
        if (this.hasCriteria(this.eventOutcomes)) {
            criteria.add(Expression.in((String)"eventOutcome", (Object[])this.toIntegerArray(this.eventOutcomes)));
        }
        if (this.hasCriteria(this.eventActions)) {
            criteria.add(Expression.in((String)"eventAction", (Object[])this.eventActions));
        }
        return criteria;
    }

    private Criteria addCriteriaForAuditSource(Criteria criteria) {
        if (this.hasCriteria(this.siteID)) {
            criteria.add(Expression.ilike((String)"enterpriseSiteID", (String)this.siteID, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.sourceID)) {
            criteria.add(Expression.ilike((String)"sourceID", (String)this.sourceID, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.sourceTypes)) {
            criteria.add(Expression.in((String)"sourceType", (Object[])this.toIntegerArray(this.sourceTypes)));
        }
        return criteria;
    }

    private Criterion addCriteriaForActiveParticipant1(Criteria criteria) {
        criteria.createAlias("activeParticipants", "ap1");
        Conjunction criterion = Expression.conjunction();
        if (this.hasCriteria(this.userID1)) {
            criterion.add(Expression.ilike((String)"ap1.userID", (String)this.userID1, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.altUserID1)) {
            criterion.add(Expression.ilike((String)"ap1.alternativeUserID", (String)this.altUserID1, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.userName1)) {
            criterion.add(Expression.ilike((String)"ap1.userName", (String)this.userName1, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteriaBoolean(this.userIsRequestor1)) {
            criterion.add((Criterion)Expression.eq((String)"ap1.userIsRequestor", (Object)Boolean.valueOf(this.userIsRequestor1)));
        }
        if (this.hasCriteria(this.roleIDs1)) {
            criteria.createAlias("ap1.roleID", "rid1");
            criterion.add((Criterion)AuditRecordListAction.getCodeStringCriteria("rid1", this.roleIDs1));
        }
        if (this.hasCriteria(this.napTypes1)) {
            criterion.add(Expression.in((String)"ap1.networkAccessPointType", (Object[])this.toIntegerArray(this.napTypes1)));
        }
        if (this.hasCriteria(this.napID1)) {
            criterion.add(Expression.ilike((String)"ap1.networkAccessPointID", (String)this.napID1, (MatchMode)MatchMode.START));
        }
        return criterion;
    }

    private Criterion addCriteriaForActiveParticipant2(Criteria criteria) {
        criteria.createAlias("activeParticipants", "ap2");
        Conjunction criterion = Expression.conjunction();
        if (this.hasCriteria(this.userID2)) {
            criterion.add(Expression.ilike((String)"ap2.userID", (String)this.userID2, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.altUserID2)) {
            criterion.add(Expression.ilike((String)"ap2.alternativeUserID", (String)this.altUserID2, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.userName2)) {
            criterion.add(Expression.ilike((String)"ap2.userName", (String)this.userName2, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteriaBoolean(this.userIsRequestor2)) {
            criterion.add((Criterion)Expression.eq((String)"ap2.userIsRequestor", (Object)Boolean.valueOf(this.userIsRequestor2)));
        }
        if (this.hasCriteria(this.roleIDs2)) {
            criteria.createAlias("ap2.roleID", "rid2");
            criterion.add((Criterion)AuditRecordListAction.getCodeStringCriteria("rid2", this.roleIDs2));
        }
        if (this.hasCriteria(this.napTypes2)) {
            criterion.add(Expression.in((String)"ap2.networkAccessPointType", (Object[])this.toIntegerArray(this.napTypes2)));
        }
        if (this.hasCriteria(this.napID2)) {
            criterion.add(Expression.ilike((String)"ap2.networkAccessPointID", (Object)(this.napID2 + "%")));
        }
        return criterion;
    }

    private Criteria addCriteriaForParticipantObject(Criteria criteria) {
        if (!(this.hasCriteria(this.objectTypes) || this.hasCriteria(this.objectRoles) || this.hasCriteria(this.lifeCycles) || this.hasCriteria(this.objectIDTypes) || this.hasCriteria(this.objectID) || this.hasCriteria(this.objectName))) {
            return criteria;
        }
        criteria.createAlias("participantObjects", "po");
        if (this.hasCriteria(this.objectTypes)) {
            criteria.add(Expression.in((String)"po.objectType", (Object[])this.toIntegerArray(this.objectTypes)));
        }
        if (this.hasCriteria(this.objectRoles)) {
            criteria.add(Expression.in((String)"po.objectRole", (Object[])this.toIntegerArray(this.objectRoles)));
        }
        if (this.hasCriteria(this.lifeCycles)) {
            criteria.add(Expression.in((String)"po.dataLifeCycle", (Object[])this.toIntegerArray(this.lifeCycles)));
        }
        if (this.hasCriteria(this.objectIDTypes)) {
            ArrayList<Integer> rfcIDTypes = new ArrayList<Integer>();
            ArrayList<String> codeIDTypes = new ArrayList<String>();
            for (String idType : this.objectIDTypes) {
                if (idType.indexOf("^") > 0) {
                    codeIDTypes.add(idType);
                    continue;
                }
                rfcIDTypes.add(Integer.valueOf(idType));
            }
            if (codeIDTypes.size() > 0) {
                criteria.createAlias("po.objectIDType", "pooit");
            }
            if (rfcIDTypes.size() > 0) {
                if (codeIDTypes.size() > 0) {
                    criteria.add((Criterion)Expression.or((Criterion)AuditRecordListAction.getCodeStringCriteria("pooit", codeIDTypes.toArray(new String[0])), (Criterion)Expression.in((String)"po.objectIDTypeRFC", (Object[])rfcIDTypes.toArray(new Integer[0]))));
                } else {
                    criteria.add(Expression.in((String)"po.objectIDTypeRFC", (Object[])rfcIDTypes.toArray(new Integer[0])));
                }
            } else {
                criteria.add((Criterion)AuditRecordListAction.getCodeStringCriteria("pooit", codeIDTypes.toArray(new String[0])));
            }
        }
        if (this.hasCriteria(this.objectID)) {
            criteria.add(Expression.ilike((String)"po.objectID", (String)this.objectID, (MatchMode)MatchMode.START));
        }
        if (this.hasCriteria(this.objectName)) {
            criteria.add(Expression.ilike((String)"po.objectName", (String)this.objectName, (MatchMode)MatchMode.START));
        }
        return criteria;
    }

    private static Disjunction getCodeStringCriteria(String alias, String[] codeStrings) {
        Disjunction disjuncation = Expression.disjunction();
        for (String codeString : codeStrings) {
            String[] arr = codeString.split("\\^");
            disjuncation.add((Criterion)Expression.conjunction().add((Criterion)Expression.eq((String)(alias + ".value"), (Object)arr[0])).add((Criterion)Expression.eq((String)(alias + ".designator"), (Object)arr[1])));
        }
        return disjuncation;
    }

    private boolean hasCriteriaForActiveParticipant1() {
        return this.hasCriteria(this.userID1) || this.hasCriteria(this.altUserID1) || this.hasCriteria(this.userName1) || this.hasCriteriaBoolean(this.userIsRequestor1) || this.hasCriteria(this.roleIDs1) || this.hasCriteria(this.napTypes1) || this.hasCriteria(this.napID1);
    }

    private boolean hasCriteriaForActiveParticipant2() {
        return this.hasCriteria(this.userID2) || this.hasCriteria(this.altUserID2) || this.hasCriteria(this.userName2) || this.hasCriteriaBoolean(this.userIsRequestor2) || this.hasCriteria(this.roleIDs2) || this.hasCriteria(this.napTypes2) || this.hasCriteria(this.napID2);
    }

    private boolean hasCriteriaBoolean(String var) {
        return var != null && var.trim().length() > 0 && !var.equalsIgnoreCase("any");
    }

    private boolean hasCriteria(String var) {
        return var != null && var.trim().length() > 0;
    }

    private boolean hasCriteria(String[] vars) {
        if (vars == null) {
            return false;
        }
        if (vars.length == 1 && vars[0].trim().length() == 0) {
            return false;
        }
        for (String elm : vars) {
            if (elm.trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    private Integer[] toIntegerArray(String[] vars) {
        Integer[] ints = new Integer[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            ints[i] = Integer.valueOf(vars[i]);
        }
        return ints;
    }

    private Date[] parseDateTimeRange() throws ParseException {
        int dtlen = this.dateTimeRange.length();
        if (dtlen == 0) {
            return null;
        }
        if (dtlen < 4) {
            throw new ParseException("Missing year", dtlen);
        }
        String dtformat = DATE_TIME_FORMAT.substring(0, dtlen);
        Date[] dtRange = new Date[2];
        dtRange[0] = new SimpleDateFormat(dtformat).parse(this.dateTimeRange);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtRange[0]);
        cal.set(14, 999);
        if (dtlen < 19) {
            cal.set(13, 59);
            if (dtlen < 16) {
                cal.set(12, 59);
                if (dtlen < 13) {
                    cal.set(11, 23);
                    if (dtlen < 10) {
                        if (dtlen < 7) {
                            cal.set(2, 11);
                        }
                        cal.add(2, 1);
                        cal.add(5, -1);
                    }
                }
            }
        }
        dtRange[1] = cal.getTime();
        return dtRange;
    }

    @Destroy
    @Remove
    public void destroy() {
    }
}

