/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.util.Date;
import org.dcm4chee.arr.entities.AuditRecord;
import org.dcm4chee.arr.entities.Code;
import org.dcm4chee.arr.seam.ejb.XSLTUtils;
import org.jboss.seam.annotations.Name;

@Name(value="audit_record")
public class AuditRecordEntry {
    private final AuditRecord auditRecord;

    public AuditRecordEntry(AuditRecord auditRecord) {
        this.auditRecord = auditRecord;
    }

    public String getActiveParticipants() {
        return XSLTUtils.render("arr-user.xsl", this.auditRecord.getXmldata());
    }

    public String getEnterpriseSiteID() {
        return this.auditRecord.getEnterpriseSiteID();
    }

    public String getEventAction() {
        return "action-" + this.auditRecord.getEventAction();
    }

    public Date getEventDateTime() {
        return this.auditRecord.getEventDateTime();
    }

    public String getEventID() {
        return AuditRecordEntry.meaningOf(this.auditRecord.getEventID());
    }

    private static String meaningOf(Code code) {
        return code != null ? code.getMeaning() : "";
    }

    public String getEventOutcome() {
        return "outcome-" + this.auditRecord.getEventOutcome();
    }

    public String getEventType() {
        return AuditRecordEntry.meaningOf(this.auditRecord.getEventType());
    }

    public String getParticipantObjects() {
        return XSLTUtils.render("arr-object.xsl", this.auditRecord.getXmldata());
    }

    public long getPk() {
        return this.auditRecord.getPk();
    }

    public Date getReceiveDateTime() {
        return this.auditRecord.getReceiveDateTime();
    }

    public String getSourceID() {
        return this.auditRecord.getSourceID();
    }

    public String getSourceType() {
        return "source-type-" + this.auditRecord.getSourceType();
    }

    public byte[] getXmldata() {
        return this.auditRecord.getXmldata();
    }

    public boolean isIHEYr4() {
        return this.auditRecord.isIHEYr4();
    }

    public String toString() {
        return this.auditRecord.toString();
    }
}

