/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arr.seam.ejb;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Principal;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditLogUsedMessage;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4chee.arr.seam.ejb.AuditLogUsedLocal;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.log.Log;

@Stateless
public class AuditLogUsedBean
implements AuditLogUsedLocal {
    @Logger
    private transient Log log;
    @Resource(mappedName="ConnectionFactory")
    private transient QueueConnectionFactory connFactory;
    @Resource(mappedName="queue/ARRIncoming")
    private transient Queue queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpServletRequest rq, AuditEvent.OutcomeIndicator outcome) {
        try {
            QueueConnection conn = this.connFactory.createQueueConnection();
            try {
                QueueSession jmsSession = conn.createQueueSession(false, 1);
                QueueSender sender = jmsSession.createSender(this.queue);
                final BytesMessage msg = jmsSession.createBytesMessage();
                msg.setStringProperty("sourceHostAddress", AuditMessage.getLocalHost().getHostAddress());
                msg.setStringProperty("sourceHostName", AuditMessage.getLocalHostName());
                AuditLogUsedMessage auditLogUsed = new AuditLogUsedMessage();
                auditLogUsed.getAuditEvent().setOutcomeIndicator(outcome);
                auditLogUsed.addUserPerson(this.userID(rq), null, null, rq.getRemoteHost());
                StringBuffer url = rq.getRequestURL();
                auditLogUsed.addSecurityAuditLog(url.substring(0, url.lastIndexOf("/")));
                OutputStreamWriter out = new OutputStreamWriter(new OutputStream(){

                    public void write(byte[] b, int off, int len) throws IOException {
                        try {
                            msg.writeBytes(b, off, len);
                        }
                        catch (JMSException e) {
                            throw new IOException(e.getMessage());
                        }
                    }

                    public void write(int b) throws IOException {
                        try {
                            msg.writeByte((byte)b);
                        }
                        catch (JMSException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                }, "UTF-8");
                auditLogUsed.output((Writer)out);
                out.flush();
                sender.send((Message)msg);
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to send Audit Log Used message", (Throwable)e, new Object[0]);
        }
    }

    private String userID(HttpServletRequest rq) {
        Principal user = rq.getUserPrincipal();
        return user != null ? user.getName() : "UNKOWN_USER";
    }
}

