/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.xa;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.xa.XAManagedConnection;

public class XAManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = 1647927657609573729L;
    private String xaDataSourceClass;
    private String xaDataSourceProperties;
    protected final Properties xaProps = new Properties();
    private Boolean isSameRMOverrideValue;
    private XADataSource xads;

    public String getXADataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void setXADataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    public String getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        this.xaDataSourceProperties = xaDataSourceProperties;
        this.xaProps.clear();
        if (xaDataSourceProperties != null) {
            xaDataSourceProperties = xaDataSourceProperties.replaceAll("\\\\", "\\\\\\\\");
            ByteArrayInputStream is = new ByteArrayInputStream(xaDataSourceProperties.getBytes());
            try {
                this.xaProps.load(is);
            }
            catch (IOException ioe) {
                throw new JBossResourceException("Could not load connection properties", (Throwable)ioe);
            }
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties props = this.getConnectionProperties(subject, cri);
        PooledConnection xaConnection = null;
        try {
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            xaConnection = user != null ? this.getXADataSource().getXAConnection(user, password) : this.getXADataSource().getXAConnection();
            return this.newXAManagedConnection(props, (XAConnection)xaConnection);
        }
        catch (Throwable e) {
            if (xaConnection != null) {
                try {
                    xaConnection.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            throw new JBossResourceException("Could not create connection", e);
        }
    }

    protected ManagedConnection newXAManagedConnection(Properties props, XAConnection xaConnection) throws SQLException {
        return new XAManagedConnection(this, xaConnection, props, this.transactionIsolation, this.preparedStatementCacheSize);
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(subject, cri);
        for (Object o : mcs) {
            XAManagedConnection mc;
            if (!(o instanceof XAManagedConnection) || !(mc = (XAManagedConnection)o).getProps().equals(newProps) || (!this.getValidateOnMatch() || !mc.checkValid()) && this.getValidateOnMatch()) continue;
            return mc;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = result * 37 + this.xaProps.hashCode();
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        XAManagedConnectionFactory otherMcf = (XAManagedConnectionFactory)((Object)other);
        return this.xaDataSourceClass.equals(otherMcf.xaDataSourceClass) && this.xaProps.equals(otherMcf.xaProps) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized XADataSource getXADataSource() throws ResourceException {
        if (this.xads == null) {
            if (this.xaDataSourceClass == null) {
                throw new JBossResourceException("No XADataSourceClass supplied!");
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.xaDataSourceClass);
                this.xads = (XADataSource)clazz.newInstance();
                Class[] NOCLASSES = new Class[]{};
                for (String string : this.xaProps.keySet()) {
                    void var4_10;
                    String value = this.xaProps.getProperty(string);
                    char firstCharName = Character.toUpperCase(string.charAt(0));
                    if (string.length() > 1) {
                        String string2 = firstCharName + string.substring(1);
                    } else {
                        String string3 = "" + firstCharName;
                    }
                    Class type = null;
                    try {
                        Method getter = clazz.getMethod("get" + (String)var4_10, NOCLASSES);
                        type = getter.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        type = String.class;
                        try {
                            Method getter = clazz.getMethod("is" + (String)var4_10, NOCLASSES);
                            type = getter.getReturnType();
                        }
                        catch (NoSuchMethodException nsme) {
                            type = String.class;
                        }
                    }
                    Method setter = clazz.getMethod("set" + (String)var4_10, type);
                    PropertyEditor editor = PropertyEditorManager.findEditor(type);
                    if (editor == null) {
                        throw new JBossResourceException("No property editor found for type: " + type);
                    }
                    editor.setAsText(value);
                    setter.invoke((Object)this.xads, editor.getValue());
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new JBossResourceException("Class not found for XADataSource " + this.xaDataSourceClass, (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new JBossResourceException("Could not create an XADataSource: ", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
            }
            catch (IllegalArgumentException iae) {
                throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw new JBossResourceException("Could not invoke setter on XADataSource: ", (Throwable)ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new JBossResourceException("Could not find accessor on XADataSource: ", (Throwable)nsme);
            }
        }
        return this.xads;
    }

    protected Properties getXaProps() {
        return this.xaProps;
    }
}

