/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.xa;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.XADataSource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.xa.XAManagedConnectionFactory;
import org.jboss.util.JBossStringBuilder;

public class HAXAManagedConnectionFactory
extends XAManagedConnectionFactory {
    private static final long serialVersionUID = 1898242235188801452L;
    private String urlProperty;
    private String urlDelimiter;
    private XADataSelector xadsSelector;

    public String getURLProperty() {
        return this.urlProperty;
    }

    public void setURLProperty(String urlProperty) throws ResourceException {
        this.urlProperty = urlProperty;
        this.initSelector();
    }

    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimetir) throws ResourceException {
        this.urlDelimiter = urlDelimetir;
        this.initSelector();
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        super.setXADataSourceProperties(xaDataSourceProperties);
        this.initSelector();
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.xadsSelector == null) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            buffer.append("Missing configuration for HA XA datasource.");
            if (this.urlProperty == null) {
                buffer.append(" No url property.");
            } else if (!this.xaProps.containsKey(this.urlProperty)) {
                buffer.append(" ").append(this.urlProperty).append(" not found in datasource properties.");
            }
            if (this.urlDelimiter == null) {
                buffer.append(" No url-delimiter.");
            }
            throw new JBossResourceException(buffer.toString());
        }
        for (int i = 0; i < this.xadsSelector.getXADataSourceList().size(); ++i) {
            XAData xaData = this.xadsSelector.getXAData();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Trying to create an XA connection to " + xaData.url));
            }
            try {
                return super.createManagedConnection(subject, cri);
            }
            catch (ResourceException e) {
                this.log.warn((Object)("Failed to create an XA connection to " + xaData.url + ": " + e.getMessage()));
                this.xadsSelector.failedXAData(xaData);
                continue;
            }
        }
        throw new JBossResourceException("Could not create connection using any of the URLs: " + this.xadsSelector.getXADataSourceList());
    }

    protected synchronized XADataSource getXADataSource() throws ResourceException {
        return this.xadsSelector.getXAData().xads;
    }

    private XADataSource createXaDataSource(Properties xaProps) throws JBossResourceException {
        XADataSource xads;
        if (this.getXADataSourceClass() == null) {
            throw new JBossResourceException("No XADataSourceClass supplied!");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.getXADataSourceClass());
            xads = (XADataSource)clazz.newInstance();
            Class[] NOCLASSES = new Class[]{};
            for (String string : xaProps.keySet()) {
                String value = xaProps.getProperty(string);
                Class type = null;
                try {
                    Method getter = clazz.getMethod("get" + string, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    type = String.class;
                }
                Method setter = clazz.getMethod("set" + string, type);
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor == null) {
                    throw new JBossResourceException("No property editor found for type: " + type);
                }
                editor.setAsText(value);
                setter.invoke((Object)xads, editor.getValue());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new JBossResourceException("Class not found for XADataSource " + this.getXADataSourceClass(), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new JBossResourceException("Could not create an XADataSource: ", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
        }
        catch (IllegalArgumentException iae) {
            throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new JBossResourceException("Could not invoke setter on XADataSource: ", (Throwable)ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new JBossResourceException("Could not find accessor on XADataSource: ", (Throwable)nsme);
        }
        return xads;
    }

    private void initSelector() throws JBossResourceException {
        String urlsStr;
        if (this.urlProperty != null && this.urlProperty.length() > 0 && (urlsStr = this.xaProps.getProperty(this.urlProperty)) != null && urlsStr.trim().length() > 0 && this.urlDelimiter != null && this.urlDelimiter.trim().length() > 0) {
            XADataSource xads;
            String url;
            ArrayList<XAData> xaDataList = new ArrayList<XAData>();
            Properties xaPropsCopy = new Properties();
            for (Object key : this.xaProps.keySet()) {
                xaPropsCopy.put(key, this.xaProps.get(key));
            }
            int urlStart = 0;
            int urlEnd = urlsStr.indexOf(this.urlDelimiter);
            while (urlEnd > 0) {
                url = urlsStr.substring(urlStart, urlEnd);
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                urlStart = ++urlEnd;
                urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            if (urlStart != urlsStr.length()) {
                url = urlsStr.substring(urlStart, urlsStr.length());
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            this.xadsSelector = new XADataSelector(xaDataList);
        }
    }

    private static class XAData {
        public final XADataSource xads;
        public final String url;

        public XAData(XADataSource xads, String url) {
            this.xads = xads;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XAData)) {
                return false;
            }
            XAData xaData = (XAData)o;
            return this.url.equals(xaData.url);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public String toString() {
            return "[XA URL=" + this.url + "]";
        }
    }

    public static class XADataSelector {
        private final List xaDataList;
        private int xaDataIndex;
        private XAData xaData;

        public XADataSelector(List xaDataList) {
            if (xaDataList == null || xaDataList.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of XADataSource/URL pairs but got: " + xaDataList);
            }
            this.xaDataList = xaDataList;
        }

        public synchronized XAData getXAData() {
            if (this.xaData == null) {
                if (this.xaDataIndex == this.xaDataList.size()) {
                    this.xaDataIndex = 0;
                }
                this.xaData = (XAData)this.xaDataList.get(this.xaDataIndex++);
            }
            return this.xaData;
        }

        public synchronized void failedXAData(XAData xads) {
            if (xads.equals(this.xaData)) {
                this.xaData = null;
            }
        }

        public List getXADataSourceList() {
            return this.xaDataList;
        }
    }
}

