/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.TModelKey;
import org.apache.juddi.datatype.request.FindBinding;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindBindingHandler
extends AbstractHandler {
    public static final String TAG_NAME = "find_binding";
    private HandlerMaker maker = null;

    protected FindBindingHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String maxRows;
        String generic;
        FindBinding obj = new FindBinding();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String serviceKey = element.getAttribute("serviceKey");
        if (serviceKey != null && serviceKey.trim().length() > 0) {
            obj.setServiceKey(serviceKey);
        }
        if ((generic = element.getAttribute("generic")) != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((maxRows = element.getAttribute("maxRows")) != null && maxRows.trim().length() > 0) {
            obj.setMaxRows(maxRows);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifiers")).size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            obj.setFindQualifiers((FindQualifiers)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "tModelBag")).size() > 0) {
            handler = this.maker.lookup("tModelBag");
            obj.setTModelBag((TModelBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        TModelBag bag;
        CategoryBag catBag;
        FindQualifiers qualifiers;
        int maxRows;
        String generic;
        FindBinding request = (FindBinding)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String key = request.getServiceKey();
        if (key != null) {
            element.setAttribute("serviceKey", key);
        }
        if ((generic = request.getGeneric()) != null) {
            element.setAttribute("generic", generic);
        }
        if ((maxRows = request.getMaxRows()) > 0) {
            element.setAttribute("maxRows", String.valueOf(maxRows));
        }
        if ((qualifiers = request.getFindQualifiers()) != null && qualifiers.size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            handler.marshal(qualifiers, element);
        }
        if ((catBag = request.getCategoryBag()) != null) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(catBag, element);
        }
        if ((bag = request.getTModelBag()) != null) {
            handler = this.maker.lookup("tModelBag");
            handler.marshal(bag, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        TModelBag bag = new TModelBag();
        bag.addTModelKey("uuid:35d9793b-9911-4b85-9f0e-5d4c65b4f253");
        bag.addTModelKey(new TModelKey("uuid:c5ab113f-0d6b-4247-b3c4-8c012726acd8"));
        FindBinding request = new FindBinding();
        request.addFindQualifier(new FindQualifier("sortByDateAsc"));
        request.addFindQualifier(new FindQualifier("andAllKeys"));
        request.setMaxRows(50);
        request.setServiceKey("fd36dbce-bc3e-468b-8346-5374975a0843");
        request.setTModelBag(bag);
        request.setCategoryBag(catBag);
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

