/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.pdu;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class UserIdentityRQ {
    public static final int USERNAME = 1;
    public static final int USERNAME_PASSCODE = 2;
    public static final int KERBEROS = 3;
    public static final int SAML = 4;
    private int userIdentityType;
    private boolean positiveResponseRequested;
    private byte[] primaryField = new byte[0];
    private byte[] secondaryField = new byte[0];

    public final int getUserIdentityType() {
        return this.userIdentityType;
    }

    public final void setUserIdentityType(int userIdentityType) {
        this.userIdentityType = userIdentityType;
    }

    public final boolean isPositiveResponseRequested() {
        return this.positiveResponseRequested;
    }

    public final void setPositiveResponseRequested(boolean positiveResponseRequested) {
        this.positiveResponseRequested = positiveResponseRequested;
    }

    public final byte[] getPrimaryField() {
        return (byte[])this.primaryField.clone();
    }

    public final void setPrimaryField(byte[] primaryField) {
        this.primaryField = (byte[])primaryField.clone();
    }

    public final byte[] getSecondaryField() {
        return (byte[])this.secondaryField.clone();
    }

    public final void setSecondaryField(byte[] secondaryField) {
        this.secondaryField = (byte[])secondaryField.clone();
    }

    public String getUsername() {
        return UserIdentityRQ.toString(this.primaryField);
    }

    public void setUsername(String username) {
        this.primaryField = UserIdentityRQ.toBytes(username);
    }

    public char[] getPasscode() {
        return UserIdentityRQ.toChars(this.secondaryField);
    }

    public void setPasscode(char[] passcode) {
        this.secondaryField = UserIdentityRQ.toBytes(passcode);
    }

    private static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static String toString(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static Charset utf8() {
        return Charset.forName("UTF-8");
    }

    private static byte[] toBytes(char[] ca) {
        return UserIdentityRQ.utf8().encode(CharBuffer.wrap(ca)).array();
    }

    private static char[] toChars(byte[] b) {
        return UserIdentityRQ.utf8().decode(ByteBuffer.wrap(b)).array();
    }

    public int length() {
        return 6 + this.primaryField.length + this.secondaryField.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("UserIdentity[type = ").append(this.userIdentityType);
        if (this.userIdentityType == 1 || this.userIdentityType == 2) {
            sb.append(", username = ").append(this.getUsername());
            if (this.userIdentityType == 2) {
                sb.append(", passcode = ");
                int i = this.secondaryField.length;
                while (--i >= 0) {
                    sb.append('*');
                }
            }
        } else {
            sb.append(", primaryField(").append(this.primaryField.length);
            sb.append("), secondaryField(").append(this.secondaryField.length);
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

