/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;

class FutureDimseRSP
extends DimseRSPHandler
implements DimseRSP {
    private Entry entry = new Entry(null, null);
    private boolean finished;
    private int autoCancel;
    private IOException ex;

    FutureDimseRSP() {
    }

    public synchronized void onDimseRSP(Association as, DicomObject cmd, DicomObject data) {
        super.onDimseRSP(as, cmd, data);
        Entry last = this.entry;
        while (last.next != null) {
            last = last.next;
        }
        last.next = new Entry(cmd, data);
        if (CommandUtils.isPending(cmd)) {
            if (this.autoCancel > 0 && --this.autoCancel == 0) {
                try {
                    super.cancel(as);
                }
                catch (IOException e) {
                    this.ex = e;
                }
            }
        } else {
            this.finished = true;
        }
        this.notifyAll();
    }

    public synchronized void onClosed(Association as) {
        if (!this.finished) {
            this.ex = as.getException();
            if (this.ex == null) {
                this.ex = new IOException("Association to " + as.getRemoteAET() + " closed before receive of outstanding DIMSE RSP");
            }
            this.notifyAll();
        }
    }

    public final void setAutoCancel(int autoCancel) {
        this.autoCancel = autoCancel;
    }

    public void cancel(Association a) throws IOException {
        if (this.ex != null) {
            throw this.ex;
        }
        if (!this.finished) {
            super.cancel(a);
        }
    }

    public final DicomObject getCommand() {
        return this.entry.command;
    }

    public final DicomObject getDataset() {
        return this.entry.dataset;
    }

    public synchronized boolean next() throws IOException, InterruptedException {
        if (this.entry.next == null) {
            if (this.finished) {
                return false;
            }
            while (this.entry.next == null && this.ex == null) {
                this.wait();
            }
            if (this.ex != null) {
                throw this.ex;
            }
        }
        this.entry = this.entry.next;
        return true;
    }

    private static class Entry {
        final DicomObject command;
        final DicomObject dataset;
        Entry next;

        public Entry(DicomObject command, DicomObject dataset) {
            this.command = command;
            this.dataset = dataset;
        }
    }
}

