/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.tools;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.MWLManager;
import org.dcm4chex.archive.ejb.interfaces.MWLManagerHome;
import org.xml.sax.SAXException;

public final class EditMwl {
    private static ResourceBundle messages = ResourceBundle.getBundle(EditMwl.class.getName());
    private static final LongOpt[] LONG_OPTS = new LongOpt[]{new LongOpt("url", 1, null, 117), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private String ejbProviderURL = "jnp://localhost:1099";
    private final PatientMatching patientMatching = new PatientMatching("pid,issuer?");

    public static void main(String[] args) {
        int c;
        Getopt g = new Getopt("mwlitem.jar", args, "af:r:u:hv", LONG_OPTS);
        EditMwl mwl = new EditMwl();
        int cmd = 0;
        String[] rpIdspsId = null;
        String fpath = null;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 97: {
                    cmd = c;
                    break;
                }
                case 114: {
                    cmd = c;
                    rpIdspsId = StringUtils.split((String)g.getOptarg(), (char)'/');
                    if (rpIdspsId.length == 2) break;
                    EditMwl.exit(messages.getString("rqidspsid"), true);
                    break;
                }
                case 102: {
                    fpath = g.getOptarg();
                    break;
                }
                case 117: {
                    mwl.ejbProviderURL = g.getOptarg();
                    break;
                }
                case 118: {
                    EditMwl.exit(messages.getString("version"), false);
                }
                case 104: {
                    EditMwl.exit(messages.getString("usage"), false);
                }
                case 63: {
                    EditMwl.exit(null, true);
                }
            }
        }
        if (cmd == 0) {
            EditMwl.exit(messages.getString("missing"), true);
        }
        try {
            switch (cmd) {
                case 97: {
                    Dataset ds = mwl.add(EditMwl.loadMWLItem(fpath));
                    Dataset spsitem = ds.getItem(0x400100);
                    System.out.println(ds.getString(0x401001) + '/' + spsitem.getString(0x400009));
                    break;
                }
                case 114: {
                    mwl.remove(rpIdspsId[0], rpIdspsId[1]);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private Dataset add(Dataset ds) throws Exception {
        return this.getMWLManager().addWorklistItem(ds, this.patientMatching);
    }

    private Dataset remove(String rqpid, String spsid) throws Exception {
        return this.getMWLManager().removeWorklistItem(rqpid, spsid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dataset loadMWLItem(String fpath) throws SAXException, IOException {
        if (EditMwl.isXML(fpath)) {
            InputStream is = fpath == null ? System.in : new FileInputStream(fpath);
            try {
                Dataset dataset = DatasetUtils.fromXML((InputStream)is);
                return dataset;
            }
            finally {
                if (fpath != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.readFile(new File(fpath), null, -1);
        return ds;
    }

    private static boolean isXML(String fpath) {
        return fpath == null || fpath.toUpperCase().endsWith(".XML");
    }

    private Hashtable makeEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", this.ejbProviderURL);
        return env;
    }

    private MWLManager getMWLManager() throws Exception {
        InitialContext ctx = new InitialContext(this.makeEnv());
        MWLManagerHome home = (MWLManagerHome)ctx.lookup("ejb/MWLManager");
        ctx.close();
        return home.create();
    }

    private static void exit(String prompt, boolean error) {
        if (prompt != null) {
            System.err.println(prompt);
        }
        if (error) {
            System.err.println(messages.getString("usage"));
        }
        System.exit(1);
    }
}

