/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.tools;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.interfaces.GPWLManager;
import org.dcm4chex.archive.ejb.interfaces.GPWLManagerHome;
import org.xml.sax.SAXException;

public class EditGpwl {
    private static ResourceBundle messages = ResourceBundle.getBundle(EditGpwl.class.getName());
    private static final LongOpt[] LONG_OPTS = new LongOpt[]{new LongOpt("url", 1, null, 117), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private String ejbProviderURL = "jnp://localhost:1099";

    public static void main(String[] args) {
        int c;
        Getopt g = new Getopt("gpwlitem.jar", args, "af:r:u:hv", LONG_OPTS);
        EditGpwl gpwl = new EditGpwl();
        int cmd = 0;
        String iuid = null;
        String fpath = null;
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 97: {
                    cmd = c;
                    break;
                }
                case 114: {
                    cmd = c;
                    iuid = g.getOptarg();
                    break;
                }
                case 102: {
                    fpath = g.getOptarg();
                    break;
                }
                case 117: {
                    gpwl.ejbProviderURL = g.getOptarg();
                    break;
                }
                case 118: {
                    EditGpwl.exit(messages.getString("version"), false);
                }
                case 104: {
                    EditGpwl.exit(messages.getString("usage"), false);
                }
                case 63: {
                    EditGpwl.exit(null, true);
                }
            }
        }
        if (cmd == 0) {
            EditGpwl.exit(messages.getString("missing"), true);
        }
        try {
            switch (cmd) {
                case 97: {
                    iuid = gpwl.add(EditGpwl.loadGPWLItem(fpath));
                    System.out.println(iuid);
                    break;
                }
                case 114: {
                    gpwl.remove(iuid);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String add(Dataset ds) throws Exception {
        GPWLManager mgr = this.getGPWLManager();
        try {
            String string = mgr.addWorklistItem(ds);
            return string;
        }
        finally {
            try {
                mgr.remove();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset remove(String uid) throws Exception {
        GPWLManager mgr = this.getGPWLManager();
        try {
            Dataset dataset = mgr.removeWorklistItem(uid);
            return dataset;
        }
        finally {
            try {
                mgr.remove();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dataset loadGPWLItem(String fpath) throws SAXException, IOException {
        if (EditGpwl.isXML(fpath)) {
            InputStream is = fpath == null ? System.in : new FileInputStream(fpath);
            try {
                Dataset dataset = DatasetUtils.fromXML((InputStream)is);
                return dataset;
            }
            finally {
                if (fpath != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.readFile(new File(fpath), null, -1);
        return ds;
    }

    private static boolean isXML(String fpath) {
        return fpath == null || fpath.toUpperCase().endsWith(".XML");
    }

    private Hashtable makeEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", this.ejbProviderURL);
        return env;
    }

    private GPWLManager getGPWLManager() throws Exception {
        InitialContext ctx = new InitialContext(this.makeEnv());
        GPWLManagerHome home = (GPWLManagerHome)ctx.lookup("ejb/GPWLManager");
        ctx.close();
        return home.create();
    }

    private static void exit(String prompt, boolean error) {
        if (prompt != null) {
            System.err.println(prompt);
        }
        if (error) {
            System.err.println(messages.getString("usage"));
        }
        System.exit(1);
    }
}

