/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.markup.html.tree.WicketTreeModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.EnumeratedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultAbstractTree
extends AbstractTree {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference CSS = new ResourceReference(DefaultAbstractTree.class, "res/tree.css");
    private static final ResourceReference FOLDER_CLOSED = new ResourceReference(DefaultAbstractTree.class, "res/folder-closed.gif");
    private static final ResourceReference FOLDER_OPEN = new ResourceReference(DefaultAbstractTree.class, "res/folder-open.gif");
    private static final ResourceReference ITEM = new ResourceReference(DefaultAbstractTree.class, "res/item.gif");
    private LinkType linkType = LinkType.AJAX;

    public DefaultAbstractTree(String id) {
        super(id);
        this.init();
    }

    public DefaultAbstractTree(String id, IModel<TreeModel> model) {
        super(id, model);
        this.init();
    }

    public DefaultAbstractTree(String id, TreeModel model) {
        super(id, (IModel)new WicketTreeModel());
        this.setModelObject(model);
        this.init();
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType linkType) {
        if (this.linkType != linkType) {
            this.linkType = linkType;
            this.invalidateAll();
        }
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    protected ResourceReference getFolderClosed() {
        return FOLDER_CLOSED;
    }

    protected ResourceReference getFolderOpen() {
        return FOLDER_OPEN;
    }

    protected ResourceReference getItem() {
        return ITEM;
    }

    protected ResourceReference getNodeIcon(TreeNode node) {
        if (node.isLeaf()) {
            return this.getItem();
        }
        if (this.isNodeExpanded(node)) {
            return this.getFolderOpen();
        }
        return this.getFolderClosed();
    }

    protected Component newIndentation(MarkupContainer parent, String id, final TreeNode node, final int level) {
        WebMarkupContainer result = new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                int i;
                Response response = RequestCycle.get().getResponse();
                TreeNode parent = node.getParent();
                CharSequence[] urls = new CharSequence[level];
                for (i = 0; i < level; ++i) {
                    urls[i] = DefaultAbstractTree.this.isNodeLast(parent) ? "indent-blank" : "indent-line";
                    parent = parent.getParent();
                }
                for (i = level - 1; i >= 0; --i) {
                    response.write((CharSequence)("<span class=\"" + urls[i] + "\"></span>"));
                }
            }
        };
        result.setRenderBodyOnly(true);
        return result;
    }

    protected MarkupContainer newJunctionImage(MarkupContainer parent, String id, final TreeNode node) {
        return (MarkupContainer)new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClassInner = !node.isLeaf() ? (DefaultAbstractTree.this.isNodeExpanded(node) ? "minus" : "plus") : "corner";
                String cssClassOuter = DefaultAbstractTree.this.isNodeLast(node) ? "junction-last" : "junction";
                Response response = RequestCycle.get().getResponse();
                response.write((CharSequence)("<span class=\"" + cssClassOuter + "\"><span class=\"" + cssClassInner + "\"></span></span>"));
            }
        }.setRenderBodyOnly(true);
    }

    protected Component newJunctionLink(MarkupContainer parent, String id, String imageId, final TreeNode node) {
        Object junctionLink = !node.isLeaf() ? this.newLink(parent, id, new ILinkCallback(){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                if (DefaultAbstractTree.this.isNodeExpanded(node)) {
                    DefaultAbstractTree.this.getTreeState().collapseNode((Object)node);
                } else {
                    DefaultAbstractTree.this.getTreeState().expandNode((Object)node);
                }
                DefaultAbstractTree.this.onJunctionLinkClicked(target, node);
                DefaultAbstractTree.this.updateTree(target);
            }
        }) : new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("onclick", (CharSequence)"return false");
            }
        };
        if (imageId != null) {
            junctionLink.add(new Component[]{this.newJunctionImage((MarkupContainer)junctionLink, imageId, node)});
        }
        return junctionLink;
    }

    protected MarkupContainer newLink(MarkupContainer parent, String id, final ILinkCallback callback) {
        if (this.getLinkType() == LinkType.REGULAR) {
            return new Link<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    callback.onClick(null);
                }
            };
        }
        if (this.getLinkType() == LinkType.AJAX) {
            return new AjaxLink<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    callback.onClick(target);
                }
            };
        }
        return new AjaxFallbackLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                callback.onClick(target);
            }
        };
    }

    protected Component newNodeIcon(MarkupContainer parent, String id, final TreeNode node) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("style", (CharSequence)("background-image: url('" + RequestCycle.get().urlFor(DefaultAbstractTree.this.getNodeIcon(node)) + "')"));
            }
        };
    }

    protected MarkupContainer newNodeLink(MarkupContainer parent, String id, final TreeNode node) {
        return this.newLink(parent, id, new ILinkCallback(){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                DefaultAbstractTree.this.getTreeState().selectNode((Object)node, !DefaultAbstractTree.this.getTreeState().isNodeSelected((Object)node));
                DefaultAbstractTree.this.onNodeLinkClicked(target, node);
                DefaultAbstractTree.this.updateTree(target);
            }
        });
    }

    protected void onJunctionLinkClicked(AjaxRequestTarget target, TreeNode node) {
    }

    protected void onNodeLinkClicked(AjaxRequestTarget target, TreeNode node) {
    }

    private void init() {
        ResourceReference css = this.getCSS();
        if (css != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((Class)css.getScope(), (String)css.getName())});
        }
    }

    private boolean isNodeLast(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            return true;
        }
        return parent.getChildAt(parent.getChildCount() - 1).equals(node);
    }

    protected static interface ILinkCallback
    extends IClusterable {
        public void onClick(AjaxRequestTarget var1);
    }

    public static final class LinkType
    extends EnumeratedType {
        public static final LinkType AJAX = new LinkType("AJAX");
        public static final LinkType AJAX_FALLBACK = new LinkType("AJAX_FALLBACK");
        public static final LinkType REGULAR = new LinkType("REGULAR");
        private static final long serialVersionUID = 1L;

        public LinkType(String name) {
            super(name);
        }
    }
}

