/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.BehaviorsUtil;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxLazyLoadPanel;
import org.apache.wicket.util.tester.WicketTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxLazyLoadPanelTester {
    private static final Logger logger = LoggerFactory.getLogger(AjaxLazyLoadPanelTester.class);

    public static void executeAjaxLazyLoadPanel(final WicketTester wt, MarkupContainer container) {
        container.visitChildren(AjaxLazyLoadPanel.class, (Component.IVisitor)new Component.IVisitor<AjaxLazyLoadPanel>(){

            public Object component(AjaxLazyLoadPanel component) {
                List behaviors = BehaviorsUtil.getBehaviors((Component)component, AbstractAjaxBehavior.class);
                if (behaviors.size() == 0) {
                    logger.warn("AjaxLazyLoadPanel child found, but no attached AbstractAjaxBehaviors found. A curious situation...");
                }
                for (IBehavior b : behaviors) {
                    if (!(b instanceof AbstractAjaxBehavior) || b instanceof AjaxSelfUpdatingTimerBehavior) continue;
                    logger.debug("Triggering lazy panel: " + component.getClassRelativePath());
                    AbstractAjaxBehavior abstractAjaxBehaviour = (AbstractAjaxBehavior)b;
                    wt.executeBehavior(abstractAjaxBehaviour);
                }
                return CONTINUE_TRAVERSAL;
            }
        });
    }
}

