/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.security.log.IAuthorizationMessageSource;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationMessageSource
implements IAuthorizationMessageSource {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Component component;

    public AuthorizationMessageSource() {
    }

    public AuthorizationMessageSource(Map<String, Object> vars) {
        this.variables.putAll(vars);
    }

    public final String getMessage(String key) {
        Localizer localizer = Application.get().getResourceSettings().getLocalizer();
        String message = localizer.getString(key, this.getComponent(), "");
        if (Strings.isEmpty((CharSequence)message)) {
            return null;
        }
        return message;
    }

    @Override
    public final Component getComponent() {
        return this.component;
    }

    public final String substitute(String string, Map<String, Object> vars) throws IllegalStateException {
        return new MapVariableInterpolator(string, this.mergeVariables(vars), Application.get().getResourceSettings().getThrowExceptionOnMissingResource()).toString();
    }

    @Override
    public final void setComponent(Component component) {
        this.component = component;
        this.variables.put("component", component);
    }

    @Override
    public final void addVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    protected final Map<String, Object> mergeVariables(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.variables);
        if (map != null && !map.isEmpty()) {
            result.putAll(map);
        }
        return result;
    }
}

