/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.extensions.markup.html.tabs;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.security.checks.LinkSecurityCheck;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.extensions.markup.html.tabs.ISecureTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureTabbedPanel
extends TabbedPanel {
    private static final long serialVersionUID = 1L;

    public SecureTabbedPanel(String id, List<ITab> tabs) {
        super(id, tabs);
    }

    protected WebMarkupContainer newLink(String linkId, int index) {
        Link link = (Link)super.newLink(linkId, index);
        Class<? extends Panel> panelClass = this.getTabClass(index);
        if (panelClass != null) {
            SecureComponentHelper.setSecurityCheck((Component)link, new LinkSecurityCheck((Component)link, panelClass));
        }
        return link;
    }

    protected Class<? extends Panel> getTabClass(int tabIndex) {
        ITab tab = (ITab)this.getTabs().get(tabIndex);
        if (tab instanceof ISecureTab) {
            return ((ISecureTab)tab).getPanel();
        }
        return null;
    }
}

