/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components.markup.html.links;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.checks.LinkSecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurePageLink<T>
extends Link<T>
implements ISecureComponent {
    private static final long serialVersionUID = 1L;
    private IPageLink pageLink;

    public <C extends Page> SecurePageLink(String id, final Class<C> c) {
        super(id);
        this.setSecurityCheck(new LinkSecurityCheck((Component)this, c));
        if (!Page.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
        }
        this.pageLink = new IPageLink(){
            private static final long serialVersionUID = 1L;

            public Page getPage() {
                return SecurePageLink.this.getSession().getPageFactory().newPage(c);
            }

            public Class<? extends Page> getPageIdentity() {
                return c;
            }
        };
    }

    public SecurePageLink(String id, IPageLink pageLink) {
        super(id);
        this.pageLink = pageLink;
        this.setSecurityCheck(new LinkSecurityCheck((Component)this, pageLink.getPageIdentity()));
    }

    public void onClick() {
        this.setResponsePage(this.pageLink.getPage());
    }

    @Override
    public ISecurityCheck getSecurityCheck() {
        return SecureComponentHelper.getSecurityCheck((Component)this);
    }

    @Override
    public boolean isActionAuthorized(String waspAction) {
        return SecureComponentHelper.isActionAuthorized((Component)this, waspAction);
    }

    @Override
    public boolean isActionAuthorized(WaspAction action) {
        return SecureComponentHelper.isActionAuthorized((Component)this, action);
    }

    @Override
    public boolean isAuthenticated() {
        return SecureComponentHelper.isAuthenticated((Component)this);
    }

    @Override
    public void setSecurityCheck(ISecurityCheck check) {
        SecureComponentHelper.setSecurityCheck((Component)this, check);
    }
}

