/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components.markup.html.links;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.checks.LinkSecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecureContainerLink<T>
extends Link<T>
implements ISecureComponent {
    private static final long serialVersionUID = 1L;
    private Class<? extends MarkupContainer> replacementClass;
    private MarkupContainer containerParent;
    private String containerId;

    public SecureContainerLink(String id, Class<? extends MarkupContainer> replacementPanel, MarkupContainer parentOfReplaceablePanel, String panelId) {
        this(id, null, replacementPanel, parentOfReplaceablePanel, panelId);
    }

    public SecureContainerLink(String id, IModel<T> object, Class<? extends MarkupContainer> replacementPanel, MarkupContainer parentOfReplaceablePanel, String panelId) {
        super(id, object);
        this.setReplacementClass(replacementPanel);
        if (parentOfReplaceablePanel == null) {
            throw new WicketRuntimeException("Parent required for replacing components.");
        }
        this.containerParent = parentOfReplaceablePanel;
        if (panelId == null) {
            throw new WicketRuntimeException("Id required from component to be replaced.");
        }
        this.containerId = panelId;
    }

    public final void onClick() {
        Component replaceMe = this.getComponentToBeReplaced();
        if (replaceMe == null) {
            throw new WicketRuntimeException("unable to find child with id: " + this.containerId + " on parent: " + this.containerParent);
        }
        Class<MarkupContainer> myReplacementClass = this.getReplacementClass();
        MarkupContainer replacement = this.getReplacementFor(replaceMe, this.containerId, myReplacementClass);
        if (replacement == null) {
            return;
        }
        if (!this.containerId.equals(replacement.getId())) {
            throw new WicketRuntimeException("The replacement does not have the specified id: " + this.containerId + ", but id: " + replacement.getId());
        }
        if (!myReplacementClass.isAssignableFrom(replacement.getClass())) {
            throw new WicketRuntimeException("The replacement for " + this.containerId + " on " + this.containerParent + " is not assignable from " + myReplacementClass);
        }
        this.containerParent.replace((Component)replacement);
    }

    protected final Component getComponentToBeReplaced() {
        return this.containerParent.get(this.containerId);
    }

    protected abstract MarkupContainer getReplacementFor(Component var1, String var2, Class<? extends MarkupContainer> var3);

    protected ISecurityCheck generateSecurityCheck() {
        return new LinkSecurityCheck((Component)this, this.getReplacementClass());
    }

    @Override
    public ISecurityCheck getSecurityCheck() {
        return SecureComponentHelper.getSecurityCheck((Component)this);
    }

    @Override
    public boolean isActionAuthorized(String waspAction) {
        return SecureComponentHelper.isActionAuthorized((Component)this, waspAction);
    }

    @Override
    public boolean isActionAuthorized(WaspAction action) {
        return SecureComponentHelper.isActionAuthorized((Component)this, action);
    }

    @Override
    public boolean isAuthenticated() {
        return SecureComponentHelper.isAuthenticated((Component)this);
    }

    @Override
    public void setSecurityCheck(ISecurityCheck check) {
        SecureComponentHelper.setSecurityCheck((Component)this, check);
    }

    protected final Class<? extends MarkupContainer> getReplacementClass() {
        return this.replacementClass;
    }

    protected final void setReplacementClass(Class<? extends MarkupContainer> replacementClass) {
        if (replacementClass == null) {
            throw new WicketRuntimeException("replacementClass cannot be null");
        }
        this.replacementClass = replacementClass;
        this.setSecurityCheck(this.generateSecurityCheck());
    }
}

