/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ComponentSecurityCheck;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureForm<T>
extends Form<T>
implements ISecureComponent {
    private static final long serialVersionUID = 1L;

    public SecureForm(String id) {
        super(id);
        this.setSecurityCheck(new ComponentSecurityCheck((Component)this));
    }

    public SecureForm(String id, IModel<T> model) {
        super(id, model);
        this.setSecurityCheck(new ComponentSecurityCheck((Component)this));
    }

    @Override
    public ISecurityCheck getSecurityCheck() {
        return SecureComponentHelper.getSecurityCheck((Component)this);
    }

    @Override
    public boolean isActionAuthorized(String waspAction) {
        return SecureComponentHelper.isActionAuthorized((Component)this, waspAction);
    }

    @Override
    public boolean isActionAuthorized(WaspAction action) {
        return SecureComponentHelper.isActionAuthorized((Component)this, action);
    }

    @Override
    public boolean isAuthenticated() {
        return SecureComponentHelper.isAuthenticated((Component)this);
    }

    @Override
    public void setSecurityCheck(ISecurityCheck check) {
        SecureComponentHelper.setSecurityCheck((Component)this, check);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isEnableAllowed()) {
            tag.setName("div");
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.isEnableAllowed()) {
            this.visitChildren((Component.IVisitor)new Component.IVisitor<Component>(){

                public Object component(Component component) {
                    component.setEnabled(false);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
        }
    }
}

