/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;

class AttributeBasedClusteredSession
extends JBossCacheClusteredSession {
    static final long serialVersionUID = -5625209785550936713L;
    protected static final String info = "AttributeBasedClusteredSession/1.0";
    private transient Map attrModifiedMap_ = new HashMap();
    private transient Map attrRemovedMap_ = new HashMap();
    private static final int REMOVE = 0;
    private static final int MODIFY = 1;
    private transient Map attributes_ = Collections.synchronizedMap(new HashMap());

    public AttributeBasedClusteredSession(JBossCacheManager manager) {
        super(manager);
    }

    public void recycle() {
        super.recycle();
        this.attributes_.clear();
        this.clearAttrChangedMaps();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AttributeBasedClusteredSession[");
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void processSessionRepl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("processSessionRepl(): session is dirty. Will increment version from: " + this.getVersion() + " and replicate."));
        }
        this.incrementVersion();
        this.proxy_.putSession(this.realId, this);
        if (this.getSessionAttributesDirty()) {
            int modCount = this.attrModifiedMap_.size();
            if (modCount == 1) {
                for (Map.Entry entry : this.attrModifiedMap_.entrySet()) {
                    this.proxy_.putAttribute(this.realId, (String)entry.getKey(), entry.getValue());
                }
            } else if (modCount > 0) {
                this.proxy_.putAttribute(this.realId, this.attrModifiedMap_);
            }
            if (this.attrRemovedMap_.size() > 0) {
                Iterator it = this.attrRemovedMap_.keySet().iterator();
                while (it.hasNext()) {
                    this.proxy_.removeAttribute(this.realId, (String)((Object)it.next()));
                }
            }
            this.clearAttrChangedMaps();
        }
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.updateLastReplicated();
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.realId);
    }

    public void removeMyselfLocal() {
        this.proxy_.removeAttributesLocal(this.realId);
        this.proxy_.removeSessionLocal(this.realId);
    }

    protected void populateAttributes() {
        Map map = this.proxy_.getAttributes(this.realId);
        Map excluded = AttributeBasedClusteredSession.removeExcludedAttributes(this.attributes_);
        if (excluded != null) {
            map.putAll(excluded);
        }
        this.attributes_ = Collections.synchronizedMap(map);
        this.attrModifiedMap_.clear();
        this.attrRemovedMap_.clear();
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = this.attributes_.get(name);
        if (this.isGetDirty(result) && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, 1);
        }
        return result;
    }

    protected Object removeJBossInternalAttribute(String name, boolean localCall, boolean localOnly) {
        Object result = this.attributes_.remove(name);
        if (localCall && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, 0);
        }
        return result;
    }

    protected Map getJBossInternalAttributes() {
        return this.attributes_;
    }

    protected Set getJBossInternalKeys() {
        return this.attributes_.keySet();
    }

    protected String[] keys() {
        return this.getJBossInternalKeys().toArray(EMPTY_ARRAY);
    }

    protected Object setJBossInternalAttribute(String key, Object value) {
        Object old = this.attributes_.put(key, value);
        if (!replicationExcludes.contains(key)) {
            this.attributeChanged(key, value, 1);
        }
        return old;
    }

    protected synchronized void attributeChanged(Object key, Object value, int op) {
        if (op == 1) {
            if (this.attrRemovedMap_.containsKey(key)) {
                this.attrRemovedMap_.remove(key);
            }
            this.attrModifiedMap_.put(key, value);
        } else if (op == 0) {
            if (this.attrModifiedMap_.containsKey(key)) {
                this.attrModifiedMap_.remove(key);
            }
            this.attrRemovedMap_.put(key, value);
        }
        this.sessionAttributesDirty();
    }

    protected synchronized void clearAttrChangedMaps() {
        this.attrRemovedMap_.clear();
        this.attrModifiedMap_.clear();
    }
}

