/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.xdsi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4cheri.util.StringUtils;
import org.dcm4cheri.util.UIDGeneratorImpl;
import org.dcm4chex.archive.xdsi.XDSIDocument;
import org.dcm4chex.archive.xdsi.XDSIService;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XDSMetadata {
    private static final String ORIGINAL = "Original";
    private static final String HAS_MEMBER = "HasMember";
    private static final String SUBMISSION_SET = "SubmissionSet";
    private static final String FOLDER_DOC_ASSOC = "FolderDocAssoc";
    private static final String TAG_ASSOCIATION = "Association";
    private static final String DEFAULT_TIME_STRING = "010101";
    private static final String ATTR_CLASSIFICATION_NODE = "classificationNode";
    private static final String ATTR_NODE_REPRESENTATION = "nodeRepresentation";
    private static final String ATTR_CLASSIFICATION_SCHEME = "classificationScheme";
    private static final String ATTR_CLASSIFIED_OBJECT = "classifiedObject";
    private static final String ATTR_OBJECTTYPE = "objectType";
    private static final String ATTR_MIMETYPE = "mimeType";
    private static final String TAG_EXTRINSICOBJECT = "ExtrinsicObject";
    private static final String TAG_LEAFREGISTRYOBJECTLIST = "LeafRegistryObjectList";
    private static final String TAG_LOCALIZEDSTRING = "LocalizedString";
    private static final String TAG_REGISTRYPACKAGE = "RegistryPackage";
    private static final String TAG_SLOT = "Slot";
    private static final String TAG_VALUELIST = "ValueList";
    private static final String TAG_NAME = "Name";
    private static final String TAG_DESCRIPTION = "Description";
    private static final String TAG_VALUE = "Value";
    private static final String TAG_OBJECTREF = "ObjectRef";
    private static final String TAG_CLASSIFICATION = "Classification";
    private static final String TAG_EXTERNAL_IDENTIFIER = "ExternalIdentifier";
    private static final String XMLNS_DEFAULT = "xmlns";
    private static final String XMLNS_RIM = "xmlns:rim";
    private static final String XMLNS_RS = "xmlns:rs";
    private static final String XMLNS_XSI = "xmlns:xsi";
    private static final String TAG_SUBMITOBJECTSREQUEST = "rs:SubmitObjectsRequest";
    private static final String URN_RIM = "urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.1";
    private static final String URN_RS = "urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1";
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private TransformerHandler th;
    private static Logger log = Logger.getLogger((String)XDSIService.class.getName());
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    private Dataset manifest;
    private Properties mdValues;
    XDSIDocument[] docs;
    private URL xslt;
    private boolean newFolder = false;
    private String submissionSetUID;
    private String submissionSetPatId;

    public XDSMetadata(Dataset ds, Properties props, XDSIDocument[] docs) {
        this.manifest = ds;
        this.docs = docs;
        this.mdValues = props != null ? props : new Properties();
        this.initProperties(props);
        this.newFolder = this.mdValues.getProperty("folder.uniqueId") != null;
    }

    private void initTransformHandler() {
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            if (this.xslt != null) {
                try {
                    this.th = tf.newTransformerHandler(new StreamSource(this.xslt.openStream(), this.xslt.toExternalForm()));
                }
                catch (IOException x) {
                    log.error((Object)("Cant open xsl file:" + this.xslt), (Throwable)x);
                }
            } else {
                this.th = tf.newTransformerHandler();
                this.th.getTransformer().setOutputProperty("indent", "yes");
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Could not initialize SAX transformer", t);
        }
    }

    private void initProperties(Properties props) {
        if (props == null) {
            return;
        }
        try {
            this.setXSLT(props.getProperty("XSLT_URL"));
        }
        catch (MalformedURLException x) {
            log.error((Object)"Wrong XSLT URL for XDS Metadata! Additional transformation disabled!", (Throwable)x);
        }
    }

    private void setXSLT(String xslt) throws MalformedURLException {
        this.xslt = xslt != null ? new URL(xslt) : null;
    }

    public Dataset getManifest() {
        return this.manifest;
    }

    public Document getMetadata() {
        this.initTransformHandler();
        DOMResult result = new DOMResult();
        this.th.setResult(result);
        try {
            this.th.startDocument();
            this.addSubmitObjectRequest();
            this.th.endDocument();
        }
        catch (SAXException x) {
            log.error((Object)"Cant build metadata!", (Throwable)x);
            return null;
        }
        return (Document)result.getNode();
    }

    private void addSubmitObjectRequest() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.th.startPrefixMapping(XMLNS_RS, URN_RS);
        this.th.startPrefixMapping(XMLNS_DEFAULT, URN_RIM);
        this.th.startElement(URN_RS, TAG_SUBMITOBJECTSREQUEST, TAG_SUBMITOBJECTSREQUEST, attr);
        this.addLeafRegistryObjectList();
        this.th.endElement(URN_RS, TAG_SUBMITOBJECTSREQUEST, TAG_SUBMITOBJECTSREQUEST);
        this.th.endPrefixMapping(XMLNS_RS);
        this.th.endPrefixMapping(XMLNS_DEFAULT);
    }

    private void addLeafRegistryObjectList() throws SAXException {
        String folderDocAssocID;
        int i;
        String title;
        this.th.startElement(URN_RIM, TAG_LEAFREGISTRYOBJECTLIST, TAG_LEAFREGISTRYOBJECTLIST, EMPTY_ATTRIBUTES);
        this.addObjectRef("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        this.addObjectRef("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d");
        this.addObjectRef("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8");
        this.addObjectRef("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832");
        this.addObjectRef("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446");
        this.addObjectRef("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500");
        this.addObjectRef("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d");
        this.addObjectRef("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab");
        this.addObjectRef("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427");
        this.addObjectRef("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a");
        this.addObjectRef("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f");
        this.addObjectRef("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d");
        this.addObjectRef("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4");
        this.addObjectRef("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1");
        this.addObjectRef("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead");
        this.addObjectRef("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983");
        this.addClassification(SUBMISSION_SET, "urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        if (this.newFolder) {
            this.addObjectRef("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
            this.addObjectRef("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a");
            this.addObjectRef("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a");
            this.addObjectRef("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5");
            this.addClassification("Folder", "urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
        }
        if (this.manifest != null) {
            for (int i2 = 0; i2 < this.docs.length; ++i2) {
                this.addExtrinsicObject(this.docs[i2]);
            }
            Dataset cnDS = this.manifest.getItem(4235331);
            title = cnDS != null ? cnDS.getString(524548) : this.mdValues.getProperty("docTitle", "Title?");
        } else {
            title = this.mdValues.getProperty("submissionSetTitle", "TITLE");
        }
        this.addSubmissionRegistryPackage(SUBMISSION_SET, title);
        int fldrDocIdx = 0;
        if (this.newFolder) {
            this.addFolderRegistryPackage("Folder", this.mdValues.getProperty("folder.name", "FOLDER"));
            this.addAssociation(null, SUBMISSION_SET, "Folder", HAS_MEMBER, null);
            if (this.docs != null) {
                for (i = 0; i < this.docs.length; ++i) {
                    folderDocAssocID = FOLDER_DOC_ASSOC + fldrDocIdx++;
                    this.addAssociation(folderDocAssocID, "Folder", this.docs[i].getDocumentID(), HAS_MEMBER, null);
                    this.addAssociation(null, SUBMISSION_SET, folderDocAssocID, HAS_MEMBER, null);
                }
            }
        }
        if (this.docs != null) {
            for (i = 0; i < this.docs.length; ++i) {
                this.addAssociation(null, SUBMISSION_SET, this.docs[i].getDocumentID(), HAS_MEMBER, ORIGINAL);
            }
            String folders = this.mdValues.getProperty("folder_assoc.uniqueId");
            if (folders != null) {
                StringTokenizer st = new StringTokenizer(folders, "|");
                while (st.hasMoreTokens()) {
                    String uuid = st.nextToken();
                    for (int i3 = 0; i3 < this.docs.length; ++i3) {
                        folderDocAssocID = FOLDER_DOC_ASSOC + fldrDocIdx++;
                        this.addAssociation(folderDocAssocID, uuid, this.docs[i3].getDocumentID(), HAS_MEMBER, null);
                        this.addAssociation(null, SUBMISSION_SET, folderDocAssocID, HAS_MEMBER, null);
                    }
                    this.addObjectRef(uuid);
                }
            }
        }
        this.addDocRefs();
        this.th.endElement(URN_RIM, TAG_LEAFREGISTRYOBJECTLIST, TAG_LEAFREGISTRYOBJECTLIST);
    }

    private void addDocRefs() throws SAXException {
        if (this.docs != null) {
            ArrayList<String> objectRefs = new ArrayList<String>();
            for (int i = 0; i < this.docs.length; ++i) {
                List assocs = this.docs[i].getAssociations();
                if (assocs == null) continue;
                for (XDSIDocument.Association assoc : assocs) {
                    String uuid = assoc.getUUID();
                    this.addAssociation(null, this.docs[i].getDocumentID(), uuid, assoc.getType(), assoc.getStatus());
                    if (objectRefs.contains(uuid)) continue;
                    this.addObjectRef(uuid);
                    objectRefs.add(uuid);
                }
            }
        }
    }

    private void addAssociation(String id, String sourceObject, String targetObject, String type, String status) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        if (id != null) {
            attr.addAttribute("", "id", "id", "", id);
        }
        attr.addAttribute("", "associationType", "associationType", "", type);
        attr.addAttribute("", "sourceObject", "sourceObject", "", sourceObject);
        attr.addAttribute("", "targetObject", "targetObject", "", targetObject);
        status = this.checkStatus(status, type);
        this.th.startElement("", TAG_ASSOCIATION, TAG_ASSOCIATION, attr);
        if (status != null) {
            this.addSlot("SubmissionSetStatus", status);
        }
        this.th.endElement("", TAG_ASSOCIATION, TAG_ASSOCIATION);
    }

    private String checkStatus(String status, String type) {
        if (status == null) {
            return null;
        }
        if (type == null || !type.endsWith(HAS_MEMBER)) {
            return null;
        }
        return status;
    }

    private void addObjectRef(String id) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "", id);
        this.th.startElement("", TAG_OBJECTREF, TAG_OBJECTREF, attr);
        this.th.endElement("", TAG_OBJECTREF, TAG_OBJECTREF);
    }

    private void addClassification(String object, String node) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", ATTR_CLASSIFIED_OBJECT, ATTR_CLASSIFIED_OBJECT, "", object);
        attr.addAttribute("", ATTR_CLASSIFICATION_NODE, ATTR_CLASSIFICATION_NODE, "", node);
        this.th.startElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION, attr);
        this.th.endElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION);
    }

    private void addClassification(String scheme, String object, String node, String name, String codingSchemeOID) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", ATTR_CLASSIFIED_OBJECT, ATTR_CLASSIFIED_OBJECT, "", object);
        attr.addAttribute("", ATTR_CLASSIFICATION_SCHEME, ATTR_CLASSIFICATION_SCHEME, "", scheme);
        attr.addAttribute("", ATTR_NODE_REPRESENTATION, ATTR_NODE_REPRESENTATION, "", node);
        this.th.startElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION, attr);
        this.addLocalized(TAG_NAME, EMPTY_ATTRIBUTES, name);
        this.addSlot("codingScheme", new String[]{codingSchemeOID});
        this.th.endElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION);
    }

    private void addAuthor(String scheme, String object, String node, String authorPerson, String authorInstitution, String authorRole, String authorSpecialty) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", ATTR_CLASSIFIED_OBJECT, ATTR_CLASSIFIED_OBJECT, "", object);
        attr.addAttribute("", ATTR_CLASSIFICATION_SCHEME, ATTR_CLASSIFICATION_SCHEME, "", scheme);
        attr.addAttribute("", ATTR_NODE_REPRESENTATION, ATTR_NODE_REPRESENTATION, "", node);
        this.th.startElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION, attr);
        this.addSlot("authorPerson", new String[]{authorPerson});
        if (authorInstitution != null) {
            this.addSlot("authorInstitution", new String[]{authorInstitution});
        }
        if (authorRole != null) {
            this.addSlot("authorRole", new String[]{authorRole});
        }
        if (authorSpecialty != null) {
            this.addSlot("authorSpecialty", new String[]{authorSpecialty});
        }
        this.th.endElement("", TAG_CLASSIFICATION, TAG_CLASSIFICATION);
    }

    private void addExtrinsicObject(XDSIDocument doc) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "", doc.getDocumentID());
        String mime = doc.getMimeType();
        attr.addAttribute("", ATTR_MIMETYPE, ATTR_MIMETYPE, "", mime);
        attr.addAttribute("", ATTR_OBJECTTYPE, ATTR_OBJECTTYPE, "", "urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        this.th.startElement("", TAG_EXTRINSICOBJECT, TAG_EXTRINSICOBJECT, attr);
        Dataset cnDS = this.manifest.getItem(4235331);
        String title = cnDS != null ? cnDS.getString(524548) : this.mdValues.getProperty("docTitle", "Title?");
        this.addLocalized(TAG_NAME, EMPTY_ATTRIBUTES, title);
        this.addLocalized(TAG_DESCRIPTION, EMPTY_ATTRIBUTES, this.mdValues.getProperty("description", null));
        this.addExtrinsicEntries(doc);
        this.th.endElement("", TAG_EXTRINSICOBJECT, TAG_EXTRINSICOBJECT);
    }

    private void addExtrinsicEntries(XDSIDocument doc) throws SAXException {
        this.addSlot("creationTime", this.getTime(524306, 524307, 524323, 524339));
        this.addSlot("languageCode", this.mdValues.getProperty("languageCode", "en-us"));
        this.addSlot("serviceStartTime", this.getTime(524320, 524336, -1, -1));
        String srcPatId = this.mdValues.getProperty("srcPatientID");
        this.addSlot("sourcePatientId", srcPatId);
        this.addSlot("sourcePatientInfo", this.getPatientInfo(srcPatId));
        if ("true".equals(this.mdValues.getProperty("useOldAuthorSlot"))) {
            this.addSlot("authorSpeciality", this.mdValues.getProperty("authorSpeciality", null));
            this.addSlot("authorInstitution", this.mdValues.getProperty("authorInstitution", null));
            this.addSlot("authorPerson", this.mdValues.getProperty("authorPerson", null));
            this.addSlot("authorRole", this.mdValues.getProperty("authorRole", null));
            this.addSlot("authorRoleDisplayName", this.mdValues.getProperty("authorRoleDisplayName", null));
        } else {
            this.addAuthor("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d", doc.getDocumentID(), "", this.mdValues.getProperty("authorPerson", null), this.mdValues.getProperty("authorInstitution", null), this.mdValues.getProperty("authorRole", null), this.mdValues.getProperty("authorSpeciality", null));
        }
        this.addClassification("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", doc.getDocumentID(), this.mdValues.getProperty("classCode", "Education"), this.mdValues.getProperty("classCodeDisplayName", "Education"), this.mdValues.getProperty("classCodeCodingSchemeOID", "Connect-a-thon classCodes"));
        this.addClassification("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", doc.getDocumentID(), this.mdValues.getProperty("confidentialityCode", "C"), this.mdValues.getProperty("confidentialityCodeDN", "Celebrity"), this.mdValues.getProperty("confidentialityCodeCodingSchemeOID", "Connect-a-thon confidentialityCodes"));
        this.addEventCodeList(doc);
        String mime = doc.getMimeType();
        if ("application/dicom".equals(mime)) {
            this.addClassification("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", doc.getDocumentID(), "1.2.840.10008.5.1.4.1.1.88.59", "Key Object Selection Document", "1.2.840.10008.2.6.1");
        } else {
            this.addClassification("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", doc.getDocumentID(), this.mdValues.getProperty("formatCode." + mime, "PDF"), this.mdValues.getProperty("formatCodeDN." + mime, "PDF Document"), this.mdValues.getProperty("formatCodeCodingSchemeOID." + mime, "Connect-a-thon formatCodes"));
        }
        this.addClassification("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", doc.getDocumentID(), this.mdValues.getProperty("healthCareFacilityTypeCode", "Assisted Living"), this.mdValues.getProperty("healthCareFacilityTypeCodeDN", "Assisted Living"), this.mdValues.getProperty("healthCareFacilityTypeCodeCodingSchemeOID", "Connect-a-thon healthcareFacilityTypeCodes"));
        this.addClassification("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", doc.getDocumentID(), this.mdValues.getProperty("practiceSettingCode", "Cardiology"), this.mdValues.getProperty("practiceSettingCodeDN", "Cardiology"), this.mdValues.getProperty("practiceSettingCodeCodingSchemeOID", "Connect-a-thon practiceSettingCodes"));
        this.addClassification("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983", doc.getDocumentID(), this.mdValues.getProperty("typeCode", "34098-4"), this.mdValues.getProperty("typeCodeDN", "Conference Evaluation Note"), this.mdValues.getProperty("typeCodeCodingSchemeOID", "LOINC"));
        this.addExternalIdentifier("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", "XDSDocumentEntry.uniqueId", doc.getUniqueID());
        this.addExternalIdentifier("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", "XDSDocumentEntry.patientId", this.mdValues.getProperty("xadPatientID"));
    }

    private void addEventCodeList(XDSIDocument doc) throws SAXException {
        String eventCodeList = this.mdValues.getProperty("eventCodeList");
        if (eventCodeList == null || eventCodeList.trim().length() < 1) {
            return;
        }
        StringTokenizer st = new StringTokenizer(eventCodeList, "|");
        while (st.hasMoreTokens()) {
            String[] code = StringUtils.split(st.nextToken(), '^');
            this.addClassification("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", doc.getDocumentID(), code[0], code.length > 1 ? code[1] : code[0], code.length > 2 ? code[2] : this.mdValues.getProperty("eventCodeListCodingSchemeOID", "Connect-a-thon confidentialityCodes"));
        }
    }

    private String getTime(int dateTag, int timeTag, int alternateDateTag, int alternateTimeTag) {
        String time;
        String date = this.manifest.getString(dateTag);
        if (date == null) {
            if (alternateDateTag > 0) {
                date = this.manifest.getString(alternateDateTag);
            }
            if (date == null) {
                return formatter.format(new Date());
            }
            if (alternateTimeTag != -1) {
                time = this.manifest.getString(alternateTimeTag);
                if (time == null) {
                    time = DEFAULT_TIME_STRING;
                }
            } else {
                time = DEFAULT_TIME_STRING;
            }
        } else if (timeTag != -1) {
            time = this.manifest.getString(timeTag);
            if (time == null) {
                time = DEFAULT_TIME_STRING;
            }
        } else {
            time = DEFAULT_TIME_STRING;
        }
        return date + time.substring(0, 6);
    }

    private String[] getPatientInfo(String patId) {
        String[] values = new String[5];
        values[0] = "PID-3|" + patId;
        values[1] = "PID-5|" + this.manifest.getString(0x100010);
        String birthdate = this.manifest.getString(0x100030);
        if (birthdate == null) {
            values[2] = null;
        } else {
            String birthtime = this.manifest.getString(1048626);
            values[2] = "PID-7|" + birthdate + (birthtime != null ? birthtime : DEFAULT_TIME_STRING);
        }
        String sex = this.manifest.getString(0x100040);
        values[3] = "PID-8|" + (sex != null ? sex : "U");
        String addr = this.manifest.getString(0x101040);
        values[4] = addr == null ? null : "PID-11|" + this.manifest.getString(0x101040);
        return values;
    }

    public String getSubmissionSetUID() {
        return this.submissionSetUID;
    }

    public String getSubmissionSetPatId() {
        return this.submissionSetPatId;
    }

    private void addSlot(String name, String value) throws SAXException {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        this.addSlot(name, stringArray);
    }

    private void addSlot(String name, String[] values) throws SAXException {
        if (values != null) {
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "name", "name", "", name);
            this.th.startElement("", TAG_SLOT, TAG_SLOT, attr);
            this.th.startElement("", TAG_VALUELIST, TAG_VALUELIST, EMPTY_ATTRIBUTES);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this.th.startElement("", TAG_VALUE, TAG_VALUE, EMPTY_ATTRIBUTES);
                this.th.characters(values[i].toCharArray(), 0, values[i].length());
                this.th.endElement("", TAG_VALUE, TAG_VALUE);
            }
            this.th.endElement("", TAG_VALUELIST, TAG_VALUELIST);
            this.th.endElement("", TAG_SLOT, TAG_SLOT);
        }
    }

    private void addSubmissionRegistryPackage(String id, String title) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "", id);
        this.th.startElement("", TAG_REGISTRYPACKAGE, TAG_REGISTRYPACKAGE, attr);
        this.addLocalized(TAG_NAME, EMPTY_ATTRIBUTES, title);
        this.addLocalized(TAG_DESCRIPTION, EMPTY_ATTRIBUTES, this.mdValues.getProperty("comments", null));
        this.addRegistryEntries(id);
        this.th.endElement("", TAG_REGISTRYPACKAGE, TAG_REGISTRYPACKAGE);
    }

    private void addRegistryEntries(String id) throws SAXException {
        String time = this.mdValues.getProperty("submissionTime");
        if (time == null) {
            time = formatter.format(new Date());
        }
        this.addSlot("submissionTime", time);
        if ("true".equals(this.mdValues.getProperty("useOldAuthorSlot"))) {
            this.addSlot("authorDepartment", this.mdValues.getProperty("authorDepartment", null));
            this.addSlot("authorInstitution", this.mdValues.getProperty("authorInstitution", null));
            this.addSlot("authorPerson", this.mdValues.getProperty("authorPerson", null));
        } else {
            this.addAuthor("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d", id, "", this.mdValues.getProperty("authorPerson", null), this.mdValues.getProperty("authorInstitution", null), this.mdValues.getProperty("authorRole", null), this.mdValues.getProperty("authorSpeciality", null));
        }
        this.addClassification("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500", SUBMISSION_SET, this.mdValues.getProperty("contentTypeCode", "Group counseling"), this.mdValues.getProperty("contentTypeCodeDN", "Group counseling"), this.mdValues.getProperty("contentTypeCodeCodingSchemeOID", "Connect-a-thon contentTypeCodes"));
        String uniqueId = this.mdValues.getProperty("uniqueId");
        if (uniqueId == null) {
            uniqueId = UIDGeneratorImpl.getInstance().createUID();
        }
        this.submissionSetUID = uniqueId;
        this.submissionSetPatId = this.mdValues.getProperty("xadPatientID");
        this.addExternalIdentifier("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8", "XDSSubmissionSet.uniqueId", uniqueId);
        this.addExternalIdentifier("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832", "XDSSubmissionSet.sourceId", this.mdValues.getProperty("sourceId", uniqueId));
        this.addExternalIdentifier("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", "XDSSubmissionSet.patientId", this.submissionSetPatId);
    }

    private void addFolderRegistryPackage(String id, String title) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "id", "id", "", id);
        this.th.startElement("", TAG_REGISTRYPACKAGE, TAG_REGISTRYPACKAGE, attr);
        this.addLocalized(TAG_NAME, EMPTY_ATTRIBUTES, title);
        this.addLocalized(TAG_DESCRIPTION, EMPTY_ATTRIBUTES, this.mdValues.getProperty("folder.comments", null));
        this.addFolderEntries();
        this.th.endElement("", TAG_REGISTRYPACKAGE, TAG_REGISTRYPACKAGE);
    }

    private void addFolderEntries() throws SAXException {
        String uniqueId = this.mdValues.getProperty("xdsfolder.uniqueId");
        if (uniqueId == null) {
            uniqueId = UIDGeneratorImpl.getInstance().createUID();
        }
        this.addExternalIdentifier("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a", "XDSFolder.uniqueId", uniqueId);
        this.addExternalIdentifier("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a", "XDSFolder.patientId", this.mdValues.getProperty("xadPatientID"));
        this.addClassification("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5", uniqueId, this.mdValues.getProperty("folderCode", "default"), this.mdValues.getProperty("folderCodeDN", "default folderCodes"), this.mdValues.getProperty("folderCodeCodingSchemeOID", "Connect-a-thon folderCodes"));
    }

    private void addExternalIdentifier(String scheme, String name, String value) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "identificationScheme", "identificationScheme", "", scheme);
        attr.addAttribute("", "value", "value", "", value);
        this.th.startElement("", TAG_EXTERNAL_IDENTIFIER, TAG_EXTERNAL_IDENTIFIER, attr);
        this.addLocalized(TAG_NAME, EMPTY_ATTRIBUTES, name);
        this.th.endElement("", TAG_EXTERNAL_IDENTIFIER, TAG_EXTERNAL_IDENTIFIER);
    }

    private void addLocalized(String name, Attributes attr, String value) throws SAXException {
        this.th.startElement("", name, name, attr);
        if (value != null) {
            AttributesImpl valAttr = new AttributesImpl();
            valAttr.addAttribute("", "value", "value", "", value);
            this.th.startElement("", TAG_LOCALIZEDSTRING, TAG_LOCALIZEDSTRING, valAttr);
            this.th.endElement("", TAG_LOCALIZEDSTRING, TAG_LOCALIZEDSTRING);
        }
        this.th.endElement("", name, name);
    }
}

