/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.xdsi;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.UIDs;
import org.dcm4che.util.UIDGenerator;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.DataExportMessage;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.dcm.ianscu.IANScuService;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.jdbc.QueryFilesCmd;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.xdsi.XDSIDatasetDocument;
import org.dcm4chex.archive.xdsi.XDSIDocument;
import org.dcm4chex.archive.xdsi.XDSIFileDocument;
import org.dcm4chex.archive.xdsi.XDSIURLDocument;
import org.dcm4chex.archive.xdsi.XDSMetadata;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XDSIService
extends ServiceMBeanSupport {
    private static final String DEFAULT_XDSB_SOURCE_SERVICE = "dcm4chee.xds:service=XDSbSourceService";
    public static final String DOCUMENT_ID = "doc_1";
    public static final String PDF_DOCUMENT_ID = "pdf_doc_1";
    public static final String AUTHOR_SPECIALITY = "authorSpeciality";
    public static final String AUTHOR_PERSON = "authorPerson";
    public static final String AUTHOR_ROLE = "authorRole";
    public static final String AUTHOR_ROLE_DISPLAYNAME = "authorRoleDisplayName";
    public static final String AUTHOR_INSTITUTION = "authorInstitution";
    public static final String SOURCE_ID = "sourceId";
    private static final String NONE = "NONE";
    private ObjectName ianScuServiceName;
    private ObjectName keyObjectServiceName;
    private ObjectName xdsbSourceServiceName;
    private ObjectName xdsHttpCfgServiceName;
    private Boolean httpCfgServiceAvailable;
    protected String[] autoPublishAETs;
    private String autoPublishDocTitle;
    private static Logger log = Logger.getLogger((String)XDSIService.class.getName());
    private Map usr2author = new TreeMap();
    private String docRepositoryURI;
    private String docRepositoryAET;
    private File propertyFile;
    private File docTitleCodeListFile;
    private File classCodeListFile;
    private File contentTypeCodeListFile;
    private File eventCodeListFile;
    private File healthCareFacilityCodeListFile;
    private File autoPublishPropertyFile;
    private List authorRoles = new ArrayList();
    private List confidentialityCodes;
    private Properties metadataProps = new Properties();
    private Map mapCodeLists = new HashMap();
    private ObjectName pixQueryServiceName;
    private String sourceID;
    private String localDomain;
    private String affinityDomain;
    private String ridURL;
    private boolean logSOAPMessage = true;
    private boolean indentSOAPLog = true;
    private boolean useXDSb = false;
    private boolean removeNamespaceID = false;
    private final NotificationListener ianListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            log.info((Object)"ianListener called!");
            XDSIService.this.onIAN((Dataset)notif.getUserData());
        }
    };
    private boolean logITI15;

    public String getPropertyFile() {
        return this.propertyFile.getPath();
    }

    public void setPropertyFile(String file) throws IOException {
        if (file == null || file.trim().length() < 1) {
            return;
        }
        this.propertyFile = new File(file.replace('/', File.separatorChar));
        try {
            this.readPropertyFile();
        }
        catch (Throwable ignore) {
            log.warn((Object)("Property file " + file + " cant be read!"));
        }
    }

    public String getDocTitleCodeListFile() {
        return this.docTitleCodeListFile == null ? null : this.docTitleCodeListFile.getPath();
    }

    public void setDocTitleCodeListFile(String file) throws IOException {
        this.docTitleCodeListFile = file == null || file.trim().length() < 1 ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getClassCodeListFile() {
        return this.classCodeListFile == null ? null : this.classCodeListFile.getPath();
    }

    public void setClassCodeListFile(String file) throws IOException {
        this.classCodeListFile = file == null || file.trim().length() < 1 ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getContentTypeCodeListFile() {
        return this.contentTypeCodeListFile == null ? null : this.contentTypeCodeListFile.getPath();
    }

    public void setContentTypeCodeListFile(String file) throws IOException {
        this.contentTypeCodeListFile = file == null || file.trim().length() < 1 ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getHealthCareFacilityCodeListFile() {
        return this.healthCareFacilityCodeListFile == null ? null : this.healthCareFacilityCodeListFile.getPath();
    }

    public void setHealthCareFacilityCodeListFile(String file) throws IOException {
        this.healthCareFacilityCodeListFile = file == null || file.trim().length() < 1 ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getEventCodeListFile() {
        return this.eventCodeListFile == null ? null : this.eventCodeListFile.getPath();
    }

    public void setEventCodeListFile(String file) throws IOException {
        this.eventCodeListFile = file == null || file.trim().length() < 1 ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getConfidentialityCodes() {
        return this.getListString(this.confidentialityCodes);
    }

    public void setConfidentialityCodes(String codes) throws IOException {
        this.confidentialityCodes = this.setListString(codes);
    }

    public String getAuthorPersonMapping() {
        if (this.usr2author.isEmpty()) {
            return this.metadataProps.getProperty(AUTHOR_PERSON);
        }
        return this.getMappingString(this.usr2author);
    }

    public void setAuthorPersonMapping(String s) {
        if (s == null || s.trim().length() < 1) {
            return;
        }
        this.usr2author.clear();
        if (s.indexOf(61) == -1) {
            this.metadataProps.setProperty(AUTHOR_PERSON, s);
        } else {
            this.addMappingString(s, this.usr2author);
        }
    }

    public String getAuthorPerson(String user) {
        String person = (String)this.usr2author.get(user);
        if (person == null) {
            person = this.metadataProps.getProperty(AUTHOR_PERSON);
        }
        return person;
    }

    public String getSourceID() {
        if (this.sourceID == null) {
            this.sourceID = this.metadataProps.getProperty(SOURCE_ID);
        }
        return this.sourceID;
    }

    public void setSourceID(String id) {
        this.sourceID = id;
        if (this.sourceID != null) {
            this.metadataProps.setProperty(SOURCE_ID, this.sourceID);
        }
    }

    public String getAuthorRoles() {
        return this.getListString(this.authorRoles);
    }

    public void setAuthorRoles(String s) {
        if (s == null || s.trim().length() < 1) {
            return;
        }
        this.authorRoles = this.setListString(s);
    }

    public Properties joinMetadataProperties(Properties props) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.metadataProps);
        if (props == null) {
            p.putAll((Map<?, ?>)props);
        }
        return p;
    }

    public String getDocRepositoryURI() {
        return this.docRepositoryURI;
    }

    public void setDocRepositoryURI(String docRepositoryURI) {
        this.docRepositoryURI = docRepositoryURI;
    }

    public String getDocRepositoryAET() {
        return this.docRepositoryAET == null ? NONE : this.docRepositoryAET;
    }

    public void setDocRepositoryAET(String docRepositoryAET) {
        this.docRepositoryAET = NONE.equals(docRepositoryAET) ? null : docRepositoryAET;
    }

    public final ObjectName getPixQueryServiceName() {
        return this.pixQueryServiceName;
    }

    public final void setPixQueryServiceName(ObjectName name) {
        this.pixQueryServiceName = name;
    }

    public final ObjectName getIANScuServiceName() {
        return this.ianScuServiceName;
    }

    public final void setIANScuServiceName(ObjectName ianScuServiceName) {
        this.ianScuServiceName = ianScuServiceName;
    }

    public final ObjectName getKeyObjectServiceName() {
        return this.keyObjectServiceName;
    }

    public final void setKeyObjectServiceName(ObjectName keyObjectServiceName) {
        this.keyObjectServiceName = keyObjectServiceName;
    }

    public String getXdsbSourceServiceName() {
        return this.xdsbSourceServiceName == null ? NONE : this.xdsbSourceServiceName.toString();
    }

    public void setXdsbSourceServiceName(String name) throws MalformedObjectNameException, NullPointerException {
        this.xdsbSourceServiceName = NONE.equals(name) ? null : ObjectName.getInstance(name);
    }

    public String getXdsHttpCfgServiceName() {
        return this.xdsHttpCfgServiceName == null ? NONE : this.xdsHttpCfgServiceName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXdsHttpCfgServiceName(String name) throws MalformedObjectNameException, NullPointerException {
        try {
            this.xdsHttpCfgServiceName = NONE.equals(name) ? null : ObjectName.getInstance(name);
            Object var3_2 = null;
            this.httpCfgServiceAvailable = this.xdsHttpCfgServiceName == null ? Boolean.FALSE : null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.httpCfgServiceAvailable = this.xdsHttpCfgServiceName == null ? Boolean.FALSE : null;
            throw throwable;
        }
    }

    public boolean isHttpCfgServiceAvailable() {
        if (this.httpCfgServiceAvailable == null) {
            if (this.xdsHttpCfgServiceName != null) {
                this.httpCfgServiceAvailable = this.server.isRegistered(this.xdsHttpCfgServiceName) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                return false;
            }
        }
        return this.httpCfgServiceAvailable;
    }

    public boolean isUseXDSb() {
        return this.useXDSb;
    }

    public void setUseXDSb(boolean useXDSb) {
        if (this.useXDSb != useXDSb) {
            this.useXDSb = useXDSb;
            if (useXDSb && this.xdsbSourceServiceName == null) {
                try {
                    this.setXdsbSourceServiceName(DEFAULT_XDSB_SOURCE_SERVICE);
                }
                catch (Exception x) {
                    log.warn((Object)"Cant set default XDS.b Service (dcm4chee.xds:service=XDSbSourceService)!", (Throwable)x);
                }
            }
        }
    }

    public boolean isLogITI15() {
        return this.logITI15;
    }

    public void setLogITI15(boolean logIti15) {
        this.logITI15 = logIti15;
    }

    public final String getAutoPublishAETs() {
        return this.autoPublishAETs.length > 0 ? StringUtils.toString(this.autoPublishAETs, '\\') : NONE;
    }

    public final void setAutoPublishAETs(String autoPublishAETs) {
        this.autoPublishAETs = NONE.equalsIgnoreCase(autoPublishAETs) ? new String[]{} : StringUtils.split(autoPublishAETs, '\\');
    }

    public final String getAutoPublishDocTitle() {
        return this.autoPublishDocTitle;
    }

    public final void setAutoPublishDocTitle(String autoPublishDocTitle) {
        this.autoPublishDocTitle = autoPublishDocTitle;
    }

    public String getAutoPublishPropertyFile() {
        return this.autoPublishPropertyFile == null ? NONE : this.autoPublishPropertyFile.getPath();
    }

    public void setAutoPublishPropertyFile(String file) throws IOException {
        this.autoPublishPropertyFile = file == null || file.trim().length() < 1 || file.equalsIgnoreCase(NONE) ? null : new File(file.replace('/', File.separatorChar));
    }

    public String getLocalDomain() {
        return this.localDomain == null ? NONE : this.localDomain;
    }

    public void setLocalDomain(String domain) {
        this.localDomain = domain == null || domain.trim().length() < 1 || domain.equalsIgnoreCase(NONE) ? null : domain;
    }

    public String getAffinityDomain() {
        return this.affinityDomain;
    }

    public void setAffinityDomain(String domain) {
        this.affinityDomain = domain;
    }

    public boolean isRemoveNamespaceID() {
        return this.removeNamespaceID;
    }

    public void setRemoveNamespaceID(boolean removeNamespaceID) {
        this.removeNamespaceID = removeNamespaceID;
    }

    private void addMappingString(String s, Map map) {
        StringTokenizer st = new StringTokenizer(s, ",;\n\r\t ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int pos = t.indexOf(61);
            if (pos == -1) {
                map.put(t, t);
                continue;
            }
            map.put(t.substring(0, pos), t.substring(++pos));
        }
    }

    private String getMappingString(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            sb.append(key).append('=').append(map.get(key)).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    private List setListString(String s) {
        ArrayList<String> l = new ArrayList<String>();
        if (NONE.equals(s)) {
            return l;
        }
        StringTokenizer st = new StringTokenizer(s, ";\n\r");
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    private String getListString(List l) {
        if (l == null || l.isEmpty()) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public String getRidURL() {
        return this.ridURL;
    }

    public void setRidURL(String ridURL) {
        this.ridURL = ridURL;
    }

    public boolean isLogSOAPMessage() {
        return this.logSOAPMessage;
    }

    public void setLogSOAPMessage(boolean logSOAPMessage) {
        this.logSOAPMessage = logSOAPMessage;
    }

    public boolean isIndentSOAPLog() {
        return this.indentSOAPLog;
    }

    public void setIndentSOAPLog(boolean indentSOAPLog) {
        this.indentSOAPLog = indentSOAPLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPropertyFile() throws IOException {
        File propFile = FileUtils.resolve(this.propertyFile);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(propFile));
        try {
            this.metadataProps.clear();
            this.metadataProps.load(bis);
            if (this.sourceID != null) {
                this.metadataProps.setProperty(SOURCE_ID, this.sourceID);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            bis.close();
            throw throwable;
        }
        bis.close();
    }

    public List listAuthorRoles() throws IOException {
        return this.authorRoles;
    }

    public List listDocTitleCodes() throws IOException {
        return this.readCodeFile(this.docTitleCodeListFile);
    }

    public List listEventCodes() throws IOException {
        return this.readCodeFile(this.eventCodeListFile);
    }

    public List listClassCodes() throws IOException {
        return this.readCodeFile(this.classCodeListFile);
    }

    public List listContentTypeCodes() throws IOException {
        return this.readCodeFile(this.contentTypeCodeListFile);
    }

    public List listHealthCareFacilityTypeCodes() throws IOException {
        return this.readCodeFile(this.healthCareFacilityCodeListFile);
    }

    public List listConfidentialityCodes() throws IOException {
        return this.confidentialityCodes;
    }

    public List readCodeFile(File codeFile) throws IOException {
        if (codeFile == null) {
            return new ArrayList();
        }
        ArrayList<String> l = (ArrayList<String>)this.mapCodeLists.get(codeFile);
        if (l == null) {
            l = new ArrayList<String>();
            File file = FileUtils.resolve(codeFile);
            if (file.exists()) {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(file));
                while ((line = r.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    l.add(line);
                }
                log.debug((Object)("Codes read from code file " + codeFile));
                log.debug((Object)("Codes:" + l));
                this.mapCodeLists.put(codeFile, l);
            } else {
                log.warn((Object)("Code File " + file + " does not exist! return empty code list!"));
            }
        }
        return l;
    }

    public void clearCodeFileCache() {
        this.mapCodeLists.clear();
    }

    public boolean sendSOAP(String metaDataFilename, String docNames, String url) {
        File metaDataFile = new File(metaDataFilename);
        XDSIDocument[] docFiles = null;
        if (docNames != null && docNames.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(docNames, ",");
            docFiles = new XDSIDocument[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                docFiles[i] = XDSIFileDocument.valueOf(st.nextToken());
                ++i;
            }
        }
        return this.sendSOAP(this.readXMLFile(metaDataFile), docFiles, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendSOAP(Document metaData, XDSIDocument[] docs, String url) {
        boolean bl;
        if (this.isUseXDSb()) {
            if (this.xdsbSourceServiceName != null) {
                return this.exportXDSb(metaData, docs);
            }
            log.warn((Object)"UseXDSb is enabled but XdsbSourceServiceName is not configured! Use XDS.a instead!");
        }
        if (url == null) {
            url = this.docRepositoryURI;
        }
        log.info((Object)("Send 'Provide and Register Document Set' request to " + url));
        SOAPConnection conn = null;
        try {
            try {
                this.configTLS(url);
                MessageFactory messageFactory = MessageFactory.newInstance();
                SOAPMessage message = messageFactory.createMessage();
                MimeHeaders hd = message.getMimeHeaders();
                hd.addHeader("SOAPAction", "urn:ihe:iti:2007:ProvideAndRegisterDocumentSet");
                SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                SOAPBody soapBody = envelope.getBody();
                SOAPBodyElement bodyElement = soapBody.addDocument(metaData);
                if (docs != null) {
                    for (int i = 0; i < docs.length; ++i) {
                        DataHandler dhAttachment = docs[i].getDataHandler();
                        AttachmentPart part = message.createAttachmentPart(dhAttachment);
                        part.setMimeHeader("Content-Type", docs[i].getMimeType());
                        String docId = docs[i].getDocumentID();
                        if (docId.charAt(0) != '<') {
                            docId = "<" + docId + ">";
                        }
                        part.setContentId(docId);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Add Attachment Part (" + (i + 1) + "/" + docs.length + ")! Document ID:" + part.getContentId() + " mime:" + docs[i].getMimeType()));
                        }
                        message.addAttachmentPart(part);
                    }
                }
                SOAPConnectionFactory connFactory = SOAPConnectionFactory.newInstance();
                conn = connFactory.createConnection();
                log.info((Object)"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                log.info((Object)("send request to " + url));
                if (this.logSOAPMessage) {
                    log.info((Object)"-------------------------------- request  ----------------------------------");
                }
                this.dumpSOAPMessage(message);
                SOAPMessage response = conn.call(message, (Object)url);
                if (!this.logSOAPMessage) {
                    log.info((Object)"-------------------------------- response ----------------------------------");
                }
                this.dumpSOAPMessage(response);
                if (this.logSOAPMessage) {
                    log.info((Object)"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                }
                bl = this.checkResponse(response);
                Object var16_19 = null;
                if (conn == null) return bl;
            }
            catch (Throwable x) {
                log.error((Object)"Cant send SOAP message! Reason:", x);
                boolean bl2 = false;
                Object var16_20 = null;
                if (conn == null) return bl2;
                try {
                    conn.close();
                    return bl2;
                }
                catch (SOAPException ignore) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (conn == null) throw throwable;
            try {}
            catch (SOAPException ignore) {
                throw throwable;
            }
            conn.close();
            throw throwable;
        }
        try {}
        catch (SOAPException ignore) {
            // empty catch block
            return bl;
        }
        conn.close();
        return bl;
    }

    private void configTLS(String url) {
        if (this.isHttpCfgServiceAvailable()) {
            try {
                this.server.invoke(this.xdsHttpCfgServiceName, "configTLS", new Object[]{url}, new String[]{String.class.getName()});
            }
            catch (Exception x) {
                log.error((Object)("Exception occured in configTLS: " + x.getMessage()), (Throwable)x);
            }
        }
    }

    private boolean exportXDSb(Document metaData, XDSIDocument[] docs) {
        log.info((Object)"export Document(s) as XDS.b Document Source!");
        Node rsp = null;
        try {
            HashMap<String, DataHandler> mapDocs = new HashMap<String, DataHandler>();
            if (docs != null) {
                for (int i = 0; i < docs.length; ++i) {
                    mapDocs.put(docs[i].getDocumentID(), docs[i].getDataHandler());
                }
            }
            log.info((Object)"call xds.b exportDocuments");
            rsp = (Node)this.server.invoke(this.xdsbSourceServiceName, "exportDocuments", new Object[]{metaData, mapDocs}, new String[]{Node.class.getName(), Map.class.getName()});
            log.info((Object)("response from xds.b exportDocuments:" + rsp));
            return this.checkResponse(rsp.getFirstChild());
        }
        catch (Exception x) {
            log.error((Object)"Export Documents failed via XDS.b transaction", (Throwable)x);
            return false;
        }
    }

    private void logITI15(String submissionUid, String patId, boolean success) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("log ITI-15 (XDS export) message! submissionUid:" + submissionUid + " patId:" + patId + " success:" + success));
        }
        try {
            this.server.invoke(this.xdsbSourceServiceName, "logExport", new Object[]{submissionUid, patId, new Boolean(success)}, new String[]{String.class.getName(), String.class.getName(), "boolean"});
        }
        catch (Exception x) {
            log.error((Object)"Audit log ITI-15 failed!", (Throwable)x);
        }
    }

    public static String resolvePath(String fn) {
        File f = new File(fn);
        if (f.isAbsolute()) {
            return f.getAbsolutePath();
        }
        File serverHomeDir = new File(System.getProperty("jboss.server.home.dir"));
        return new File(serverHomeDir, f.getPath()).getAbsolutePath();
    }

    public boolean sendSOAP(String kosIuid, Properties mdProps) throws SQLException {
        List files;
        Dataset kos = this.queryInstance(kosIuid);
        if (kos == null) {
            return false;
        }
        if (mdProps == null) {
            mdProps = this.metadataProps;
        }
        if ((files = new QueryFilesCmd(kosIuid).getFileDTOs()) == null || files.size() == 0) {
            return false;
        }
        FileDTO fileDTO = (FileDTO)files.iterator().next();
        File file = FileUtils.toFile(fileDTO.getDirectoryPath(), fileDTO.getFilePath());
        XDSIDocument[] docs = new XDSIFileDocument[]{new XDSIFileDocument(file, "application/dicom", DOCUMENT_ID, kosIuid)};
        XDSMetadata md = new XDSMetadata(kos, mdProps, docs);
        Document metadata = md.getMetadata();
        return this.sendSOAP(metadata, docs, null);
    }

    private Dataset queryInstance(String iuid) {
        try {
            return this.getContentManager().getInstanceInfo(iuid, true);
        }
        catch (Exception e) {
            log.error((Object)("Query for SOP Instance UID:" + iuid + " failed!"), (Throwable)e);
            return null;
        }
    }

    public boolean sendSOAP(String kosIuid) throws SQLException {
        Dataset kos = this.queryInstance(kosIuid);
        return this.sendSOAP(kos, null);
    }

    public boolean sendSOAP(Dataset kos, Properties mdProps) throws SQLException {
        XDSIDocument[] docs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Key Selection Object:");
            log.debug((Object)kos);
        }
        if (kos == null) {
            return false;
        }
        if (mdProps == null) {
            mdProps = this.metadataProps;
        }
        String user = mdProps.getProperty("user");
        mdProps.setProperty("xadPatientID", this.getAffinityDomainPatientID(kos));
        mdProps.setProperty("srcPatientID", this.getSourcePatientID(kos));
        String pdfIUID = mdProps.getProperty("pdf_iuid");
        if (pdfIUID == null || !UIDs.isValid(pdfIUID)) {
            docs = new XDSIDocument[]{new XDSIDatasetDocument(kos, "application/dicom", DOCUMENT_ID)};
        } else {
            String pdfUID = UIDGenerator.getInstance().createUID();
            log.info((Object)("Add PDF document with IUID " + pdfIUID + " to this submission set!"));
            try {
                docs = new XDSIDocument[]{new XDSIDatasetDocument(kos, "application/dicom", DOCUMENT_ID), new XDSIURLDocument(new URL(this.ridURL + pdfIUID), "application/pdf", PDF_DOCUMENT_ID, pdfUID)};
            }
            catch (Exception x) {
                log.error((Object)("Cant attach PDF document! :" + x.getMessage()), (Throwable)x);
                return false;
            }
        }
        this.addAssociations(docs, mdProps);
        XDSMetadata md = new XDSMetadata(kos, mdProps, docs);
        Document metadata = md.getMetadata();
        boolean b = this.sendSOAP(metadata, docs, null);
        this.logExport(md, user, b);
        return b;
    }

    private void addAssociations(XDSIDocument[] docs, Properties mdProps) {
        if (mdProps.getProperty("nrOfAssociations") == null) {
            return;
        }
        int len = Integer.parseInt(mdProps.getProperty("nrOfAssociations"));
        for (int i = 0; i < len; ++i) {
            String assoc = mdProps.getProperty("association_" + i);
            StringTokenizer st = new StringTokenizer(assoc, "|");
            String uuid = st.nextToken();
            String type = st.nextToken();
            String status = st.nextToken();
            for (int j = 0; j < docs.length; ++j) {
                docs[j].addAssociation(uuid, type, status);
            }
        }
    }

    public boolean exportPDF(String iuid) throws SQLException, MalformedURLException {
        return this.exportPDF(iuid, null);
    }

    public boolean exportPDF(String iuid, Properties mdProps) throws SQLException, MalformedURLException {
        log.debug((Object)("export PDF to XDS Instance UID:" + iuid));
        Dataset ds = this.queryInstance(iuid);
        if (ds == null) {
            return false;
        }
        String pdfUID = UIDGenerator.getInstance().createUID();
        log.info((Object)("Document UID of exported PDF:" + pdfUID));
        ds.putUI(524312, pdfUID);
        if (mdProps == null) {
            mdProps = this.metadataProps;
        }
        String user = mdProps.getProperty("user");
        mdProps.setProperty("mimetype", "application/pdf");
        mdProps.setProperty("xadPatientID", this.getAffinityDomainPatientID(ds));
        mdProps.setProperty("srcPatientID", this.getSourcePatientID(ds));
        XDSIDocument[] docs = new XDSIURLDocument[]{new XDSIURLDocument(new URL(this.ridURL + iuid), "application/pdf", PDF_DOCUMENT_ID, pdfUID)};
        this.addAssociations(docs, mdProps);
        XDSMetadata md = new XDSMetadata(ds, mdProps, docs);
        Document metadata = md.getMetadata();
        boolean b = this.sendSOAP(metadata, docs, null);
        this.logExport(md, user, b);
        return b;
    }

    public boolean createFolder(Properties mdProps) {
        String patDsIUID = mdProps.getProperty("folder.patDatasetIUID");
        Dataset ds = this.queryInstance(patDsIUID);
        log.info((Object)("create XDS Folder for patient:" + ds.getString(0x100020)));
        mdProps.setProperty("xadPatientID", this.getAffinityDomainPatientID(ds));
        mdProps.setProperty("srcPatientID", this.getSourcePatientID(ds));
        log.info((Object)("XAD patient:" + mdProps.getProperty("xadPatientID")));
        XDSMetadata md = new XDSMetadata(null, mdProps, null);
        Document metadata = md.getMetadata();
        boolean b = this.sendSOAP(metadata, null, null);
        return b;
    }

    private Set getSUIDs(Dataset kos) {
        LinkedHashSet<String> suids = null;
        DcmElement sq = kos.get(4236149);
        if (sq != null) {
            suids = new LinkedHashSet<String>();
            int len = sq.countItems();
            for (int i = 0; i < len; ++i) {
                suids.add(sq.getItem(i).getString(0x20000D));
            }
        }
        return suids;
    }

    private void logExport(XDSMetadata metaData, String user, boolean success) {
        Dataset manifest = metaData.getManifest();
        try {
            String requestHost = null;
            HttpUserInfo userInfo = new HttpUserInfo(AuditMessage.isEnableDNSLookups());
            user = userInfo.getUserId();
            requestHost = userInfo.getHostName();
            DataExportMessage msg = new DataExportMessage();
            msg.setOutcomeIndicator(success ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addExporterProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), user == null, AuditMessage.getLocalHostName());
            if (user != null) {
                msg.addExporterPerson(user, null, null, true, requestHost);
            }
            String host = "unknown";
            try {
                host = new URL(this.docRepositoryURI).getHost();
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            msg.addDestinationMedia(this.docRepositoryURI, null, "XDS-I Export", false, host);
            msg.addPatient(manifest.getString(0x100020), manifest.getString(0x100010));
            InstanceSorter sorter = this.getInstanceSorter(manifest);
            for (String suid : sorter.getSUIDs()) {
                ParticipantObjectDescription desc = new ParticipantObjectDescription();
                for (String cuid : sorter.getCUIDs(suid)) {
                    ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
                    sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
                    desc.addSOPClass(sopClass);
                }
                msg.addStudy(suid, desc);
            }
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception ignore) {
            log.error((Object)"Audit log of XDS-I Dicom Export message failed! Ignored!", (Throwable)ignore);
        }
        if (this.logITI15 && this.xdsbSourceServiceName != null) {
            this.logITI15(metaData.getSubmissionSetUID(), metaData.getSubmissionSetPatId(), success);
        }
    }

    private InstanceSorter getInstanceSorter(Dataset dsKos) {
        InstanceSorter sorter = new InstanceSorter();
        DcmObjectFactory df = DcmObjectFactory.getInstance();
        DcmElement sq = dsKos.get(4236149);
        if (sq != null) {
            int n = sq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset refStudyItem = sq.getItem(i);
                String suid = refStudyItem.getString(0x20000D);
                DcmElement refSerSeq = refStudyItem.get(528661);
                int m = refSerSeq.countItems();
                for (int j = 0; j < m; ++j) {
                    Dataset refSer = refSerSeq.getItem(j);
                    DcmElement srcRefSOPSeq = refSer.get(528793);
                    int l = srcRefSOPSeq.countItems();
                    for (int k = 0; k < l; ++k) {
                        Dataset srcRefSOP = srcRefSOPSeq.getItem(k);
                        Dataset refSOP = df.newDataset();
                        String cuid = srcRefSOP.getString(528720);
                        refSOP.putUI(528720, cuid);
                        String iuid = srcRefSOP.getString(528725);
                        refSOP.putUI(528725, iuid);
                        sorter.addInstance(suid, cuid, iuid, null);
                    }
                }
            }
        } else {
            sorter.addInstance(dsKos.getString(0x20000D), dsKos.getString(524310), dsKos.getString(524312), null);
        }
        return sorter;
    }

    public String getAffinityDomainPatientID(Dataset kos) {
        String patID = kos.getString(0x100020);
        String issuer = kos.getString(0x100021);
        if (this.affinityDomain.charAt(0) == '=') {
            if (this.affinityDomain.length() == 1) {
                patID = patID + "^^^";
                if (issuer == null) {
                    return patID;
                }
                return patID + issuer;
            }
            if (this.affinityDomain.charAt(1) == '?') {
                log.info((Object)"PIX Query disabled: replace issuer with affinity domain! ");
                log.debug((Object)("patID changed! (" + patID + "^^^" + issuer + " -> " + patID + "^^^" + this.affinityDomain.substring(2) + ")"));
                return patID + "^^^" + this.affinityDomain.substring(2);
            }
            log.info((Object)("PIX Query disabled: replace configured patient ID! :" + this.affinityDomain.substring(1)));
            return this.affinityDomain.substring(1);
        }
        if (this.pixQueryServiceName == null) {
            log.info((Object)"PIX Query disabled: use source patient ID!");
            patID = patID + "^^^";
            if (issuer == null) {
                return patID;
            }
            return patID + issuer;
        }
        try {
            if (this.localDomain != null) {
                if (this.localDomain.charAt(0) == '=') {
                    String oldIssuer = issuer;
                    issuer = this.localDomain.substring(1);
                    log.info((Object)("PIX Query: Local affinity domain changed from " + oldIssuer + " to " + issuer));
                } else if (issuer == null) {
                    log.info((Object)("PIX Query: Unknown local affinity domain changed to " + issuer));
                    issuer = this.localDomain;
                }
            } else if (issuer == null) {
                issuer = "";
            }
            List pids = (List)this.server.invoke(this.pixQueryServiceName, "queryCorrespondingPIDs", new Object[]{patID, issuer, new String[]{this.affinityDomain}}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName()});
            Iterator iter = pids.iterator();
            while (iter.hasNext()) {
                String pid = this.toPIDString((String[])iter.next());
                log.debug((Object)("Check if from domain! PatientID:" + pid));
                if (!this.isFromDomain(pid)) continue;
                return pid;
            }
            log.error((Object)("Patient ID is not known in Affinity domain:" + this.affinityDomain));
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get patientID for Affinity Domain:", (Throwable)e);
            return null;
        }
    }

    public String getSourcePatientID(Dataset kos) {
        String patID = kos.getString(0x100020);
        String issuer = kos.getString(0x100021);
        if (this.localDomain != null) {
            if (this.localDomain.charAt(0) == '=') {
                String oldIssuer = issuer;
                issuer = this.localDomain.substring(1);
                log.info((Object)("Local domain changed from " + oldIssuer + " to " + issuer));
            } else if (issuer == null) {
                issuer = this.localDomain;
                log.info((Object)("Unknown local assigning authority changed to " + issuer));
            }
        } else if (issuer == null) {
            issuer = "";
        }
        String pid = this.toPIDString(StringUtils.split(patID + "&" + issuer, '&'));
        log.debug((Object)("Source PatientID:" + pid));
        return pid;
    }

    protected boolean isFromDomain(String pid) {
        String assAuth = this.getAssigningAuthority(pid);
        if (assAuth == null || assAuth.indexOf(38) == -1) {
            return false;
        }
        if (assAuth.charAt(0) != '&') {
            assAuth = assAuth.substring(assAuth.indexOf(38));
        }
        if (this.affinityDomain.charAt(0) == '&') {
            return assAuth.equals(this.affinityDomain);
        }
        return assAuth.equals(this.affinityDomain.substring(this.affinityDomain.indexOf(38)));
    }

    private String getAssigningAuthority(String pid) {
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            if ((pos = pid.indexOf(94, pos)) == -1) {
                log.warn((Object)("patient id does not contain AssigningAuthority component! :" + pid));
                return null;
            }
            ++pos;
        }
        int end = pid.indexOf(94, pos);
        return end == -1 ? pid.substring(pos) : pid.substring(pos, end);
    }

    private String toPIDString(String[] pid) {
        if (pid == null || pid.length < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(pid[0]);
        log.debug((Object)("pid[0]:" + pid[0]));
        if (pid.length > 1) {
            sb.append("^^^");
            if (this.removeNamespaceID) {
                log.info((Object)("Remove Namespace ID '" + pid[1] + "'!"));
            } else {
                sb.append(pid[1]);
                log.debug((Object)("pid[1]:" + pid[1]));
            }
            for (int i = 2; i < pid.length; ++i) {
                sb.append('&').append(pid[i]);
                log.debug((Object)("pid[" + i + "]:" + pid[i]));
            }
        }
        return sb.toString();
    }

    private boolean checkResponse(Node n) throws SOAPException {
        log.info((Object)("checkResponse node:" + n.getLocalName() + " in NS:" + n.getNamespaceURI()));
        String status = n.getAttributes().getNamedItem("status").getNodeValue();
        log.info((Object)("XDSI: SOAP response status." + status));
        if ("Success".equals(status)) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        try {
            NodeList errList = n.getChildNodes().item(0).getChildNodes();
            int lenj = errList.getLength();
            for (int j = 0; j < lenj; ++j) {
                sb.setLength(0);
                sb.append("Error (").append(j).append("):");
                Node errNode = errList.item(j);
                if (errNode != null && errNode.getFirstChild() != null) {
                    sb.append(errNode.getFirstChild().getNodeValue());
                }
                log.info((Object)sb.toString());
            }
        }
        catch (Exception ignoreMissingErrorList) {
            // empty catch block
        }
        return false;
    }

    private boolean checkResponse(SOAPMessage response) throws SOAPException {
        log.info((Object)("checkResponse:" + response));
        try {
            SOAPBody body = response.getSOAPBody();
            log.debug((Object)("SOAPBody:" + body));
            NodeList nl = body.getChildNodes();
            if (nl.getLength() > 0) {
                int len = nl.getLength();
                for (int i = 0; i < len; ++i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1 || !"RegistryResponse".equals(n.getLocalName())) continue;
                    return this.checkResponse(n);
                }
            } else {
                log.warn((Object)"XDSI: Empty SOAP response!");
            }
        }
        catch (Exception x) {
            log.error((Object)"Cant check response!", (Throwable)x);
        }
        return false;
    }

    private void dumpSOAPMessage(SOAPMessage message) throws SOAPException, IOException, ParserConfigurationException, SAXException {
        if (!this.logSOAPMessage) {
            return;
        }
        Source s = message.getSOAPPart().getContent();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("SOAP message:".getBytes());
            Transformer t = TransformerFactory.newInstance().newTransformer();
            if (this.indentSOAPLog) {
                t.setOutputProperty("indent", "yes");
            }
            t.transform(s, new StreamResult(out));
            log.info((Object)out.toString());
        }
        catch (Exception e) {
            log.warn((Object)"Failed to log SOAP message", (Throwable)e);
        }
    }

    private Document readXMLFile(File xmlFile) {
        Document document = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            document = builder.parse(xmlFile);
        }
        catch (Exception x) {
            log.error((Object)("Cant read xml file:" + xmlFile), (Throwable)x);
        }
        return document;
    }

    protected void startService() throws Exception {
        this.server.addNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    private void onIAN(Dataset mpps) {
        block4: {
            try {
                log.debug((Object)"Received mpps");
                log.debug((Object)mpps);
                String aet = mpps.getString(4194881);
                List<String> autoPublish = Arrays.asList(this.autoPublishAETs);
                if (autoPublish.indexOf(aet) == -1) break block4;
                List iuids = this.getIUIDS(mpps);
                log.debug((Object)("iuids:" + iuids));
                Dataset manifest = this.getKeyObject(iuids, this.getAutoPublishRootInfo(mpps), null);
                log.debug((Object)"Created manifest KOS:");
                log.debug((Object)manifest);
                try {
                    this.sendSOAP(manifest, this.getAutoPublishMetadataProperties(mpps));
                }
                catch (SQLException x) {
                    log.error((Object)"XDS-I Autopublish failed! Reason:", (Throwable)x);
                }
                return;
            }
            catch (Exception e) {
                log.error((Object)("Error in onIAN:" + e));
                log.debug((Object)"Exception:", (Throwable)e);
            }
        }
    }

    private List getIUIDS(Dataset mpps) {
        ArrayList<String> l = new ArrayList<String>();
        DcmElement refSerSQ = mpps.get(0x400340);
        if (refSerSQ != null) {
            int len = refSerSQ.countItems();
            for (int i = 0; i < len; ++i) {
                DcmElement refSopSQ = refSerSQ.getItem(i).get(528704);
                int len1 = refSopSQ.countItems();
                for (int j = 0; j < len1; ++j) {
                    Dataset item = refSopSQ.getItem(j);
                    log.debug((Object)("refSerItem:" + i + " refSopItem:" + j + " item:" + item));
                    l.add(item.getString(528725));
                }
            }
        }
        return l;
    }

    private Dataset getAutoPublishRootInfo(Dataset mpps) {
        Dataset rootInfo = DcmObjectFactory.getInstance().newDataset();
        DcmElement sq = rootInfo.putSQ(4235331);
        Dataset item = sq.addNewItem();
        StringTokenizer st = new StringTokenizer(this.autoPublishDocTitle, "^");
        item.putSH(524544, st.hasMoreTokens() ? st.nextToken() : "autoPublish");
        item.putLO(524548, st.hasMoreTokens() ? st.nextToken() : "default doctitle for autopublish");
        item.putSH(524546, st.hasMoreTokens() ? st.nextToken() : null);
        return rootInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getAutoPublishMetadataProperties(Dataset mpps) {
        BufferedInputStream bis;
        Properties props;
        block11: {
            block10: {
                props = new Properties();
                bis = null;
                if (this.autoPublishPropertyFile != null) break block10;
                Properties properties = props;
                Object var6_7 = null;
                if (bis == null) return properties;
                try {
                    bis.close();
                    return properties;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                return properties;
            }
            File propFile = FileUtils.resolve(this.autoPublishPropertyFile);
            bis = new BufferedInputStream(new FileInputStream(propFile));
            props.load(bis);
            if (this.sourceID == null) break block11;
            props.setProperty(SOURCE_ID, this.sourceID);
        }
        Object var6_8 = null;
        if (bis == null) return props;
        try {
            bis.close();
            return props;
        }
        catch (IOException ignore) {}
        return props;
        {
            catch (IOException x) {
                log.error((Object)"Cant read Metadata Properties for AutoPublish!", (Throwable)x);
                Object var6_9 = null;
                if (bis == null) return props;
                try {
                    bis.close();
                    return props;
                }
                catch (IOException ignore) {}
                return props;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (bis == null) throw throwable;
            try {
                bis.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private Dataset getKeyObject(Collection iuids, Dataset rootInfo, List contentItems) {
        Object o = null;
        try {
            o = this.server.invoke(this.keyObjectServiceName, "getKeyObject", new Object[]{iuids, rootInfo, contentItems}, new String[]{Collection.class.getName(), Dataset.class.getName(), Collection.class.getName()});
        }
        catch (RuntimeMBeanException x) {
            log.warn((Object)("RuntimeException thrown in KeyObject Service:" + x.getCause()));
            throw new IllegalArgumentException(x.getCause().getMessage());
        }
        catch (Exception e) {
            log.warn((Object)"Failed to create Key Object:", (Throwable)e);
            throw new IllegalArgumentException("Error: KeyObject Service cant create manifest Key Object! Reason:" + e.getClass().getName());
        }
        return (Dataset)o;
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }
}

