/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.xdsi;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.xdsi.XDSIDocument;

public class XDSIFileDocument
extends XDSIDocument {
    private String uid;
    private File docFile;

    public XDSIFileDocument(File docFile, String mimeType, String docID, String uid) {
        super(docID, mimeType);
        this.docFile = docFile;
        this.uid = uid;
    }

    public File getDocFile() {
        return this.docFile;
    }

    public DataHandler getDataHandler() {
        return new DataHandler((DataSource)new FileDataSource(this.getDocFile()));
    }

    public String getUniqueID() {
        return this.uid;
    }

    public String toString() {
        return this.docFile + "|" + this.getMimeType() + "|" + this.getDocumentID();
    }

    public static XDSIFileDocument valueOf(String s) {
        int pos2;
        int pos1 = s.indexOf(124);
        if (pos1 == -1 || (pos2 = s.indexOf(124, pos1 + 1)) == -1) {
            throw new IllegalArgumentException("XDSIFileDocument String must be <filename>|<mimeType>|<docID>");
        }
        return new XDSIFileDocument(new File(s.substring(0, pos1)), s.substring(pos1 + 1, pos2), s.substring(pos2 + 1), UIDGenerator.getInstance().createUID());
    }
}

