/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.xdsi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.xdsi.XDSIDocument;

public class XDSIDatasetDocument
extends XDSIDocument {
    private Dataset ds;
    private DataHandler dh;

    public XDSIDatasetDocument(Dataset ds, String mimeType, String docID) {
        super(docID, mimeType);
        this.ds = ds;
        this.dh = new DatasetDataHandler(ds);
    }

    public Dataset getDataset() {
        return this.ds;
    }

    public DataHandler getDataHandler() {
        return this.dh;
    }

    public String getUniqueID() {
        return this.ds.getString(524312);
    }

    public String toString() {
        return this.ds + "|" + this.getMimeType() + "|" + this.getDocumentID();
    }

    public class DatasetDataHandler
    extends DataHandler {
        public DatasetDataHandler(Dataset ds) {
            super((Object)ds, "application/dicom");
        }

        public void writeTo(OutputStream out) throws IOException {
            if (XDSIDatasetDocument.this.ds.getFileMetaInfo() == null) {
                XDSIDatasetDocument.this.ds.setFileMetaInfo(DcmObjectFactory.getInstance().newFileMetaInfo(XDSIDatasetDocument.this.ds, "1.2.840.10008.1.2.1"));
            }
            XDSIDatasetDocument.this.ds.writeFile(out, null);
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.writeTo(bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
    }
}

