/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che.data.Dataset;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.net.Association;
import org.dcm4che.util.DAFormat;
import org.dcm4che.util.TMFormat;

public class XSLTUtils {
    public static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();

    public static void xslt(Dataset ds, Templates tpl, Association a, Dataset out) throws TransformerConfigurationException, IOException {
        XSLTUtils.xslt(ds, XSLTUtils.getTransformerHandler(tpl, a), out);
    }

    public static TransformerHandler getTransformerHandler(Templates tpl, Association a) throws TransformerConfigurationException {
        TransformerHandler th = transformerFactory.newTransformerHandler(tpl);
        XSLTUtils.setDateParameters(th);
        if (a != null) {
            XSLTUtils.setAETParameters(th, a);
        }
        return th;
    }

    public static void xslt(Dataset ds, TransformerHandler th, Dataset out) throws IOException {
        th.setResult(new SAXResult(out.getSAXHandler2(null)));
        ds.writeDataset2(th, null, null, 64, null);
    }

    public static void xslt(Dataset ds, Templates tpl, Dataset out) throws TransformerConfigurationException, IOException {
        XSLTUtils.xslt(ds, tpl, null, out);
    }

    public static void setDateParameters(TransformerHandler th) {
        Date now = new Date();
        Transformer t = th.getTransformer();
        t.setParameter("date", new DAFormat().format(now));
        t.setParameter("time", new TMFormat().format(now));
    }

    public static void setAETParameters(TransformerHandler th, Association a) {
        Date now = new Date();
        Transformer t = th.getTransformer();
        t.setParameter("calling", a.getCallingAET());
        t.setParameter("called", a.getCalledAET());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(Dataset ds, File f) throws TransformerConfigurationException, IOException {
        TransformerHandler th = transformerFactory.newTransformerHandler();
        th.getTransformer().setOutputProperty("indent", "yes");
        FileOutputStream out = new FileOutputStream(f);
        TagDictionary dict = DictionaryFactory.getInstance().getDefaultTagDictionary();
        try {
            th.setResult(new StreamResult(out));
            ds.writeDataset2(th, dict, null, 64, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

