/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4chex.archive.ejb.interfaces.MD5;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;

public class FileUtils {
    protected static final Logger log = Logger.getLogger(FileUtils.class);
    private static final int BUFFER_SIZE = 512;
    public static final long MEGA = 1000000L;
    public static final long GIGA = 1000000000L;
    public static final long MAX_TIMES_CREATE_FILE = 10L;
    public static final long INTERVAL_CREATE_FILE = 250L;
    private static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toHex(int val) {
        char[] ch8 = new char[8];
        int i = 8;
        while (--i >= 0) {
            ch8[i] = HEX_DIGIT[val & 0xF];
            val >>= 4;
        }
        return String.valueOf(ch8);
    }

    public static File createNewFile(File dir, int hash) throws Exception {
        File f = null;
        boolean success = false;
        Exception lastException = null;
        int i = 0;
        while ((long)i < 10L && !success) {
            try {
                if (!dir.exists() && !(success = dir.mkdirs())) {
                    throw new IOException("Directory creation failed: " + dir.getCanonicalPath());
                }
                f = new File(dir, FileUtils.toHex(hash++));
                success = f.createNewFile();
                if (i > 0) {
                    log.info((Object)("file: " + dir.getCanonicalPath() + " created successfully after retries: " + i));
                }
                if (success) {
                    return f;
                }
                --i;
            }
            catch (Exception e) {
                if (lastException == null) {
                    log.warn((Object)("failed to create file: " + dir.getCanonicalPath() + " - retry: " + (i + 1) + " of " + 10L + ". Will retry again."), (Throwable)e);
                } else {
                    log.warn((Object)("failed to create file: " + dir.getCanonicalPath() + " - got the same exception as above - retry: " + (i + 1) + " of " + 10L + ". Will retry again"));
                }
                lastException = e;
                success = false;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw lastException;
    }

    public static String slashify(File f) {
        return f.getPath().replace(File.separatorChar, '/');
    }

    public static File resolve(File f) {
        if (f.isAbsolute()) {
            return f;
        }
        File serverHomeDir = new File(System.getProperty("jboss.server.home.dir"));
        return new File(serverHomeDir, f.getPath());
    }

    public static File toFile(String unixPath) {
        return FileUtils.resolve(new File(unixPath.replace('/', File.separatorChar)));
    }

    public static File toExistingFile(String unixPath) throws FileNotFoundException {
        File f = FileUtils.toFile(unixPath);
        if (!f.isFile()) {
            throw new FileNotFoundException(f.toString());
        }
        return f;
    }

    public static File toFile(String unixDirPath, String unixFilePath) {
        return FileUtils.resolve(new File(unixDirPath.replace('/', File.separatorChar), unixFilePath.replace('/', File.separatorChar)));
    }

    public static String formatSize(long size) {
        return size == -1L ? "UNKNOWN" : (size < 1000000000L ? (float)size / 1000000.0f + "MB" : (float)size / 1.0E9f + "GB");
    }

    public static long parseSize(String s, long minSize) {
        long u;
        if (s.endsWith("GB")) {
            u = 1000000000L;
        } else if (s.endsWith("MB")) {
            u = 1000000L;
        } else {
            throw new IllegalArgumentException(s);
        }
        try {
            long size = (long)(Float.parseFloat(s.substring(0, s.length() - 2)) * (float)u);
            if (size >= minSize) {
                return size;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        throw new IllegalArgumentException(s);
    }

    /*
     * Exception decompiling
     */
    public static boolean equalsPixelData(File f1, File f2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static int maxDiffPixelData(File f1, File f2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean delete(File file, boolean deleteEmptyParents) {
        return FileUtils.delete(file, deleteEmptyParents, null);
    }

    public static boolean delete(File file, boolean deleteEmptyParents, String parentFolderToKeep) {
        log.info((Object)("M-DELETE file: " + file));
        if (!file.exists()) {
            log.warn((Object)("File: " + file + " was already deleted"));
            return true;
        }
        if (!file.delete()) {
            log.warn((Object)("Failed to delete file: " + file));
            return false;
        }
        if (deleteEmptyParents) {
            File parentToKeep = null;
            if (parentFolderToKeep != null) {
                parentToKeep = FileUtils.toFile(parentFolderToKeep);
            }
            File parent = file.getParentFile();
            while (!parent.equals(parentToKeep) && parent.delete()) {
                log.info((Object)("M-DELETE directory: " + parent));
                parent = parent.getParentFile();
            }
        }
        return true;
    }

    public static void verifyMD5(FileInfo info) throws Exception {
        if (info.md5 == null || info.basedir == null || info.availability != 0 || info.basedir.startsWith("ftp://")) {
            return;
        }
        File file = FileUtils.toFile(info.basedir, info.fileID);
        FileUtils.verifyMD5(file, info.md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyMD5(File file, String originalMd5) throws Exception {
        log.info((Object)("M-READ file:" + file));
        MessageDigest md = MessageDigest.getInstance("MD5");
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        DigestInputStream dis = new DigestInputStream(in, md);
        try {
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser(dis);
            parser.parseDcmFile(FileFormat.DICOM_FILE, 2145386512);
            if (((long)parser.getReadTag() & 0xFFFFFFFFL) >= 2145386512L) {
                if (parser.getReadLength() == -1) {
                    while (parser.parseHeader() == -73728) {
                        FileUtils.readOut(parser.getInputStream(), parser.getReadLength());
                    }
                }
                FileUtils.readOut(parser.getInputStream(), parser.getReadLength());
                parser.parseDataset(parser.getDcmDecodeParam(), -1);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                dis.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            dis.close();
        }
        catch (IOException ignore) {}
        byte[] md5 = md.digest();
        if (!Arrays.equals(md5, MD5.toBytes(originalMd5))) {
            log.error((Object)("MD5 for " + file.getAbsolutePath() + " is different that expected.  Has the file been changed or corrupted?"));
            throw new IllegalStateException("MD5 mismatch");
        }
    }

    protected static void readOut(InputStream in, int len) throws IOException {
        int toRead = len;
        while (toRead-- > 0) {
            if (in.read() >= 0) continue;
            throw new EOFException();
        }
    }
}

