/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dcm4che.util.Executer;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static String dfCommand = "df";
    private static String dfCommandOption = "-P";
    private static final int OS;
    private static Method jdk6getUsableSpace;
    private static Method jdk6getTotalSpace;

    public static final String getDFCommand() {
        return dfCommand;
    }

    public static final void setDFCommand(String dfCommand) {
        FileSystemUtils.dfCommand = dfCommand;
    }

    public static final String getDFCommandOption() {
        return dfCommandOption;
    }

    public static final void setDFCommandOption(String dfCommandOption) {
        FileSystemUtils.dfCommandOption = dfCommandOption;
    }

    public static long freeSpace(String path) throws IOException {
        if (jdk6getUsableSpace != null) {
            try {
                Long l = (Long)jdk6getUsableSpace.invoke((Object)new File(path), (Object[])null);
                long space = l;
                if (space != 0L) {
                    return space;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return INSTANCE.freeSpaceOS(path, OS);
    }

    public static long totalSpace(String path) {
        if (jdk6getTotalSpace == null) {
            throw new RuntimeException("Get total space of partition not supportet prior JDK6!");
        }
        try {
            Long l = (Long)jdk6getTotalSpace.invoke((Object)new File(path), (Object[])null);
            if (l != 0L) {
                return l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Failed to get total space of " + path);
    }

    long freeSpaceOS(String path, int os) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return this.freeSpaceWindows(path);
            }
            case 2: {
                return this.freeSpaceUnix(path);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    long freeSpaceWindows(String path) throws IOException {
        char c;
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "dir /c \"" + path + "\""};
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        try {
            new Executer(cmdAttrbs, (OutputStream)stdout, null).waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(stdout.toByteArray())));
        ArrayList<String> lines = new ArrayList<String>();
        String line = in.readLine();
        while (line != null) {
            line = line.toLowerCase().trim();
            lines.add(line);
            line = in.readLine();
        }
        if (lines.size() == 0) {
            throw new IOException("Command line 'dir /c' did not return any info for command '" + cmdAttrbs[2] + "'");
        }
        long bytes = -1L;
        int i = lines.size() - 1;
        int bytesStart = 0;
        int bytesEnd = 0;
        while (i > 0) {
            int j;
            if ((line = (String)lines.get(i--)).length() <= 0) continue;
            for (j = line.length() - 1; j >= 0; --j) {
                c = line.charAt(j);
                if (!Character.isDigit(c)) continue;
                bytesEnd = j + 1;
                break;
            }
            while (j >= 0 && (Character.isDigit(c = line.charAt(j)) || j != 0 && Character.isDigit(line.charAt(j - 1)))) {
                --j;
            }
            bytesStart = j;
            break;
        }
        StringBuffer buf = new StringBuffer(line.substring(bytesStart, bytesEnd));
        for (int k = 0; k < buf.length(); ++k) {
            c = buf.charAt(k);
            if (Character.isDigit(c)) continue;
            buf.deleteCharAt(k--);
        }
        bytes = Long.parseLong(buf.toString());
        return bytes;
    }

    long freeSpaceUnix(String path) throws IOException {
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        String[] cmdAttribs = new String[]{dfCommand, dfCommandOption, path};
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        try {
            new Executer(cmdAttribs, (OutputStream)stdout, null).waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(stdout.toByteArray())));
        String line1 = in.readLine();
        String line2 = in.readLine();
        String line3 = in.readLine();
        return this.parseUnixDF(path, line1, line2, line3);
    }

    public static long parseDF(String path, String line1, String line2, String line3) throws IOException {
        return INSTANCE.parseUnixDF(path, line1, line2, line3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long parseUnixDF(String path, String line1, String line2, String line3) throws IOException {
        StringTokenizer tok;
        if (line2 == null) {
            throw new IOException("'" + dfCommand + " " + dfCommandOption + "' did not return info as expected " + "for path '" + path + "'- response on first line was '" + line1 + "'");
        }
        long blocksize = 512L;
        int blocksizeEnd = line1.indexOf(45);
        if (blocksizeEnd > 0) {
            int blocksizePos;
            int factor = 1;
            if (line1.charAt(blocksizeEnd - 1) == 'K') {
                --blocksizeEnd;
                factor = 1024;
            }
            for (blocksizePos = blocksizeEnd; blocksizePos > 0 && Character.isDigit(line1.charAt(blocksizePos - 1)); --blocksizePos) {
            }
            if (blocksizePos < blocksizeEnd) {
                blocksize = (long)factor * Long.parseLong(line1.substring(blocksizePos, blocksizeEnd));
            }
        }
        if ((tok = new StringTokenizer(line2 = line2.trim(), " ")).countTokens() < 4) {
            if (tok.countTokens() != 1 || line3 == null) throw new IOException("'" + dfCommand + " " + dfCommandOption + "' did not return data as expected for path '" + path + "'- check path is valid");
            line3 = line3.trim();
            tok = new StringTokenizer(line3, " ");
        } else {
            tok.nextToken();
        }
        tok.nextToken();
        tok.nextToken();
        String freeSpace = tok.nextToken();
        try {
            return Long.parseLong(freeSpace) * blocksize;
        }
        catch (NumberFormatException ex) {
            throw new IOException("'" + dfCommand + " " + dfCommandOption + "' did not return numeric data as expected for path '" + path + "'- check path is valid");
        }
    }

    static {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            os = (osName = osName.toLowerCase()).indexOf("windows") != -1 ? 1 : (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1 ? 2 : 0);
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
        try {
            jdk6getUsableSpace = File.class.getMethod("getUsableSpace", null);
            jdk6getTotalSpace = File.class.getMethod("getTotalSpace", null);
        }
        catch (Exception e) {
            jdk6getUsableSpace = null;
        }
    }
}

