/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.management.JMException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.net.DataSource;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.codec.DecompressCmd;
import org.dcm4chex.archive.util.DatasetUpdater;
import org.dcm4chex.archive.util.RequestedFrameNumbersOutOfRangeException;
import org.jboss.logging.Logger;

public class FileDataSource
implements DataSource {
    private static final Logger log = Logger.getLogger(FileDataSource.class);
    private static final int SOI = 65496;
    private static final int SOF55 = 65527;
    private static final int LSE = 65528;
    private static final int SOS = 65498;
    private static final byte[] LSE_13 = new byte[]{-1, -8, 0, 13, 1, 31, -1, 0, 34, 0, -125, 2, 36, 0, 64, -1, -38};
    private static final byte[] LSE_14 = new byte[]{-1, -8, 0, 13, 1, 63, -1, 0, 66, 1, 3, 4, 68, 0, 64, -1, -38};
    private static final byte[] LSE_15 = new byte[]{-1, -8, 0, 13, 1, 127, -1, 0, -126, 2, 3, 8, -124, 0, 64, -1, -38};
    private static final byte[] LSE_16 = new byte[]{-1, -8, 0, 13, 1, -1, -1, 1, 2, 4, 3, 17, 4, 0, 64, -1, -38};
    private static Dataset defaultContributingEquipment = DcmObjectFactory.getInstance().newDataset();
    private final File file;
    private final Dataset mergeAttrs;
    private final byte[] buffer;
    private boolean writeFile = false;
    private boolean withoutPixeldata = false;
    private boolean excludePrivate = false;
    private int[] simpleFrameList;
    private int[] calculatedFrameList;
    private Dataset contributingEquipment = defaultContributingEquipment;
    private boolean patchJpegLS = true;
    private String patchJpegLSImplCUID = "1.2.40.0.13.1.1";
    private String patchJpegLSNewImplCUID = "1.2.40.0.13.1.1.1";
    private DatasetUpdater datasetUpdater;

    public FileDataSource(File file, Dataset mergeAttrs, byte[] buffer) {
        this.file = file;
        this.mergeAttrs = mergeAttrs;
        this.buffer = buffer;
    }

    public FileDataSource(File file, Dataset mergeAttrs, byte[] buffer, DatasetUpdater datasetUpdater) {
        this(file, mergeAttrs, buffer);
        this.datasetUpdater = datasetUpdater;
    }

    public static final Dataset getDefaultContributingEquipment() {
        return defaultContributingEquipment;
    }

    public static final void setDefaultContributingEquipment(Dataset contributingEquipment) {
        defaultContributingEquipment = contributingEquipment;
    }

    public final boolean isWriteFile() {
        return this.writeFile;
    }

    public final void setWriteFile(boolean writeFile) {
        this.writeFile = writeFile;
    }

    public final boolean isWithoutPixeldata() {
        return this.withoutPixeldata;
    }

    public final void setWithoutPixeldata(boolean withoutPixelData) {
        this.withoutPixeldata = withoutPixelData;
    }

    public final boolean isExcludePrivate() {
        return this.excludePrivate;
    }

    public final void setExcludePrivate(boolean excludePrivate) {
        this.excludePrivate = excludePrivate;
    }

    public final void setSimpleFrameList(int[] simpleFrameList) {
        if (simpleFrameList != null) {
            if (this.calculatedFrameList != null) {
                throw new IllegalStateException();
            }
            if (simpleFrameList.length == 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < simpleFrameList.length; ++i) {
                if (simpleFrameList[i] <= 0) {
                    throw new IllegalArgumentException();
                }
                if (i == 0 || simpleFrameList[i] > simpleFrameList[i - 1]) continue;
                throw new IllegalArgumentException();
            }
        }
        this.simpleFrameList = simpleFrameList;
    }

    public final void setCalculatedFrameList(int[] calculatedFrameList) {
        if (calculatedFrameList != null) {
            if (this.simpleFrameList != null) {
                throw new IllegalStateException();
            }
            if (calculatedFrameList.length == 0) {
                throw new IllegalArgumentException();
            }
            if (calculatedFrameList.length % 3 != 0) {
                throw new IllegalArgumentException();
            }
            block4: for (int i = 0; i < calculatedFrameList.length; ++i) {
                if (calculatedFrameList[i] <= 0) {
                    throw new IllegalArgumentException();
                }
                switch (i % 3) {
                    case 0: {
                        if (i == 0 || calculatedFrameList[i] > calculatedFrameList[i - 2]) continue block4;
                        throw new IllegalArgumentException();
                    }
                    case 1: {
                        if (i == 0 || calculatedFrameList[i] >= calculatedFrameList[i - 1]) continue block4;
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        this.calculatedFrameList = calculatedFrameList;
    }

    public final void setContributingEquipment(Dataset contributingEquipment) {
        this.contributingEquipment = contributingEquipment;
    }

    public final boolean isPatchJpegLS() {
        return this.patchJpegLS;
    }

    public final void setPatchJpegLS(boolean patchJpegLS) {
        this.patchJpegLS = patchJpegLS;
    }

    public final String getPatchJpegLSImplCUID() {
        return this.patchJpegLSImplCUID;
    }

    public final void setPatchJpegLSImplCUID(String patchJpegLSImplCUID) {
        this.patchJpegLSImplCUID = patchJpegLSImplCUID;
    }

    public final String getPatchJpegLSNewImplCUID() {
        return this.patchJpegLSNewImplCUID;
    }

    public final void setPatchJpegLSNewImplCUID(String patchJpegLSNewImplCUID) {
        this.patchJpegLSNewImplCUID = patchJpegLSNewImplCUID;
    }

    public final File getFile() {
        return this.file;
    }

    public final Dataset getMergeAttrs() {
        return this.mergeAttrs;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream out, String tsUID) throws IOException {
        block71: {
            block62: {
                block70: {
                    block60: {
                        block69: {
                            block59: {
                                FileDataSource.log.info((Object)("M-READ file:" + this.file));
                                withoutPixeldata1 = this.withoutPixeldata != false || "1.2.840.10008.1.2.4.96".equals(tsUID) != false || "1.2.840.10008.1.2.4.97".equals(tsUID) != false;
                                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                                fiis = null;
                                try {
                                    try {
                                        block64: {
                                            block65: {
                                                block67: {
                                                    block66: {
                                                        block63: {
                                                            ds = DcmObjectFactory.getInstance().newDataset();
                                                            parser = DcmParserFactory.getInstance().newDcmParser(dis);
                                                            parser.setDcmHandler(ds.getDcmHandler());
                                                            parser.parseDcmFile(null, 2145386512);
                                                            hasPixelData = parser.getReadTag() == 2145386512;
                                                            dcmDecodeParam = parser.getDcmDecodeParam();
                                                            if (!hasPixelData && !parser.hasSeenEOF()) {
                                                                parser.unreadHeader();
                                                                parser.parseDataset(dcmDecodeParam, -1);
                                                            }
                                                            ds.putAll(this.mergeAttrs);
                                                            if (this.datasetUpdater != null) {
                                                                ds = this.datasetUpdater.updateDataset(ds);
                                                            }
                                                            if ((fmi = ds.getFileMetaInfo()) == null) {
                                                                fmi = DcmObjectFactory.getInstance().newFileMetaInfo(ds, "1.2.840.10008.1.2");
                                                                ds.setFileMetaInfo(fmi);
                                                            }
                                                            tsOrig = fmi.getTransferSyntaxUID();
                                                            if (tsUID == null) {
                                                                tsUID = tsOrig;
                                                            }
                                                            v0 = patchJpegLS = this.patchJpegLS != false && withoutPixeldata1 == false && tsUID.equals("1.2.840.10008.1.2.4.80") != false && (this.patchJpegLSImplCUID == null || this.patchJpegLSImplCUID.equals(fmi.getImplementationClassUID()) != false) && ds.getInt(2621696, 0) == 16;
                                                            if (this.writeFile) {
                                                                if (!(withoutPixeldata1 || tsUID.equals(tsOrig) || tsUID.equals("1.2.840.10008.1.2"))) {
                                                                    tsUID = "1.2.840.10008.1.2.1";
                                                                    patchJpegLS = false;
                                                                }
                                                                fmi.putUI(131088, tsUID);
                                                                if (patchJpegLS && this.patchJpegLSNewImplCUID != null) {
                                                                    fmi.putUI(131090, this.patchJpegLSNewImplCUID);
                                                                }
                                                            }
                                                            FileDataSource.log.debug((Object)("using transfersyntx:" + tsUID));
                                                            enc = DcmEncodeParam.valueOf(tsUID);
                                                            if (!hasPixelData) {
                                                                FileDataSource.log.debug((Object)"Dataset:\n");
                                                                FileDataSource.log.debug((Object)ds);
                                                                this.write(ds, out, enc);
                                                                var22_15 = null;
                                                                break block59;
                                                            }
                                                            pixelDataLen = parser.getReadLength();
                                                            encapsulated = pixelDataLen == -1;
                                                            framesInFile = ds.getInt(0x280008, 1);
                                                            if (this.simpleFrameList != null) {
                                                                if (this.simpleFrameList[this.simpleFrameList.length - 1] > framesInFile) {
                                                                    throw new RequestedFrameNumbersOutOfRangeException();
                                                                }
                                                            } else if (this.calculatedFrameList != null) {
                                                                if (this.calculatedFrameList[0] > framesInFile) {
                                                                    throw new RequestedFrameNumbersOutOfRangeException();
                                                                }
                                                                this.simpleFrameList = this.calculateFrameList(framesInFile);
                                                            }
                                                            if (framesInFile == 1) {
                                                                this.simpleFrameList = null;
                                                            }
                                                            if (this.simpleFrameList != null) {
                                                                this.addFrameExtractionSeq(ds);
                                                                this.addContributingEquipmentSeq(ds);
                                                                this.adjustNumberOfFrames(ds);
                                                                ds.putUI(524312, UIDGenerator.getInstance().createUID());
                                                            }
                                                            if (withoutPixeldata1) {
                                                                if (!encapsulated) {
                                                                    dis.skipBytes(pixelDataLen);
                                                                } else {
                                                                    do {
                                                                        parser.parseHeader();
                                                                        dis.skipBytes(parser.getReadLength());
                                                                    } while (parser.getReadTag() == -73728);
                                                                }
                                                                parser.parseDataset(dcmDecodeParam, -1);
                                                                FileDataSource.log.debug((Object)"Dataset:\n");
                                                                FileDataSource.log.debug((Object)ds);
                                                                this.write(ds, out, enc);
                                                                break block60;
                                                            }
                                                            if (encapsulated && !enc.encapsulated) {
                                                                DecompressCmd.adjustPhotometricInterpretation(ds, tsOrig);
                                                            }
                                                            FileDataSource.log.debug((Object)"Dataset:\n");
                                                            FileDataSource.log.debug((Object)ds);
                                                            this.write(ds, out, enc);
                                                            if (encapsulated) break block63;
                                                            if (this.simpleFrameList == null) {
                                                                ds.writeHeader(out, enc, 2145386512, 20311, pixelDataLen);
                                                                this.copyBytes(dis, out, pixelDataLen, this.buffer);
                                                                break block64;
                                                            } else {
                                                                frameLength = pixelDataLen / framesInFile;
                                                                newPixelDataLength = frameLength * this.simpleFrameList.length;
                                                                ds.writeHeader(out, enc, 2145386512, 20311, newPixelDataLength + 1 & -2);
                                                                frameIndex = 0;
                                                                for (i = 0; i < this.simpleFrameList.length; ++i) {
                                                                    while (++frameIndex < this.simpleFrameList[i]) {
                                                                        dis.skipBytes(frameLength);
                                                                    }
                                                                    this.copyBytes(dis, out, frameLength, this.buffer);
                                                                }
                                                                if ((newPixelDataLength & 1) != 0) {
                                                                    out.write(0);
                                                                }
                                                                var22_17 = null;
                                                                try {
                                                                    if (dis != null) {
                                                                        dis.close();
                                                                    }
                                                                }
                                                                catch (IOException ignore) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    if (fiis == null) return;
                                                                    fiis.close();
                                                                    return;
                                                                }
                                                                catch (IOException ignore) {
                                                                    // empty catch block
                                                                }
                                                                return;
                                                            }
                                                        }
                                                        if (!enc.encapsulated) break block65;
                                                        ds.writeHeader(out, enc, 2145386512, 20290, -1);
                                                        parser.parseHeader();
                                                        itemlen = parser.getReadLength();
                                                        if (this.simpleFrameList == null && !patchJpegLS) {
                                                            ds.writeHeader(out, enc, parser.getReadTag(), 0, itemlen);
                                                            this.copyBytes(dis, out, itemlen, this.buffer);
                                                        } else {
                                                            ds.writeHeader(out, enc, -73728, 0, 0);
                                                            dis.skipBytes(itemlen);
                                                        }
                                                        if (this.simpleFrameList != null) break block66;
                                                        parser.parseHeader();
                                                        while (parser.getReadTag() == -73728) {
                                                            itemlen = parser.getReadLength();
                                                            this.copyItem(patchJpegLS, dis, ds, out, enc, itemlen);
                                                            parser.parseHeader();
                                                        }
                                                        ds.writeHeader(out, enc, -73507, 0, 0);
                                                        dis.skipBytes(itemlen);
                                                        break block64;
                                                    }
                                                    frameIndex = 0;
                                                    for (i = 0; i < this.simpleFrameList.length; ++i) {
                                                        parser.parseHeader();
                                                        itemlen = parser.getReadLength();
                                                        while (++frameIndex < this.simpleFrameList[i]) {
                                                            dis.skipBytes(itemlen);
                                                            parser.parseHeader();
                                                            itemlen = parser.getReadLength();
                                                        }
                                                        this.copyItem(patchJpegLS, dis, ds, out, enc, itemlen);
                                                    }
                                                    ds.writeHeader(out, enc, -73507, 0, 0);
                                                    var22_18 = null;
                                                    ** try [egrp 3[TRYBLOCK] [13 : 1462->1475)] { 
lbl168:
                                                    // 1 sources

                                                    if (dis != null) {
                                                        dis.close();
                                                    }
                                                    break block67;
lbl171:
                                                    // 1 sources

                                                    catch (IOException ignore) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 4[TRYBLOCK] [14 : 1477->1490)] { 
lbl175:
                                                // 1 sources

                                                if (fiis == null) return;
                                                fiis.close();
                                                return;
lbl178:
                                                // 1 sources

                                                catch (IOException ignore) {
                                                    // empty catch block
                                                }
                                                return;
                                            }
                                            dis.close();
                                            dis = null;
                                            fiis = new FileImageInputStream(this.file);
                                            fiis.seek(parser.getStreamPosition());
                                            parser = DcmParserFactory.getInstance().newDcmParser(fiis);
                                            parser.setDcmHandler(ds.getDcmHandler());
                                            cmd = new DecompressCmd(ds, tsOrig, parser);
                                            cmd.setSimpleFrameList(this.simpleFrameList);
                                            newPixelDataLen = cmd.getPixelDataLength();
                                            ds.writeHeader(out, enc, 2145386512, 20311, newPixelDataLen + 1 & -2);
                                            try {
                                                cmd.decompress(enc.byteOrder, out);
                                            }
                                            catch (IOException e) {
                                                throw e;
                                            }
                                            catch (Throwable e) {
                                                throw new RuntimeException("Decompression failed:", e);
                                            }
                                            if ((newPixelDataLen & 1) != 0) {
                                                out.write(0);
                                            }
                                        }
                                        parser.parseDataset(dcmDecodeParam, -1);
                                        ds.subSet(2145386512, -1).writeDataset(out, enc);
                                        break block62;
                                    }
                                    catch (JMException jme) {
                                        throw new RuntimeException("Unable to update dataset:", jme);
                                    }
                                }
                                catch (Throwable var21_41) {
                                    block68: {
                                        var22_20 = null;
                                        ** try [egrp 3[TRYBLOCK] [13 : 1462->1475)] { 
lbl212:
                                        // 1 sources

                                        if (dis != null) {
                                            dis.close();
                                        }
                                        break block68;
lbl215:
                                        // 1 sources

                                        catch (IOException ignore) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 4[TRYBLOCK] [14 : 1477->1490)] { 
lbl219:
                                    // 1 sources

                                    if (fiis == null) throw var21_41;
                                    fiis.close();
                                    throw var21_41;
lbl222:
                                    // 1 sources

                                    catch (IOException ignore) {
                                        // empty catch block
                                    }
                                    throw var21_41;
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [13 : 1462->1475)] { 
lbl227:
                            // 1 sources

                            if (dis != null) {
                                dis.close();
                            }
                            break block69;
lbl230:
                            // 1 sources

                            catch (IOException ignore) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [14 : 1477->1490)] { 
lbl234:
                        // 1 sources

                        if (fiis == null) return;
                        fiis.close();
                        return;
lbl237:
                        // 1 sources

                        catch (IOException ignore) {
                            // empty catch block
                        }
                        return;
                    }
                    var22_16 = null;
                    ** try [egrp 3[TRYBLOCK] [13 : 1462->1475)] { 
lbl243:
                    // 1 sources

                    if (dis != null) {
                        dis.close();
                    }
                    break block70;
lbl246:
                    // 1 sources

                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [14 : 1477->1490)] { 
lbl250:
                // 1 sources

                if (fiis == null) return;
                fiis.close();
                return;
lbl253:
                // 1 sources

                catch (IOException ignore) {
                    // empty catch block
                }
                return;
            }
            var22_19 = null;
            ** try [egrp 3[TRYBLOCK] [13 : 1462->1475)] { 
lbl259:
            // 1 sources

            if (dis != null) {
                dis.close();
            }
            break block71;
lbl262:
            // 1 sources

            catch (IOException ignore) {
                // empty catch block
            }
        }
        try {}
        catch (IOException ignore) {}
        if (fiis == null) return;
        fiis.close();
        return;
    }

    private void copyItem(boolean patchJpegLS, DataInputStream dis, Dataset ds, OutputStream out, DcmEncodeParam enc, int itemlen) throws IOException {
        if (patchJpegLS) {
            byte[] jpegheader = this.buffer;
            dis.readFully(jpegheader, 0, 17);
            byte[] lse = FileDataSource.selectLSE(jpegheader);
            if (lse == null) {
                ds.writeHeader(out, enc, -73728, 0, itemlen);
                out.write(jpegheader, 0, 17);
                this.copyBytes(dis, out, itemlen - 17, this.buffer);
            } else {
                ds.writeHeader(out, enc, -73728, 0, itemlen + 16);
                out.write(jpegheader, 0, 15);
                out.write(lse);
                this.copyBytes(dis, out, itemlen - 17, this.buffer);
                out.write(0);
            }
        } else {
            ds.writeHeader(out, enc, -73728, 0, itemlen);
            this.copyBytes(dis, out, itemlen, this.buffer);
        }
    }

    private static int toInt(byte[] b, int off) {
        return (b[off] & 0xFF) << 8 | b[off + 1] & 0xFF;
    }

    private static byte[] selectLSE(byte[] jpegheader) {
        if (FileDataSource.toInt(jpegheader, 0) != 65496) {
            log.warn((Object)"SOI marker is missing - do not patch JPEG LS");
            return null;
        }
        if (FileDataSource.toInt(jpegheader, 2) != 65527) {
            log.warn((Object)"SOI marker is not followed by JPEG-LS SOF marker - do not patch JPEG LS");
            return null;
        }
        if (FileDataSource.toInt(jpegheader, 4) != 11) {
            log.warn((Object)"unexpected length of JPEG-LS SOF marker segment - do not patch JPEG LS");
            return null;
        }
        int marker = FileDataSource.toInt(jpegheader, 15);
        if (marker != 65498) {
            log.warn((Object)(marker == 65528 ? "contains already LSE marker segment - do not patch JPEG LS" : "JPEG-LS SOF marker segment is not followed by SOS marker - do not patch JPEG LS"));
            return null;
        }
        switch (jpegheader[6]) {
            case 13: {
                log.info((Object)"Patch JPEG LS 13-bit with LSE segment(T1=34, T2=131, T3=548)");
                return LSE_13;
            }
            case 14: {
                log.info((Object)"Patch JPEG LS 14-bit with LSE segment(T1=66, T2=259, T3=1092)");
                return LSE_14;
            }
            case 15: {
                log.info((Object)"Patch JPEG LS 15-bit with LSE segment(T1=130, T2=515, T3=2180)");
                return LSE_15;
            }
            case 16: {
                log.info((Object)"Patch JPEG LS 16-bit with LSE segment(T1=258, T2=1027, T3=4356)");
                return LSE_16;
            }
        }
        return null;
    }

    private void adjustNumberOfFrames(Dataset ds) {
        ds.putIS(0x280008, this.simpleFrameList.length);
        DcmElement src = ds.remove(1375769136);
        if (src != null) {
            DcmElement dest = ds.putSQ(1375769136);
            for (int i = 0; i < this.simpleFrameList.length; ++i) {
                dest.addItem(src.getItem(this.simpleFrameList[i] - 1));
            }
        }
    }

    private void addContributingEquipmentSeq(Dataset ds) {
        if (this.contributingEquipment != null) {
            this.getOrPutSQ(ds, 1613825).addItem(this.contributingEquipment);
        }
    }

    private void addFrameExtractionSeq(Dataset ds) {
        DcmElement seq = this.getOrPutSQ(ds, 528740);
        Dataset item = seq.addNewItem();
        item.putUI(528743, ds.getString(524312));
        if (this.calculatedFrameList != null) {
            item.putUL(528738, this.calculatedFrameList);
        } else {
            item.putUL(528737, this.simpleFrameList);
        }
    }

    private DcmElement getOrPutSQ(Dataset ds, int tag) {
        DcmElement seq = ds.putSQ(tag);
        return seq != null ? seq : ds.putSQ(tag);
    }

    private int[] calculateFrameList(int frames) {
        int[] src = new int[frames];
        int length = 0;
        int i = 0;
        block0: while (i < this.calculatedFrameList.length) {
            int f = this.calculatedFrameList[i++];
            int last = this.calculatedFrameList[i++];
            int step = this.calculatedFrameList[i++];
            while (f <= last) {
                if (f > frames) break block0;
                src[length++] = f;
                f += step;
            }
        }
        int[] dest = new int[length];
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    private void write(Dataset ds, OutputStream out, DcmEncodeParam enc) throws IOException {
        if (this.writeFile) {
            if (this.excludePrivate) {
                Dataset dsOut = ds.excludePrivate();
                dsOut.setFileMetaInfo(ds.getFileMetaInfo());
                dsOut.writeFile(out, enc);
            } else {
                ds.writeFile(out, enc);
            }
        } else if (this.excludePrivate) {
            ds.excludePrivate().writeDataset(out, enc);
        } else {
            ds.writeDataset(out, enc);
        }
    }

    private void copyBytes(InputStream is, OutputStream out, int totLen, byte[] buffer) throws IOException {
        int len;
        for (int toRead = totLen; toRead > 0; toRead -= len) {
            len = is.read(buffer, 0, Math.min(toRead, buffer.length));
            if (len == -1) {
                throw new EOFException();
            }
            out.write(buffer, 0, len);
        }
    }

    static {
        Dataset purpose = defaultContributingEquipment.putSQ(4235632).addNewItem();
        purpose.putLO(524544, "109105");
        purpose.putSH(524546, "DCM");
        purpose.putLO(524548, "Frame Extracting Equipment");
        defaultContributingEquipment.putLO(524400, "dcm4che.org");
    }
}

