/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.util.Iterator;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.Association;
import org.dcm4chex.archive.util.XSLTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoercionUtils {
    private static final Logger log = LoggerFactory.getLogger(CoercionUtils.class);

    private CoercionUtils() {
    }

    public static Dataset getCoercionAttributesFor(Association a, Dataset in, Templates stylesheet) {
        if (stylesheet == null) {
            return null;
        }
        Dataset out = DcmObjectFactory.getInstance().newDataset();
        try {
            XSLTUtils.xslt(in, stylesheet, a, out);
        }
        catch (Exception e) {
            log.error("Attribute coercion failed:", (Throwable)e);
            return null;
        }
        return out;
    }

    public static Dataset getCoercionAttributesFor(Dataset in, TransformerHandler th) {
        if (th == null) {
            return null;
        }
        Dataset out = DcmObjectFactory.getInstance().newDataset();
        try {
            XSLTUtils.xslt(in, th, out);
        }
        catch (Exception e) {
            log.error("Attribute coercion failed:", (Throwable)e);
            return null;
        }
        return out;
    }

    public static void coerceAttributes(DcmObject ds, DcmObject coerce) {
        CoercionUtils.coerceAttributes(ds, coerce, null);
    }

    private static void coerceAttributes(DcmObject ds, DcmObject coerce, DcmElement parent) {
        boolean coerced = false;
        Iterator it = coerce.iterator();
        while (it.hasNext()) {
            DcmElement el = (DcmElement)it.next();
            DcmElement oldEl = ds.get(el.tag());
            if (el.isEmpty()) {
                boolean bl = coerced = oldEl != null && !oldEl.isEmpty();
                if (oldEl == null || coerced) {
                    ds.putXX(el.tag(), el.vr());
                }
            } else {
                DcmElement sq = oldEl;
                switch (el.vr()) {
                    case 21329: {
                        int i;
                        boolean bl = coerced = oldEl != null && sq.vr() != 21329;
                        if (oldEl == null || coerced) {
                            sq = ds.putSQ(el.tag());
                        }
                        int n = el.countItems();
                        for (i = 0; i < n; ++i) {
                            Dataset item = sq.getItem(i);
                            if (item == null) {
                                item = sq.addNewItem();
                            }
                            Dataset coerceItem = el.getItem(i);
                            CoercionUtils.coerceAttributes(item, coerceItem, el);
                            if (coerceItem.isEmpty()) continue;
                            coerced = true;
                        }
                        break;
                    }
                    case 20290: 
                    case 20294: 
                    case 20311: 
                    case 21838: {
                        int i;
                        int n;
                        if (el.hasDataFragments()) {
                            coerced = true;
                            sq = ds.putXXsq(el.tag(), el.vr());
                            n = el.countItems();
                            for (i = 0; i < n; ++i) {
                                sq.addDataFragment(el.getDataFragment(i));
                            }
                            break;
                        }
                    }
                    default: {
                        boolean bl = coerced = oldEl != null && !oldEl.equals(el);
                        if (oldEl != null && !coerced) break;
                        ds.putXX(el.tag(), el.vr(), el.getByteBuffer());
                    }
                }
            }
            if (coerced) {
                log.info(parent == null ? "Coerce " + oldEl + " to " + el : "Coerce " + oldEl + " to " + el + " in item of " + parent);
                continue;
            }
            if (oldEl == null && log.isDebugEnabled()) {
                log.debug(parent == null ? "Add " + el : "Add " + el + " in item of " + parent);
            }
            it.remove();
        }
    }
}

