/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheJournal {
    private static final String DEFAULT_FILE_PATH_PATTERN = "yyyy/MM/dd/HH";
    private static final Logger log = LoggerFactory.getLogger(CacheJournal.class);
    private File journalRootDir;
    private File dataRootDir;
    private SimpleDateFormat journalFilePathFormat = new SimpleDateFormat("yyyy/MM/dd/HH");
    private boolean freeIsRunning = false;

    public File getJournalRootDir() {
        return this.journalRootDir;
    }

    public void setJournalRootDir(File journalRootDir) {
        CacheJournal.assertWritableDiretory(journalRootDir);
        this.journalRootDir = journalRootDir;
    }

    public File getDataRootDir() {
        return this.dataRootDir;
    }

    public void setDataRootDir(File dataRootDir) {
        CacheJournal.assertWritableDiretory(dataRootDir);
        this.dataRootDir = dataRootDir;
    }

    private static void assertWritableDiretory(File dir) {
        CacheJournal.mkdirs(dir);
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException("Not a writable directory:" + dir);
        }
    }

    public String getJournalFilePathFormat() {
        return this.journalFilePathFormat.toPattern();
    }

    public void setJournalFilePathFormat(String format) {
        this.journalFilePathFormat = new SimpleDateFormat(format);
    }

    public synchronized void record(File f) throws IOException {
        this.record(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void record(File f, boolean update) throws IOException {
        String path = f.getPath().substring(this.dataRootDir.getPath().length() + 1);
        long time = System.currentTimeMillis();
        File journalFile = this.getJournalFile(time);
        if (journalFile.exists()) {
            if (update && journalFile.equals(this.getJournalFile(f.lastModified()))) {
                log.debug("{} already contains entry for {}", (Object)journalFile, (Object)f);
                return;
            }
            log.debug("M-UPDATE {}", (Object)journalFile);
        } else {
            CacheJournal.mkdirs(journalFile.getParentFile());
            log.debug("M-WRITE {}", (Object)journalFile);
        }
        FileWriter journal = new FileWriter(journalFile, true);
        try {
            journal.write(path + '\n');
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            journal.close();
            throw throwable;
        }
        journal.close();
        f.setLastModified(time);
    }

    private static void mkdirs(File dir) {
        if (dir.exists()) {
            return;
        }
        CacheJournal.mkdirs(dir.getParentFile());
        if (dir.mkdir()) {
            log.info("M-WRITE {}", (Object)dir);
        }
    }

    private synchronized File getJournalFile(long time) {
        return new File(this.journalRootDir, this.journalFilePathFormat.format(new Date(time)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long free(long size) throws IOException {
        CacheJournal cacheJournal = this;
        synchronized (cacheJournal) {
            if (this.freeIsRunning) {
                return 0L;
            }
            this.freeIsRunning = true;
        }
        try {
            long l = this.free(size, this.journalRootDir);
            Object var6_5 = null;
            this.freeIsRunning = false;
            return l;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.freeIsRunning = false;
            throw throwable;
        }
    }

    public void clearCache() {
        CacheJournal.deleteFilesOrDirectories(this.journalRootDir.listFiles());
        CacheJournal.deleteFilesOrDirectories(this.dataRootDir.listFiles());
    }

    public boolean isEmpty() {
        return this.dataRootDir.list().length == 0;
    }

    public static void deleteFilesOrDirectories(File[] files) {
        for (File f : files) {
            CacheJournal.deleteFileOrDirectory(f);
        }
    }

    public static boolean deleteFileOrDirectory(File f) {
        if (f.isDirectory()) {
            CacheJournal.deleteFilesOrDirectories(f.listFiles());
        }
        if (!f.delete()) {
            log.warn("Failed to delete {}", (Object)f);
            return false;
        }
        log.info("M-DELETE {}", (Object)f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long free(long size, File dir) throws IOException {
        long free = 0L;
        if (dir.isDirectory()) {
            Object[] fnames = dir.list();
            Arrays.sort(fnames);
            for (Object fname : fnames) {
                if ((free += this.free(size - free, new File(dir, (String)fname))) >= size) break;
            }
        } else {
            BufferedReader journal = new BufferedReader(new FileReader(dir));
            try {
                String path;
                while ((path = journal.readLine()) != null) {
                    File f = new File(this.dataRootDir, path);
                    if (!f.exists()) {
                        log.debug("{} already deleted", (Object)f);
                        continue;
                    }
                    if (!this.getJournalFile(f.lastModified()).equals(dir)) {
                        log.debug("{} was accessed after record in {}", (Object)f, (Object)dir);
                        continue;
                    }
                    long flen = f.length();
                    if (!CacheJournal.deleteFileAndParents(f, this.dataRootDir)) continue;
                    free += flen;
                }
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                journal.close();
                throw throwable;
            }
            journal.close();
            CacheJournal.deleteFileAndParents(dir, this.journalRootDir);
        }
        return free;
    }

    public static boolean deleteFileAndParents(File f, File baseDir) {
        if (!CacheJournal.deleteFileOrDirectory(f)) {
            return false;
        }
        File dir = f.getParentFile();
        while (!dir.equals(baseDir) && dir.delete()) {
            log.info("M-DELETE {}", (Object)dir);
            dir = dir.getParentFile();
        }
        return true;
    }
}

