/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.tce;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Attribute;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.log4j.Logger;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.PersonName;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.media.DirBuilderFactory;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PresContext;
import org.dcm4che.util.UIDGenerator;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.BeginTransferringMessage;
import org.dcm4che2.audit.message.DataExportMessage;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4che2.audit.util.InstanceSorter;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.DicomPriority;
import org.dcm4chex.archive.dcm.AbstractScuService;
import org.dcm4chex.archive.dcm.ianscu.IANScuService;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AEManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.StorageHome;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.tce.ExportTFOrder;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileDataSource;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ExportManagerService
extends AbstractScuService
implements MessageListener,
DimseListener {
    private static final String EXPORT_XSL = "export.xsl";
    private static final String PERSON_OBSERVER_NAME_CODE = "121008";
    private static final int PCID = 1;
    private static final UIDGenerator uidgen = UIDGenerator.getInstance();
    private static final String NONE = "NONE";
    private static final String ANY = "ANY";
    private ObjectName storeScpServiceName;
    private ObjectName queryRetrieveScpServiceName;
    private ObjectName ianScuServiceName;
    private String queueName;
    private int concurrency = 1;
    private boolean patchJpegLS;
    private String patchJpegLSImplCUID;
    private String[][] exportSelectorTitles = null;
    private String[][] delayReasons = null;
    private String[][] personNames = null;
    private File dispConfigFile;
    private Hashtable configs = new Hashtable();
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private int bufferSize;
    private boolean deleteKeyObjects;
    private int exportDelay = 2000;
    private ArrayList scheduledList = new ArrayList();
    private DecimalFormat filesetIDPattern;
    private int lastFilesetIDSeqno;
    private String mediaIDPrefix;
    private TemplatesDelegate templates = new TemplatesDelegate(this);
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            SeriesStored seriesStored = (SeriesStored)notif.getUserData();
            ExportManagerService.this.onSeriesStored(seriesStored);
        }
    };
    private final NotificationListener ianListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            ExportManagerService.this.onIAN((Dataset)notif.getUserData());
        }
    };

    public final String getAutoExportConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setAutoExportConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final String getExportSelectorTitles() {
        return this.codes2str(this.exportSelectorTitles);
    }

    public final void setExportSelectorTitles(String s) {
        this.exportSelectorTitles = this.str2codes(s);
    }

    public final String getDelayReasons() {
        return this.codes2str(this.delayReasons);
    }

    public final void setDelayReasons(String s) {
        this.delayReasons = this.str2codes(s);
    }

    public final String getPersonNameMapping() {
        if (this.personNames == null) {
            return "NONE\r\n";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.personNames.length; ++i) {
            sb.append(this.personNames[i][0]).append(":").append(this.personNames[i][1]);
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public final void setPersonNameMapping(String s) {
        StringTokenizer st = new StringTokenizer(s, ";\t\r\n");
        this.personNames = new String[st.countTokens()][2];
        for (int i = 0; i < this.personNames.length; ++i) {
            String pn = st.nextToken();
            int pos = pn.indexOf(58);
            if (pos == -1) {
                this.personNames = null;
                return;
            }
            this.personNames[i] = new String[2];
            this.personNames[i][0] = pn.substring(0, pos++);
            this.personNames[i][1] = pn.substring(pos);
        }
    }

    public final String getFilesetIDPattern() {
        return this.filesetIDPattern.toPattern();
    }

    public final void setFilesetIDPattern(String filesetID) {
        this.filesetIDPattern = new DecimalFormat(filesetID);
    }

    public final int getLastFilesetIDSeqno() {
        return this.lastFilesetIDSeqno;
    }

    public final void setLastFilesetIDSeqno(int seqno) {
        this.lastFilesetIDSeqno = seqno;
    }

    public final String getMediaIDPrefix() {
        return this.mediaIDPrefix;
    }

    public final void setMediaIDPrefix(String mediaIDPrefix) {
        this.mediaIDPrefix = mediaIDPrefix;
    }

    private synchronized String nextFilesetID() {
        try {
            this.server.setAttribute(this.serviceName, new Attribute("FilesetIDSeqno", new Integer(this.lastFilesetIDSeqno + 1)));
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to store incremented LastFilesetIDSeqno - will be reset by next reboot! ", (Throwable)e);
            ++this.lastFilesetIDSeqno;
        }
        return this.filesetIDPattern.format(this.lastFilesetIDSeqno);
    }

    public int getExportDelay() {
        return this.exportDelay;
    }

    public void setExportDelay(int exportDelay) {
        this.exportDelay = exportDelay;
    }

    private String codes2str(String[][] codes) {
        if (codes == null) {
            return NONE;
        }
        String sep = System.getProperty("line.separator", "\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < codes.length; ++i) {
            sb.append(codes[i][0]).append('^').append(codes[i][1]).append('^').append(codes[i][2]).append(sep);
        }
        return sb.toString();
    }

    private String[][] str2codes(String s) {
        if (s.equalsIgnoreCase(NONE)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, ";\r\n\t");
        String[][] tmp = new String[st.countTokens()][3];
        for (int i = 0; i < tmp.length; ++i) {
            String[] code = new String[3];
            StringTokenizer stCode = new StringTokenizer(st.nextToken().trim(), "^");
            code[0] = stCode.nextToken().trim();
            code[1] = stCode.hasMoreTokens() ? stCode.nextToken().trim() : "";
            code[2] = stCode.hasMoreTokens() ? stCode.nextToken().trim() : "";
            tmp[i] = code;
        }
        return tmp;
    }

    public final String getDispositionConfigFile() {
        return this.dispConfigFile.getPath();
    }

    public final void setDispositionConfigFile(String path) {
        this.dispConfigFile = new File(path.replace('/', File.separatorChar));
    }

    public boolean isDeleteKeyObjects() {
        return this.deleteKeyObjects;
    }

    public void setDeleteKeyObjects(boolean deleteKeyObjects) {
        this.deleteKeyObjects = deleteKeyObjects;
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getQueryRetrieveScpServiceName() {
        return this.queryRetrieveScpServiceName;
    }

    public final void setQueryRetrieveScpServiceName(ObjectName name) {
        this.queryRetrieveScpServiceName = name;
    }

    public final ObjectName getIANScuServiceName() {
        return this.ianScuServiceName;
    }

    public final void setIANScuServiceName(ObjectName ianScuServiceName) {
        this.ianScuServiceName = ianScuServiceName;
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final void setConcurrency(int concurrency) throws Exception {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency: " + concurrency);
        }
        if (this.concurrency != concurrency) {
            boolean restart;
            boolean bl = restart = this.getState() == 3;
            if (restart) {
                this.stop();
            }
            this.concurrency = concurrency;
            if (restart) {
                this.start();
            }
        }
    }

    private static String unmaskNull(String s, String mask) {
        return s.equalsIgnoreCase(mask) ? null : s;
    }

    private static String maskNull(String s, String mask) {
        return s == null ? mask : s;
    }

    public final String getPatchJpegLSImplCUID() {
        return this.patchJpegLS ? ExportManagerService.maskNull(this.patchJpegLSImplCUID, ANY) : NONE;
    }

    public final void setPatchJpegLSImplCUID(String s) {
        String trim = s.trim();
        this.patchJpegLS = !trim.equalsIgnoreCase(NONE);
        this.patchJpegLSImplCUID = this.patchJpegLS ? ExportManagerService.unmaskNull(trim, ANY) : null;
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, this.concurrency);
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.addNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.server.removeNotificationListener(this.ianScuServiceName, this.ianListener, IANScuService.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    private void onSeriesStored(SeriesStored seriesStored) {
        Dataset ian = seriesStored.getIAN();
        String suid = ian.getString(0x20000D);
        int len = this.exportSelectorTitles.length;
        for (int i = 0; i < len; ++i) {
            this.onSeriesStored(suid, this.exportSelectorTitles[i][0], this.exportSelectorTitles[i][1]);
        }
    }

    private void onSeriesStored(String suid, String code, String designator) {
        try {
            List l = this.getContentManager().listInstanceInfosByStudyAndSRCode(suid, "1.2.840.10008.5.1.4.1.1.88.59", code, designator, false);
            for (Dataset manifest : l) {
                if (!this.isAllReceived(manifest)) continue;
                try {
                    manifest = this.loadManifest(manifest);
                    if (this.isDelayed(manifest)) continue;
                    this.schedule(new ExportTFOrder(manifest), System.currentTimeMillis() + (long)this.exportDelay);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to process export selector with iuid=" + manifest.getString(524312)), (Throwable)e);
                }
            }
        }
        catch (Exception e1) {
            this.log.error((Object)("Query DB for Export Selectors " + code + '^' + designator + " of study " + suid + " failed!"), (Throwable)e1);
        }
    }

    private StorageHome getStorageHome() throws HomeFactoryException {
        return (StorageHome)EJBHomeFactory.getFactory().lookup(StorageHome.class, "ejb/Storage");
    }

    private void delete(Dataset manifest) throws RemoteException, FinderException, RemoveException, CreateException, HomeFactoryException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(manifest.getString(524312));
        this.copyIUIDs(manifest.get(4236581), list);
        String[] uids = list.toArray(new String[list.size()]);
        this.getStorageHome().create().deleteInstances(uids, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset loadManifest(Dataset sel) throws SQLException, IOException {
        Dataset dataset;
        Dataset keys = DcmObjectFactory.getInstance().newDataset();
        keys.putUI(524312, sel.getString(524312));
        FileInfo fileInfo = RetrieveCmd.createInstanceRetrieve((Dataset)keys).getFileInfos()[0][0];
        File file = FileUtils.toFile(fileInfo.basedir, fileInfo.fileID);
        this.log.info((Object)("M-READ file:" + file));
        FileInputStream fis = new FileInputStream(file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser(bis);
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            parser.setDcmHandler(ds.getDcmHandler());
            parser.parseDcmFile(FileFormat.DICOM_FILE, -1);
            DatasetUtils.fromByteArray(fileInfo.instAttrs, ds);
            DatasetUtils.fromByteArray(fileInfo.seriesAttrs, ds);
            DatasetUtils.fromByteArray(fileInfo.studyAttrs, ds);
            DatasetUtils.fromByteArray(fileInfo.patAttrs, ds);
            dataset = ds;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return dataset;
    }

    private boolean isAllReceived(Dataset sel) {
        ArrayList list = new ArrayList();
        this.copyIUIDs(sel.get(4236581), list);
        this.copyIUIDs(sel.get(4236149), list);
        if (list.size() < 1) {
            this.log.warn((Object)"No instance referenced in KOS! This manifest will be ignored!");
            return false;
        }
        String[] iuids = list.toArray(new String[list.size()]);
        this.log.info((Object)("Check if " + iuids.length + " referenced objects were already received"));
        try {
            List l = this.getContentManager().listInstanceInfos(iuids, false);
            int diff = iuids.length - l.size();
            if (diff > 0) {
                this.log.info((Object)("Waiting for receive of " + diff + " referenced objects"));
                return false;
            }
            this.log.info((Object)("All " + iuids.length + " referenced objects received!"));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Query DB for Referenced Instances failed!", (Throwable)e);
            return false;
        }
    }

    private boolean isDelayed(Dataset manifest) {
        if (this.delayReasons == null) {
            return false;
        }
        DcmElement sq = manifest.get(4237104);
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            Dataset cn = item.getItem(4235331);
            if (cn == null || !"113011".equals(cn.getString(524544)) || !"DCM".equals(cn.getString(524546))) continue;
            Dataset code = item.getItem(4235624);
            if (code == null) {
                this.log.warn((Object)"Missing Value for Document Title Modifier in Export Selector:");
                this.log.warn((Object)manifest);
                return false;
            }
            String cv = code.getString(524544);
            String cs = code.getString(524546);
            this.log.info((Object)("Detect Document Title Modifier in Export Selector:" + cv + "^" + cs + "^" + code.getString(524548)));
            for (int j = 0; j < this.delayReasons.length; ++j) {
                if (!cv.equals(this.delayReasons[j][0]) || !cs.equals(this.delayReasons[j][1])) continue;
                this.log.info((Object)"Delay Export of teaching files");
                return true;
            }
        }
        return false;
    }

    public void onMessage(Message message) {
        ObjectMessage om = (ObjectMessage)message;
        try {
            ExportTFOrder order = (ExportTFOrder)om.getObject();
            String iuid = order.getManifest().getString(524312);
            this.log.info((Object)("Start processing " + iuid));
            try {
                this.process(order);
                this.log.info((Object)("Finished processing " + iuid));
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to process " + iuid), (Throwable)e);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)("unexpected error during processing message: " + message), e);
        }
    }

    private void schedule(ExportTFOrder order, long scheduledTime) throws Exception {
        String iuid = order.getManifest().getString(524312);
        this.log.info((Object)("Scheduling Export TF order:" + iuid));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("already scheduled:" + this.scheduledList));
        }
        if (this.scheduledList.contains(iuid)) {
            this.log.info((Object)("Export TF order " + iuid + " is already scheduled! Ignore this order!"));
            return;
        }
        this.jmsDelegate.queue(this.queueName, order, 4, scheduledTime);
        this.scheduledList.add(iuid);
        this.copyIUIDs(order.getManifest().get(4236581), this.scheduledList);
        while (this.scheduledList.size() - 100 > 0) {
            this.log.debug((Object)("Scheduled list > 100 -> Remove eldest order from scheduled list:" + this.scheduledList.remove(0)));
        }
    }

    private void process(ExportTFOrder order) throws Exception {
        Dataset manifest = order.getManifest();
        Properties config = this.getConfig(manifest);
        String dest = config.getProperty("destination");
        String export = config.getProperty("export");
        int prior = DicomPriority.toCode(config.getProperty("export-priority", "MEDIUM"));
        int exportManifest = export.indexOf("MANIFEST");
        boolean exportInstances = export.indexOf("INSTANCES") != -1;
        boolean exportMedia = export.indexOf("MEDIA") != -1;
        boolean audit = "YES".equalsIgnoreCase(config.getProperty("audit"));
        HashMap attrs = new HashMap();
        FileInfo[] fileInfos = this.queryAttrs(manifest, attrs);
        int[] pcids = new int[fileInfos.length + 1];
        ActiveAssociation a = this.openAssociation(fileInfos, pcids, dest, exportManifest != -1, exportInstances, exportMedia);
        if (audit) {
            this.logBeginTransfering(a.getAssociation(), manifest, fileInfos);
        }
        HashMap iuidMap = new HashMap();
        if (!"NO".equalsIgnoreCase(config.getProperty("remove-delay-reason"))) {
            this.removeDelayReason(manifest);
        }
        Dataset sndManifest = null;
        if (exportManifest != -1) {
            sndManifest = DcmObjectFactory.getInstance().newDataset();
            sndManifest.putAll(manifest);
            this.coerceAttributes(sndManifest, config, iuidMap);
        }
        if (exportManifest == 0) {
            this.sendManifests(a, pcids[fileInfos.length], sndManifest, prior);
        }
        if (exportInstances) {
            byte[] b = new byte[this.bufferSize];
            for (int i = 0; i < fileInfos.length; ++i) {
                FileInfo info = fileInfos[i];
                Dataset ds = (Dataset)attrs.get(info.sopIUID);
                this.sendInstance(a, pcids[i], ds, info, config, iuidMap, b, prior);
            }
        }
        if (exportManifest > 0) {
            this.sendManifests(a, pcids[fileInfos.length], sndManifest, prior);
        }
        if (exportMedia) {
            this.sendMediaCreationRequest(a, manifest, config);
        }
        a.release(true);
        if (this.isDeleteKeyObjects()) {
            this.delete(manifest);
        }
    }

    private void sendMediaCreationRequest(ActiveAssociation aa, Dataset manifest, Properties config) throws InterruptedException, IOException {
        DcmObjectFactory df = DcmObjectFactory.getInstance();
        Command cmd = df.newCommand();
        Association a = aa.getAssociation();
        PresContext pc = a.getAcceptedPresContext("1.2.840.10008.5.1.1.33", "1.2.840.10008.1.2");
        int pcid = pc.pcid();
        String mcrqiuid = uidgen.createUID();
        cmd.initNCreateRQ(a.nextMsgID(), "1.2.840.10008.5.1.1.33", mcrqiuid);
        Dataset mcrq = df.newDataset();
        String fsid = this.nextFilesetID();
        String fsuid = uidgen.createUID();
        mcrq.putSH(8913200, fsid);
        mcrq.putSH(8913216, fsuid);
        String s = config.getProperty("create-media-label-from-instances");
        if (s != null) {
            mcrq.putCS(0x22000001, s);
        }
        if ((s = config.getProperty("create-media-label-text")) != null) {
            mcrq.putUT(0x22000002, s);
        }
        if ((s = config.getProperty("create-media-label-style")) != null) {
            mcrq.putCS(0x22000003, s);
        }
        if ((s = config.getProperty("create-media-disposition")) != null) {
            mcrq.putLT(0x22000004, s);
        }
        if ((s = config.getProperty("create-media-allow-media-splitting")) != null) {
            mcrq.putCS(0x22000007, s);
        }
        if ((s = config.getProperty("create-media-allow-lossy-compression")) != null) {
            mcrq.putCS(0x2200000F, s);
        }
        if ((s = config.getProperty("create-media-include-non-dicom")) != null) {
            mcrq.putCS(0x22000008, s);
        }
        if ((s = config.getProperty("create-media-include-display-app")) != null) {
            mcrq.putCS(0x22000009, s);
        }
        mcrq.putCS(0x2200000A, config.getProperty("create-media-preserve-instances", "NO"));
        String appProfile = config.getProperty("create-media-app-profile");
        DcmElement refSOPSeq = mcrq.putSQ(528793);
        DcmElement sopInstRefSeq = manifest.get(4236149);
        InstanceSorter sorter = new InstanceSorter();
        int n = sopInstRefSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refStudyItem = sopInstRefSeq.getItem(i);
            String suid = refStudyItem.getString(0x20000D);
            DcmElement refSerSeq = refStudyItem.get(528661);
            int m = refSerSeq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset refSer = refSerSeq.getItem(j);
                DcmElement srcRefSOPSeq = refSer.get(528793);
                int l = srcRefSOPSeq.countItems();
                for (int k = 0; k < l; ++k) {
                    Dataset srcRefSOP = srcRefSOPSeq.getItem(k);
                    Dataset refSOP = df.newDataset();
                    String cuid = srcRefSOP.getString(528720);
                    refSOP.putUI(528720, cuid);
                    String iuid = srcRefSOP.getString(528725);
                    refSOP.putUI(528725, iuid);
                    if (appProfile != null) {
                        refSOP.putCS(0x2200000C, appProfile);
                    }
                    refSOPSeq.addItem(refSOP);
                    sorter.addInstance(suid, cuid, iuid, null);
                }
            }
        }
        AssociationFactory af = AssociationFactory.getInstance();
        Dimse dimse = af.newDimse(pcid, cmd, mcrq);
        Command rsp = aa.invoke(dimse).get().getCommand();
        if (rsp.getStatus() != 0) {
            this.log.warn((Object)("Request Media Creation failed: " + rsp));
            return;
        }
        cmd.clear();
        mcrq.clear();
        cmd.initNActionRQ(a.nextMsgID(), "1.2.840.10008.5.1.1.33", mcrqiuid, 1);
        s = config.getProperty("create-media-copies");
        if (s != null) {
            mcrq.putIS(0x20000010, s);
        }
        if ((s = config.getProperty("create-media-priority")) != null) {
            mcrq.putCS(0x22000020, s);
        }
        if ((rsp = aa.invoke(dimse = af.newDimse(pcid, cmd, mcrq)).get().getCommand()).getStatus() != 0) {
            this.log.warn((Object)("Initiate Media Creation failed: " + rsp));
            return;
        }
        this.logExport(manifest, sorter, fsid, fsuid);
    }

    private String extractPersonObserverName(Dataset manifest) {
        DcmElement contentSeq = manifest.get(4237104);
        int n = contentSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = contentSeq.getItem(i);
            Dataset conceptName = item.getItem(4235331);
            if (conceptName == null || !PERSON_OBSERVER_NAME_CODE.equals(conceptName.getString(524544)) || !"DCM".equals(conceptName.getString(524546))) continue;
            return item.getString(4235555);
        }
        return null;
    }

    private void logExport(Dataset manifest, InstanceSorter sorter, String fsid, String fsuid) {
        try {
            String user = this.extractPersonObserverName(manifest);
            String pid = manifest.getString(0x100020);
            String mediaID = this.mediaIDPrefix + fsid;
            PersonName pn = manifest.getPersonName(0x100010);
            String pname = pn != null ? pn.format() : null;
            DataExportMessage msg = new DataExportMessage();
            msg.addExporterProcess(AuditMessage.getProcessID(), new String[]{this.callingAET}, AuditMessage.getProcessName(), user == null, AuditMessage.getLocalHostName());
            if (user != null) {
                msg.addExporterPerson(user, null, null, true, null);
            }
            msg.addDestinationMedia(mediaID, fsuid);
            msg.addPatient(pid, pname);
            for (String suid : sorter.getSUIDs()) {
                ParticipantObjectDescription desc = new ParticipantObjectDescription();
                for (String cuid : sorter.getCUIDs(suid)) {
                    ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
                    sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
                    desc.addSOPClass(sopClass);
                }
                msg.addStudy(suid, desc);
            }
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    public void dimseReceived(Association assoc, Dimse dimse) {
    }

    private void sendInstance(ActiveAssociation a, int pcid, Dataset attrs, FileInfo fileInfo, Properties config, HashMap iuidMap, byte[] buffer, int prior) throws Exception {
        this.coerceAttributes(attrs, config, iuidMap);
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initCStoreRQ(a.getAssociation().nextMsgID(), fileInfo.sopCUID, attrs.getString(524312), prior);
        FileDataSource src = new FileDataSource(this.getFile(fileInfo), attrs, buffer);
        src.setPatchJpegLS(this.patchJpegLS);
        src.setPatchJpegLSImplCUID(this.patchJpegLSImplCUID);
        Dimse dimse = AssociationFactory.getInstance().newDimse(pcid, cmd, src);
        a.invoke(dimse, this);
    }

    private boolean isLocalRetrieveAET(String aet) throws Exception {
        return (Boolean)this.server.invoke(this.queryRetrieveScpServiceName, "isLocalRetrieveAET", new Object[]{aet}, new String[]{String.class.getName()});
    }

    private File getFile(FileInfo fileInfo) throws Exception {
        return (File)this.server.invoke(this.queryRetrieveScpServiceName, "getFile", new Object[]{fileInfo.basedir, fileInfo.fileID}, new String[]{String.class.getName(), String.class.getName()});
    }

    private void coerceAttributes(Dataset attrs, Properties config, HashMap iuidMap) throws DcmValueException {
        int count;
        String cuid = attrs.getString(524310);
        String iuid = attrs.getString(524312);
        UIDDictionary dict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
        int numpasses = Integer.parseInt(config.getProperty("num-coerce-passes", "0"));
        for (int i = 0; i < numpasses; ++i) {
            count = 0;
            String prefix = "" + (i + 1) + ".";
            for (Map.Entry<Object, Object> e : config.entrySet()) {
                String key = (String)e.getKey();
                if (!key.startsWith(prefix)) continue;
                this.coerceAttribute(attrs, key.substring(prefix.length()), (String)e.getValue());
                ++count;
            }
            this.log.info((Object)("Coerce " + count + " attributes in " + dict.toString(cuid) + " with iuid:" + iuid + " in " + prefix + "pass"));
        }
        boolean replaceUIDs = "YES".equalsIgnoreCase(config.getProperty("replace-uids"));
        if (replaceUIDs) {
            count = this.replaceUIDs(attrs, iuidMap);
            this.log.info((Object)("Replace " + count + " UIDs in " + dict.toString(cuid) + " with original iuid:" + iuid));
        }
    }

    private void sendManifests(ActiveAssociation a, int pcid, Dataset manifest, int prior) throws InterruptedException, IOException {
        this.sendManifest(a, pcid, manifest, prior);
        DcmElement identicalsq = manifest.get(4236581);
        if (identicalsq != null && !identicalsq.isEmpty()) {
            Dataset studyItem = DcmObjectFactory.getInstance().newDataset();
            studyItem.putUI(0x20000D, manifest.getString(0x20000D));
            Dataset seriesItem = studyItem.putSQ(528661).addNewItem();
            seriesItem.putUI(0x20000E, manifest.getString(0x20000E));
            Dataset refSOPItem = seriesItem.putSQ(528793).addNewItem();
            refSOPItem.putUI(528725, manifest.getString(524312));
            refSOPItem.putUI(528720, manifest.getString(524310));
            int n = identicalsq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset otherStudyItem = identicalsq.getItem(i);
                manifest.putUI(0x20000D, otherStudyItem.getString(0x20000D));
                Dataset otherSeriesItem = otherStudyItem.getItem(528661);
                manifest.putUI(0x20000E, otherSeriesItem.getString(0x20000E));
                Dataset otherRefSOPItem = otherSeriesItem.getItem(528793);
                manifest.putUI(524312, otherRefSOPItem.getString(528725));
                DcmElement otherIdenticalsq = manifest.putSQ(4236581);
                for (int j = 0; j < n; ++j) {
                    otherIdenticalsq.addItem(i == j ? studyItem : identicalsq.getItem(j));
                }
                this.sendManifest(a, pcid, manifest, prior);
            }
        }
    }

    private void removeDelayReason(Dataset manifest) {
        DcmElement oldsq = manifest.get(4237104);
        DcmElement newsq = manifest.putSQ(4237104);
        int n = oldsq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = oldsq.getItem(i);
            Dataset cn = item.getItem(4235331);
            if (cn != null && "113011".equals(cn.getString(524544)) && "DCM".equals(cn.getString(524546))) continue;
            newsq.addItem(item);
        }
    }

    private void sendManifest(ActiveAssociation a, int pcid, Dataset manifest, int prior) throws InterruptedException, IOException {
        Command cmd = DcmObjectFactory.getInstance().newCommand();
        cmd.initCStoreRQ(a.getAssociation().nextMsgID(), manifest.getString(524310), manifest.getString(524312), prior);
        Dimse dimse = AssociationFactory.getInstance().newDimse(pcid, cmd, manifest);
        a.invoke(dimse, this);
    }

    private ActiveAssociation openAssociation(FileInfo[] fileInfos, int[] pcids, String dest, boolean exportManifest, boolean exportInstances, boolean exportMedia) throws Exception {
        PresContext pc;
        AEManager aeMgt = this.aeMgt();
        AEDTO localAE = aeMgt.findByAET(this.callingAET);
        AEDTO remoteAE = aeMgt.findByAET(dest);
        AssociationFactory af = AssociationFactory.getInstance();
        AAssociateRQ rq = af.newAAssociateRQ();
        rq.setCallingAET(this.callingAET);
        rq.setCalledAET(dest);
        HashMap cuids = new HashMap();
        if (exportManifest) {
            cuids.put("1.2.840.10008.5.1.4.1.1.88.59", new HashSet());
        }
        if (exportInstances) {
            for (int i = 0; i < fileInfos.length; ++i) {
                FileInfo info = fileInfos[i];
                HashSet<String> tsuids = (HashSet<String>)cuids.get(info.sopCUID);
                if (tsuids == null) {
                    tsuids = new HashSet<String>();
                    cuids.put(info.sopCUID, tsuids);
                }
                tsuids.add(info.tsUID);
            }
        }
        for (Map.Entry e : cuids.entrySet()) {
            String cuid = (String)e.getKey();
            Set tsuids = (Set)e.getValue();
            tsuids.add("1.2.840.10008.1.2");
            for (String tsuid : tsuids) {
                PresContext pc2 = af.newPresContext(rq.nextPCID(), cuid, tsuid);
                rq.addPresContext(pc2);
            }
        }
        if (exportMedia) {
            PresContext pc3 = af.newPresContext(rq.nextPCID(), "1.2.840.10008.5.1.1.33", "1.2.840.10008.1.2");
            rq.addPresContext(pc3);
        }
        Association a = af.newRequestor(this.tlsConfig.createSocket(localAE, remoteAE));
        a.setAcTimeout(this.acTimeout);
        a.setDimseTimeout(this.dimseTimeout);
        a.setSoCloseDelay(this.soCloseDelay);
        PDU ac = a.connect(rq);
        if (!(ac instanceof AAssociateAC)) {
            throw new IOException("Association not accepted by " + dest + ": " + ac);
        }
        ActiveAssociation aa = af.newActiveAssociation(a, null);
        aa.start();
        if (exportManifest) {
            PresContext pc4 = a.getAcceptedPresContext("1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.1.2");
            if (pc4 == null) {
                this.throwStorageNotSupported(aa, "1.2.840.10008.5.1.4.1.1.88.59", dest);
            }
            pcids[fileInfos.length] = pc4.pcid();
        }
        if (exportInstances) {
            for (int i = 0; i < fileInfos.length; ++i) {
                FileInfo info = fileInfos[i];
                PresContext pc5 = a.getAcceptedPresContext(info.sopCUID, info.tsUID);
                if (pc5 == null && (pc5 = a.getAcceptedPresContext(info.sopCUID, "1.2.840.10008.1.2")) == null) {
                    this.throwStorageNotSupported(aa, info.sopCUID, dest);
                }
                pcids[i] = pc5.pcid();
            }
        }
        if (exportMedia && (pc = a.getAcceptedPresContext("1.2.840.10008.5.1.1.33", "1.2.840.10008.1.2")) == null) {
            this.throwStorageNotSupported(aa, "1.2.840.10008.5.1.1.33", dest);
        }
        return aa;
    }

    private void throwStorageNotSupported(ActiveAssociation aa, String uid, String dest) throws IOException, InterruptedException {
        aa.release(false);
        UIDDictionary dd = DictionaryFactory.getInstance().getDefaultUIDDictionary();
        throw new IOException(dd.toString(uid) + " not supported by " + dest);
    }

    private Properties getConfig(Dataset manifest) throws IOException {
        Dataset code;
        String key;
        String fname;
        File indexFile = FileUtils.resolve(this.dispConfigFile);
        Properties index = this.getProperties(indexFile);
        DcmElement sq = manifest.get(4237104);
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset cn;
            Dataset item = sq.getItem(i);
            if (!"TEXT".equals(item.getString(0x40A040)) || (cn = item.getItem(4235331)) == null || !"113012".equals(cn.getString(524544)) || !"DCM".equals(cn.getString(524546))) continue;
            String fname2 = index.getProperty(item.getString(4235616));
            if (fname2 == null) break;
            return this.getProperties(this.toConfigFile(indexFile, fname2));
        }
        if ((fname = index.getProperty(key = (code = manifest.getItem(4235331)).getString(524544) + '^' + code.getString(524546))) == null) {
            throw new ConfigurationException("Missing entry for Concept Name Code " + key + " in " + indexFile);
        }
        return this.getProperties(this.toConfigFile(indexFile, fname));
    }

    private File toConfigFile(File indexFile, String fname) {
        return new File(indexFile.getParentFile(), fname.replace('/', File.separatorChar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(File f) throws IOException {
        Properties config = (Properties)this.configs.get(f);
        if (config == null) {
            config = new Properties();
            FileInputStream in = new FileInputStream(f);
            try {
                config.load(new BufferedInputStream(in));
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            this.configs.put(f, config);
        }
        return config;
    }

    private FileInfo[] queryAttrs(Dataset sel, Map attrs) throws Exception {
        ArrayList list = new ArrayList();
        this.copyIUIDs(sel.get(4236149), list);
        Dataset keys = DcmObjectFactory.getInstance().newDataset();
        keys.putUI(524312, list.toArray(new String[list.size()]));
        String patID = sel.getString(0x100020);
        RetrieveCmd cmd = RetrieveCmd.createInstanceRetrieve((Dataset)keys);
        cmd.setFetchSize(this.getFetchSize());
        FileInfo[][] a = cmd.getFileInfos();
        FileInfo[] b = new FileInfo[a.length];
        for (int i = 0; i < a.length; ++i) {
            FileInfo info = b[i] = this.selectBestFile(a[i]);
            if (!ExportManagerService.equals(patID, info.patID)) {
                throw new Exception("Export Selector references studies for different patients");
            }
            Dataset mergeAttrs = DatasetUtils.fromByteArray(info.patAttrs, DatasetUtils.fromByteArray(info.studyAttrs, DatasetUtils.fromByteArray(info.seriesAttrs, DatasetUtils.fromByteArray(info.instAttrs))));
            attrs.put(info.sopIUID, mergeAttrs);
        }
        return b;
    }

    private FileInfo selectBestFile(FileInfo[] fileInfos) throws Exception {
        Arrays.sort(fileInfos);
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.fileRetrieveAET == null || !this.isLocalRetrieveAET(fileInfo.fileRetrieveAET)) continue;
            return fileInfo;
        }
        throw new IOException("Instance[iuid=" + fileInfos[0].sopIUID + "] not locally available!");
    }

    private void copyIUIDs(DcmElement sq1, List list) {
        if (sq1 == null) {
            return;
        }
        int n1 = sq1.countItems();
        for (int i1 = 0; i1 < n1; ++i1) {
            Dataset item1 = sq1.getItem(i1);
            DcmElement sq2 = item1.get(528661);
            int n2 = sq2.countItems();
            for (int i2 = 0; i2 < n2; ++i2) {
                Dataset item2 = sq2.getItem(i2);
                DcmElement sq3 = item2.get(528793);
                int n3 = sq3.countItems();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Dataset item3 = sq3.getItem(i3);
                    String iuid = item3.getString(528725);
                    list.add(iuid);
                }
            }
        }
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void coerceAttribute(Dataset attrs, String key, String pattern) {
        int tag = Tags.forName(key);
        if (pattern.length() == 0) {
            this.deleteValue(attrs, tag);
        } else if (pattern.equals("firstDayOfMonth()")) {
            this.setFirstDayOfMonth(attrs, tag);
        } else {
            this.changeValue(attrs, tag, pattern);
        }
    }

    private void deleteValue(Dataset attrs, int tag) {
        attrs.putXX(tag);
    }

    private void setFirstDayOfMonth(Dataset attrs, int tag) {
        DcmElement el = attrs.get(tag);
        try {
            Date date;
            if (el == null || (date = el.getDate()) == null) {
                return;
            }
            date.setDate(1);
            if (el.vr() == 17473) {
                attrs.putDA(tag, date);
            } else if (el.vr() == 17492) {
                attrs.putDT(tag, date);
            } else {
                this.log.warn((Object)("Unexpected VR, delete value - " + el));
                attrs.putXX(tag);
            }
        }
        catch (DcmValueException e) {
            this.log.warn((Object)("Delete illegal Date value: " + el), (Throwable)e);
            attrs.putXX(tag);
        }
    }

    private void changeValue(Dataset attrs, int tag, String pattern) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer stk = new StringTokenizer(pattern, "#${}", true);
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            char ch = tk.charAt(0);
            if (ch != '#' && ch != '$' || !stk.hasMoreTokens()) {
                sb.append(tk);
                continue;
            }
            tk = stk.nextToken();
            if (!tk.equals("{") || !stk.hasMoreTokens()) {
                sb.append((int)ch).append(tk);
                continue;
            }
            tk = stk.nextToken();
            int srctag = Tags.forName(tk);
            String s = attrs.getString(srctag);
            if (s != null) {
                if (ch == '#') {
                    s = Integer.toString(s.hashCode());
                }
                sb.append(s);
            }
            if (!stk.hasMoreTokens()) continue;
            stk.nextToken();
        }
        attrs.putXX(tag, sb.toString());
    }

    private int replaceUIDs(Dataset ds, HashMap uidmap) throws DcmValueException {
        int count = 0;
        Iterator iter = ds.iterator();
        while (iter.hasNext()) {
            DcmElement elm = (DcmElement)iter.next();
            int tag = elm.tag();
            if (tag == 524312 || tag == 528725 || tag == 0x20000E || tag == 0x20000D) {
                String from = elm.getString(null);
                String to = (String)uidmap.get(from);
                if (to == null) {
                    to = uidgen.createUID();
                    uidmap.put(from, to);
                }
                ds.putUI(elm.tag(), to);
                ++count;
                continue;
            }
            if (elm.vr() != 21329) continue;
            int n = elm.countItems();
            for (int i = 0; i < n; ++i) {
                count += this.replaceUIDs(elm.getItem(i), uidmap);
            }
        }
        return count;
    }

    public Collection listConfiguredDispositions() throws IOException {
        File indexFile = FileUtils.resolve(this.dispConfigFile);
        Properties index = this.getProperties(indexFile);
        ArrayList<Object> list = new ArrayList<Object>(index.keySet());
        Collections.sort(list);
        return list;
    }

    public String getObserverPerson(String user) {
        if (this.personNames != null) {
            for (int i = 0; i < this.personNames.length; ++i) {
                if (!this.personNames[i][0].equals(user)) continue;
                return this.personNames[i][1];
            }
        }
        return this.callingAET + "^" + user;
    }

    public void clearConfigCache() {
        this.configs.clear();
    }

    public void storeExportSelection(Dataset manifest, int prior) throws Exception {
        String dest;
        try {
            String calledAETs = (String)this.server.getAttribute(this.storeScpServiceName, "CalledAETitles");
            int pos = calledAETs.indexOf(92);
            dest = pos == -1 ? calledAETs : calledAETs.substring(0, pos);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new UnknownAETException("Cant get a CalledAET from StoreSCP service! Reason:" + x.getMessage());
        }
        ActiveAssociation aa = this.openAssociation(dest, manifest.getString(524310));
        this.sendManifests(aa, 1, manifest, prior);
        aa.release(true);
    }

    private void logBeginTransfering(Association a, Dataset manifest, FileInfo[] fileInfos) {
        int i;
        InstanceSorter sorter = new InstanceSorter();
        sorter.addInstance(manifest.getString(0x20000D), manifest.getString(524310), manifest.getString(524312), null);
        DcmElement identicalsq = manifest.get(4236581);
        if (identicalsq != null && !identicalsq.isEmpty()) {
            int n = identicalsq.countItems();
            for (i = 0; i < n; ++i) {
                Dataset otherStudyItem = identicalsq.getItem(i);
                Dataset otherSeriesItem = otherStudyItem.getItem(528661);
                Dataset otherRefSOPItem = otherSeriesItem.getItem(528793);
                sorter.addInstance(otherStudyItem.getString(0x20000D), otherRefSOPItem.getString(528720), otherRefSOPItem.getString(528725), null);
            }
        }
        for (i = 0; i < fileInfos.length; ++i) {
            sorter.addInstance(fileInfos[i].studyIUID, fileInfos[i].sopCUID, fileInfos[i].sopIUID, null);
        }
        BeginTransferringMessage msg = new BeginTransferringMessage();
        msg.addSourceProcess(AuditMessage.getProcessID(), new String[]{this.callingAET}, AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), true);
        String destHost = AuditMessage.hostNameOf((InetAddress)a.getSocket().getInetAddress());
        msg.addDestinationProcess(destHost, new String[]{a.getCalledAET()}, null, destHost, false);
        PersonName pname = manifest.getPersonName(0x100010);
        msg.addPatient(manifest.getString(0x100020), pname != null ? pname.format() : null);
        for (String suid : sorter.getSUIDs()) {
            ParticipantObjectDescription desc = new ParticipantObjectDescription();
            for (String cuid : sorter.getCUIDs(suid)) {
                ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(cuid);
                sopClass.setNumberOfInstances(sorter.countInstances(suid, cuid));
                desc.addSOPClass(sopClass);
            }
            msg.addStudy(suid, desc);
        }
        msg.validate();
        Logger.getLogger((String)"auditlog").info((Object)msg);
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }

    private void onIAN(final Dataset mpps) {
        TransformerHandler th;
        String aet = mpps.getString(4194881);
        Templates tpl = this.templates.getTemplatesForAET(aet, EXPORT_XSL);
        if (tpl == null) {
            return;
        }
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            th = tf.newTransformerHandler(tpl);
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationException(e);
        }
        th.setResult(new SAXResult(new DefaultHandler(){

            public void startElement(String uri, String localName, String qName, Attributes attrs) {
                if (qName.equals("export")) {
                    try {
                        ExportManagerService.this.storeExportSelection(ExportManagerService.createManifest(mpps, attrs.getValue("code"), attrs.getValue("designator"), attrs.getValue("meaning"), attrs.getValue("disposition")), 0);
                    }
                    catch (Exception e) {
                        ExportManagerService.this.logExportError(mpps, e);
                    }
                }
            }
        }));
        try {
            mpps.writeDataset2(th, null, null, 64, null);
        }
        catch (IOException e) {
            this.logExportError(mpps, e);
        }
    }

    private void logExportError(Dataset mpps, Exception e) {
        this.log.error((Object)("scheduling export triggered by MPPS[uid=" + mpps.getString(524312) + "] of Study[uid=" + ExportManagerService.getScheduledStepAttribute(mpps, 0x20000D) + "] fails: "), (Throwable)e);
    }

    private static String getScheduledStepAttribute(Dataset mpps, int tag) {
        Dataset ssa = mpps.getItem(4194928);
        return ssa != null ? ssa.getString(tag) : null;
    }

    private static Dataset createManifest(Dataset mpps, String code, String designator, String meaning, String disposition) {
        UIDGenerator uidGen = UIDGenerator.getInstance();
        Dataset manifest = DcmObjectFactory.getInstance().newDataset();
        ExportManagerService.initKOCommonModule(manifest, mpps, uidGen);
        ExportManagerService.initKOPatientModule(manifest, mpps);
        ExportManagerService.initKOStudyModule(manifest, mpps);
        ExportManagerService.initKOSeriesModule(manifest, uidGen);
        ExportManagerService.initKODocumentModule(manifest, mpps);
        ExportManagerService.initKOContentModule(manifest, mpps, code, designator, meaning, disposition);
        return manifest;
    }

    private static void initKOCommonModule(Dataset manifest, Dataset mpps, UIDGenerator uidGen) {
        manifest.putCS(524293, mpps.getString(524293));
        manifest.putUI(524310, "1.2.840.10008.5.1.4.1.1.88.59");
        manifest.putUI(524312, uidGen.createUID());
    }

    private static void initKOPatientModule(Dataset manifest, Dataset mpps) {
        manifest.putPN(0x100010, mpps.getString(0x100010));
        manifest.putLO(0x100020, mpps.getString(0x100020));
        manifest.putLO(0x100021, mpps.getString(0x100021));
        manifest.putDA(0x100030, mpps.getString(0x100030));
        manifest.putCS(0x100040, mpps.getString(0x100040));
    }

    private static void initKOStudyModule(Dataset manifest, Dataset mpps) {
        manifest.putUI(0x20000D, ExportManagerService.getScheduledStepAttribute(mpps, 0x20000D));
        manifest.putDA(524320);
        manifest.putTM(524336);
        manifest.putPN(524432);
        manifest.putSH(0x200010, mpps.getString(0x200010));
        manifest.putSH(524368, ExportManagerService.getScheduledStepAttribute(mpps, 524368));
    }

    private static void initKOSeriesModule(Dataset manifest, UIDGenerator uidGen) {
        manifest.putCS(524384, "KO");
        manifest.putUI(0x20000E, uidGen.createUID());
        manifest.putIS(0x200011, 0);
        manifest.putSQ(528657);
        manifest.putLO(524400);
    }

    private static void initKODocumentModule(Dataset manifest, Dataset mpps) {
        Date now = new Date();
        manifest.putIS(2097171, 1);
        manifest.putDA(524323, now);
        manifest.putTM(524339, now);
        DcmElement evidenceSeq = manifest.putSQ(4236149);
        Dataset evidenceSeqItem = evidenceSeq.addNewItem();
        evidenceSeqItem.putUI(0x20000D, ExportManagerService.getScheduledStepAttribute(mpps, 0x20000D));
        DcmElement refSeriesSeq = evidenceSeqItem.putSQ(528661);
        DcmElement perfSeriesSeq = mpps.get(0x400340);
        int n = perfSeriesSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset perfSeriesItem = perfSeriesSeq.getItem(i);
            Dataset refSeriesItem = refSeriesSeq.addNewItem();
            refSeriesItem.putUI(0x20000E, perfSeriesItem.getString(0x20000E));
            DcmElement refSOPSeq = refSeriesItem.putSQ(528793);
            ExportManagerService.copyRefSOPSeq(perfSeriesItem.get(528704), refSOPSeq);
            ExportManagerService.copyRefSOPSeq(perfSeriesItem.get(0x400220), refSOPSeq);
        }
    }

    private static void copyRefSOPSeq(DcmElement srcSeq, DcmElement dstSeq) {
        if (srcSeq == null) {
            return;
        }
        int n = srcSeq.countItems();
        for (int i = 0; i < n; ++i) {
            dstSeq.addItem(srcSeq.getItem(i));
        }
    }

    private static void initKOContentModule(Dataset manifest, Dataset mpps, String code, String designator, String meaning, String disposition) {
        manifest.putCS(0x40A040, "CONTAINER");
        manifest.putCS(4235344, "SEPARATE");
        ExportManagerService.addConceptNameCode(manifest, code, designator, meaning);
        DcmElement contentSeq = manifest.putSQ(4237104);
        if (disposition != null && disposition.length() != 0) {
            Dataset koDescription = ExportManagerService.addContentItem(contentSeq, "TEXT");
            ExportManagerService.addConceptNameCode(koDescription, "113012", "DCM", "Key Object Description");
            koDescription.putUT(4235616, disposition);
        }
        DcmElement perfSeriesSeq = mpps.get(0x400340);
        int n = perfSeriesSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset perfSeriesItem = perfSeriesSeq.getItem(i);
            ExportManagerService.addKORefs(contentSeq, perfSeriesItem.get(528704));
            ExportManagerService.addKORefs(contentSeq, perfSeriesItem.get(0x400220));
        }
    }

    private static void addKORefs(DcmElement contentSeq, DcmElement refSOPSeq) {
        if (refSOPSeq == null) {
            return;
        }
        int n = refSOPSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSOPItem = refSOPSeq.getItem(i);
            String cuid = refSOPItem.getString(528720);
            String iuid = refSOPItem.getString(528725);
            Dataset koRefSOPItem = ExportManagerService.addContentItem(contentSeq, ExportManagerService.toKORefTyp(cuid)).putSQ(528793).addNewItem();
            koRefSOPItem.putUI(528720, cuid);
            koRefSOPItem.putUI(528725, iuid);
        }
    }

    private static String toKORefTyp(String cuid) {
        String recType = DirBuilderFactory.getRecordType(cuid);
        return recType == "IMAGE" || recType == "WAVEFORM" ? recType : "COMPOSITE";
    }

    private static Dataset addContentItem(DcmElement contentSeq, String type) {
        Dataset item = contentSeq.addNewItem();
        item.putCS(4235280, "CONTAINS");
        item.putCS(0x40A040, type);
        return item;
    }

    private static void addConceptNameCode(Dataset ds, String code, String designator, String meaning) {
        Dataset item = ds.putSQ(4235331).addNewItem();
        item.putLO(524544, code);
        item.putLO(524546, designator);
        item.putLO(524548, meaning);
    }
}

