/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.mbean.JMSDelegate;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.archive.mbean.WadoPrefetchOrder;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WadoPrefetchService
extends ServiceMBeanSupport
implements MessageListener {
    private static final String WADO_PREFETCH_XSL = "wado-prefetch.xsl";
    private static final int BUF_LEN = 65536;
    private final NotificationListener seriesStoredListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            WadoPrefetchService.this.onSeriesStored((SeriesStored)notif.getUserData());
        }
    };
    private String wadoBaseUrl;
    private String exportBasePath;
    private ObjectName storeScpServiceName;
    private String queueName;
    private JMSDelegate jmsDelegate = new JMSDelegate(this);
    private RetryIntervalls retryIntervalls = new RetryIntervalls();
    private TemplatesDelegate templates = new TemplatesDelegate(this);

    public String getWadoBaseUrl() {
        return this.wadoBaseUrl;
    }

    public void setWadoBaseUrl(String wadoBaseUrl) {
        this.wadoBaseUrl = wadoBaseUrl;
    }

    public String getExportBasePath() {
        return this.exportBasePath;
    }

    public void setExportBasePath(String path) {
        this.exportBasePath = path;
    }

    public final String getConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public final ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public final void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsDelegate.getJmsServiceName();
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsDelegate.setJmsServiceName(jmsServiceName);
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public final String getRetryIntervalls() {
        return this.retryIntervalls.toString();
    }

    public final void setRetryIntervalls(String text) {
        this.retryIntervalls = new RetryIntervalls(text);
    }

    protected void startService() throws Exception {
        this.jmsDelegate.startListening(this.queueName, this, 1);
        this.server.addNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
    }

    protected void stopService() throws Exception {
        this.server.removeNotificationListener(this.storeScpServiceName, this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        this.jmsDelegate.stopListening(this.queueName);
    }

    private void onSeriesStored(final SeriesStored stored) {
        if (stored.getRetrieveAET() == null) {
            this.log.warn((Object)"Ignore SeriesStored notification! Reason: Series is not locally retrievable.");
            return;
        }
        this.log.info((Object)("Handle SeriesStored Notification! stored:" + stored));
        Templates tpl = null;
        try {
            tpl = this.templates.getTemplatesForAET(stored.getSourceAET(), WADO_PREFETCH_XSL);
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to get Template for wado-prefetch.xsl!", t);
        }
        if (tpl != null) {
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            ds.putAll(stored.getPatientAttrs());
            ds.putAll(stored.getStudyAttrs());
            ds.putAll(stored.getSeriesAttrs());
            this.log.debug((Object)"WADOPrefetch schedule transform input:");
            this.log.debug((Object)ds);
            try {
                this.xslt(stored.getSourceAET(), stored.getRetrieveAET(), ds, tpl, new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attrs) {
                        if (qName.equals("prefetch")) {
                            WadoPrefetchOrder order = new WadoPrefetchOrder(attrs.getValue("wadourl"), attrs.getValue("exportPath"), stored.getIAN());
                            try {
                                WadoPrefetchService.this.jmsDelegate.queue(WadoPrefetchService.this.queueName, order, 4, 0L);
                            }
                            catch (Exception e) {
                                WadoPrefetchService.this.log.error((Object)("Failed to schedule " + order), (Throwable)e);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)("Applying WADO prefetch rules to " + stored + " fails:"), (Throwable)e);
            }
        }
    }

    public void onMessage(Message message) {
        block5: {
            ObjectMessage om = (ObjectMessage)message;
            try {
                WadoPrefetchOrder order = (WadoPrefetchOrder)om.getObject();
                this.log.info((Object)("Start processing order" + order));
                try {
                    this.process(order);
                    this.log.info((Object)("Processing finished! order:" + order));
                }
                catch (Exception e) {
                    order.setThrowable(e);
                    int failureCount = order.getFailureCount() + 1;
                    order.setFailureCount(failureCount);
                    long delay = this.retryIntervalls.getIntervall(failureCount);
                    if (delay == -1L) {
                        this.log.error((Object)("Give up to process " + order), (Throwable)e);
                        this.jmsDelegate.fail(this.queueName, order);
                        break block5;
                    }
                    this.log.warn((Object)("Failed to process " + order + ". Scheduling retry."), (Throwable)e);
                    this.jmsDelegate.queue(this.queueName, order, 0, System.currentTimeMillis() + delay);
                }
            }
            catch (Throwable e) {
                this.log.error((Object)("unexpected error during processing message: " + message), e);
            }
        }
    }

    private void process(WadoPrefetchOrder order) throws IOException {
        String wadourl = order.getWadoUrl();
        String dest = order.getExportPath();
        Dataset ian = order.getIAN();
        DcmElement refSopSq = ian.getItem(528661).get(528793);
        for (int i = 0; i < refSopSq.countItems(); ++i) {
            Dataset item = refSopSq.getItem(i);
            this.prefetch(wadourl, dest, item.getString(528725));
        }
    }

    private void prefetch(String baseURL, String dest, String iuid) throws IOException {
        String url = baseURL + "&objectUID=" + iuid;
        try {
            URL wadourl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)wadourl.openConnection();
            if (conn.getResponseCode() != 200) {
                this.log.warn((Object)("Prefetch WADO URL failed:" + wadourl));
                throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
            }
            if (dest != null) {
                this.export(dest, iuid, conn);
            }
        }
        catch (MalformedURLException e) {
            this.log.error((Object)("Prefetch request ignored: Malformed WADO URL! Need configuration change in wado-prefetch.xsl! url:" + url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(String dest, String iuid, HttpURLConnection conn) throws IOException, FileNotFoundException {
        InputStream is = conn.getInputStream();
        File file = this.getFile(dest, iuid);
        this.log.info((Object)("M-WRITE " + file));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buf = new byte[65536];
        try {
            int len = is.read(buf);
            while (len > 0) {
                out.write(buf, 0, len);
                len = is.read(buf);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            is.close();
            out.flush();
            out.close();
            throw throwable;
        }
        is.close();
        out.flush();
        out.close();
    }

    private File getFile(String dest, String iuid) {
        String fn = MessageFormat.format(dest, iuid);
        File file = FileUtils.resolve(new File(fn));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    private void xslt(String sourceAET, String retrieveAET, Dataset ds, Templates tpl, ContentHandler ch) throws TransformerConfigurationException, IOException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler th = tf.newTransformerHandler(tpl);
        Transformer t = th.getTransformer();
        t.setParameter("source-aet", sourceAET);
        t.setParameter("retrieve-aet", retrieveAET);
        t.setParameter("wado-baseurl", this.wadoBaseUrl);
        t.setParameter("export-path", this.exportBasePath);
        th.setResult(new SAXResult(ch));
        ds.writeDataset2(th, null, null, 64, null);
    }
}

