/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.ObjectName;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4che.dict.Tags;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.UpdateAttributes;
import org.dcm4chex.archive.ejb.interfaces.UpdateAttributesHome;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.RetrieveCmd;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class UpdateAttributesService
extends ServiceMBeanSupport {
    private static final String ANY = "ANY";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String modality;
    private String sourceAETitle;
    private Timestamp updatedBefore;
    private Timestamp updatedAfter;
    private int availability;
    private int maximalNumberOfSeriesToUpdateByOneTask;
    private ObjectName queryRetrieveScpServiceName;
    private ObjectName tarRetrieverName;
    private int fetchSize;

    public final ObjectName getQueryRetrieveScpServiceName() {
        return this.queryRetrieveScpServiceName;
    }

    public final void setQueryRetrieveScpServiceName(ObjectName name) {
        this.queryRetrieveScpServiceName = name;
    }

    public final ObjectName getTarRetrieverName() {
        return this.tarRetrieverName;
    }

    public final void setTarRetrieverName(ObjectName tarRetrieverName) {
        this.tarRetrieverName = tarRetrieverName;
    }

    public final String getModality() {
        return this.modality != null ? this.modality : ANY;
    }

    public final void setModality(String modality) {
        this.modality = !ANY.equalsIgnoreCase(modality) ? modality : null;
    }

    public final String getSourceAETitle() {
        return this.sourceAETitle != null ? this.sourceAETitle : ANY;
    }

    public final void setSourceAETitle(String sourceAETitle) {
        this.sourceAETitle = !ANY.equalsIgnoreCase(sourceAETitle) ? sourceAETitle : null;
    }

    public final String getUpdatedBefore() {
        return UpdateAttributesService.formatDate(this.updatedBefore());
    }

    private Timestamp updatedBefore() {
        return this.updatedBefore != null ? this.updatedBefore : new Timestamp(AttributeFilter.lastModified());
    }

    private static String formatDate(Timestamp ts) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT);
        return df.format(ts);
    }

    public final void setUpdatedBefore(String s) throws ParseException {
        this.updatedBefore = s.equalsIgnoreCase("AUTO") ? null : UpdateAttributesService.parseDate(s);
    }

    private static Timestamp parseDate(String s) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT.substring(0, s.length()));
        return new Timestamp(df.parse(s).getTime());
    }

    public final String getUpdatedAfter() {
        return UpdateAttributesService.formatDate(this.updatedAfter);
    }

    public final void setUpdatedAfter(String s) throws ParseException {
        this.updatedAfter = UpdateAttributesService.parseDate(s);
    }

    public final String getAvailability() {
        return Availability.toString(this.availability);
    }

    public final void setAvailability(String availability) {
        this.availability = Availability.toInt(availability);
    }

    public final int getMaximalNumberOfSeriesToUpdateByOneTask() {
        return this.maximalNumberOfSeriesToUpdateByOneTask;
    }

    public final void setMaximalNumberOfSeriesToUpdateByOneTask(int max) {
        this.maximalNumberOfSeriesToUpdateByOneTask = max;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void reloadAttributeFilter() {
        AttributeFilter.reload();
    }

    public int countNumberOfMatchingSeriesToUpdate() throws Exception {
        return this.updateAttributes().countSeriesForAttributesUpdate(this.availability, this.modality, this.sourceAETitle, this.updatedAfter, this.updatedBefore());
    }

    public int updateMatchingSeries() throws Exception {
        Collection seriesIuids;
        this.reloadAttributeFilter();
        UpdateAttributes updateAttributes = this.updateAttributes();
        int remain = this.maximalNumberOfSeriesToUpdateByOneTask;
        int offset = 0;
        while (remain > 0 && (seriesIuids = updateAttributes.seriesIuidsForAttributesUpdate(this.availability, this.modality, this.sourceAETitle, this.updatedAfter, this.updatedBefore(), offset, remain)).size() != 0) {
            Iterator iterator = seriesIuids.iterator();
            while (iterator.hasNext()) {
                if (this.updateSeries((String)iterator.next(), updateAttributes) <= 0) continue;
                --remain;
            }
            offset += this.maximalNumberOfSeriesToUpdateByOneTask;
        }
        return this.maximalNumberOfSeriesToUpdateByOneTask - remain;
    }

    public int updateSeries(String seriesIuid) throws Exception {
        this.reloadAttributeFilter();
        return this.updateSeries(seriesIuid, this.updateAttributes());
    }

    protected int updateSeries(String seriesIuid, UpdateAttributes updateAttributes) throws Exception {
        Dataset keys = DcmObjectFactory.getInstance().newDataset();
        keys.putUI(0x20000E, seriesIuid);
        RetrieveCmd cmd = RetrieveCmd.createSeriesRetrieve((Dataset)keys);
        cmd.setFetchSize(this.fetchSize);
        FileInfo[][] fileInfos = cmd.getFileInfos();
        int count = 0;
        Dataset series = null;
        for (int i = 0; i < fileInfos.length; ++i) {
            try {
                this.log.debug((Object)("Update Attributes of fileinfo:" + fileInfos[i][0]));
                Dataset inst = this.loadDataset(fileInfos[i]);
                this.correctUID(inst, 524312, fileInfos[i][0].sopIUID);
                this.correctUID(inst, 0x20000E, fileInfos[i][0].seriesIUID);
                this.correctUID(inst, 0x20000D, fileInfos[i][0].studyIUID);
                if (inst == null) continue;
                updateAttributes.updateInstanceAttributes(inst);
                series = inst;
                ++count;
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to update instance[uid= " + fileInfos[i][0].sopIUID + "]"));
                this.log.debug((Object)"Exception in UpdateSeries:", (Throwable)e);
            }
        }
        if (series != null) {
            try {
                updateAttributes.updatePatientStudySeriesAttributes(series);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to update series[uid= " + seriesIuid + "]"));
                return 0;
            }
            this.log.info((Object)("Updated " + count + " of " + fileInfos.length + " instances from series[uid= " + seriesIuid + "]"));
            if (count < fileInfos.length) {
                this.log.warn((Object)("Only updated " + count + " of " + fileInfos.length + " instances from series[uid= " + seriesIuid + "]"));
            }
        }
        return count;
    }

    private void correctUID(Dataset ds, int tag, String uid) {
        String oldUid = ds.getString(tag);
        if (!oldUid.equals(uid)) {
            Tags.toString(tag);
            this.log.info((Object)("Received UID (" + Tags.toString(tag) + "=" + oldUid + ") has been changed (" + uid + ")! corrected!"));
            ds.putUI(tag, uid);
        }
    }

    private Dataset loadDataset(FileInfo[] fileInfos) {
        for (int i = 0; i < fileInfos.length; ++i) {
            FileInfo fileInfo = fileInfos[i];
            if (!this.isLocalRetrieveAET(fileInfo.fileRetrieveAET)) continue;
            Dataset ds = DcmObjectFactory.getInstance().newDataset();
            try {
                ds.readFile(this.getFile(fileInfo), FileFormat.DICOM_FILE, 2145386512);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to read dataset referenced by " + fileInfo), (Throwable)e);
                return null;
            }
            this.checkUID(ds, 524312, "SOP", fileInfo.sopIUID);
            this.checkUID(ds, 0x20000E, "Series", fileInfo.seriesIUID);
            this.checkUID(ds, 0x20000D, "Study", fileInfo.studyIUID);
            return ds;
        }
        return null;
    }

    private void checkUID(Dataset ds, int tag, String name, String uid) {
        if (!uid.equals(ds.getString(tag))) {
            this.log.info((Object)("Different " + name + " Instance UIDs! File:" + ds.getString(tag) + "\n DB:" + uid));
            ds.putUI(tag, uid);
        }
    }

    public String updateMatchingSeriesShowElapsedTime() throws Exception {
        long begin = System.currentTimeMillis();
        int updated = this.updateMatchingSeries();
        long end = System.currentTimeMillis();
        return "Updated attributes of " + updated + " Series in the database in " + (float)(end - begin) / 1000.0f + " seconds.";
    }

    private UpdateAttributes updateAttributes() throws Exception {
        return ((UpdateAttributesHome)EJBHomeFactory.getFactory().lookup(UpdateAttributesHome.class, "ejb/UpdateAttributes")).create();
    }

    boolean isLocalRetrieveAET(String aet) {
        try {
            return (Boolean)this.server.invoke(this.queryRetrieveScpServiceName, "isLocalRetrieveAET", new Object[]{aet}, new String[]{String.class.getName()});
        }
        catch (JMException e) {
            throw new RuntimeException("Failed to invoke isLocalRetrieveAET() on " + this.queryRetrieveScpServiceName, e);
        }
    }

    private File getFile(FileInfo info) throws Exception {
        return info.basedir.startsWith("tar:") ? this.retrieveFileFromTAR(info.basedir, info.fileID) : FileUtils.toFile(info.basedir, info.fileID);
    }

    File retrieveFileFromTAR(String fsID, String fileID) throws Exception {
        return (File)this.server.invoke(this.tarRetrieverName, "retrieveFileFromTAR", new Object[]{fsID, fileID}, new String[]{String.class.getName(), String.class.getName()});
    }
}

