/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dcm4chex.archive.util.FileUtils;
import org.jboss.system.ServiceMBeanSupport;

public class TemplatesService
extends ServiceMBeanSupport {
    private final Map cache = Collections.synchronizedMap(new HashMap());

    public Templates getTemplates(File f) {
        long lastModified = f.lastModified();
        if (lastModified == 0L) {
            return null;
        }
        CacheEntry entry = (CacheEntry)this.cache.get(f);
        if (entry != null && entry.lastModified == lastModified) {
            return entry.templates;
        }
        try {
            this.log.info((Object)("Compiling Stylesheet " + f));
            Templates templates = TransformerFactory.newInstance().newTemplates(new StreamSource(f));
            this.cache.put(f, new CacheEntry(templates, lastModified));
            return templates;
        }
        catch (Exception e) {
            this.log.error((Object)("Compiling Stylesheet " + f + " failed:"), (Throwable)e);
            return null;
        }
    }

    public Templates getTemplatesForAET(String dir, String aet, String fname) {
        return this.getTemplates(this.getFile(dir, aet, fname));
    }

    private File getFile(String dir, String aet, String fname) {
        File f;
        if (aet != null && (f = FileUtils.resolve(new File(new File(dir, aet), fname))).exists()) {
            return f;
        }
        return FileUtils.resolve(new File(dir, fname));
    }

    public Templates findTemplates(String dir, String[] subdirs, String prefix, String[] fnames, String postfix) {
        return this.getTemplates(this.findFile(dir, subdirs, prefix, fnames, postfix));
    }

    private File findFile(String dir, String[] subdirs, String prefix, String[] fnames, String postfix) {
        File f = null;
        block0: for (int i = 0; i < fnames.length; ++i) {
            String fn = this.getFilename(prefix, fnames[i], postfix);
            if (subdirs != null) {
                for (int j = 0; j < subdirs.length; ++j) {
                    f = FileUtils.resolve(new File(new File(dir, subdirs[j]), fn));
                    if (f.exists()) break block0;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Style sheet file " + f + " does not exist!"));
                }
            }
            if ((f = FileUtils.resolve(new File(dir, fn))).exists()) break;
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Style sheet file " + fn + " does not exist in any subfolder!"));
        }
        if (f.exists()) {
            this.log.info((Object)("Style sheet found:" + f));
        }
        return f;
    }

    private String getFilename(String prefix, String filename, String postfix) {
        StringBuilder sb = new StringBuilder(filename.length() + 15);
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(filename);
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static final class CacheEntry {
        final Templates templates;
        final long lastModified;

        CacheEntry(Templates templates, long lastModified) {
            this.templates = templates;
            this.lastModified = lastModified;
        }
    }
}

