/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.File;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.jboss.system.ServiceMBeanSupport;

public final class TemplatesDelegate {
    private final ServiceMBeanSupport service;
    private ObjectName templatesServiceName;
    private String configDir;

    public TemplatesDelegate(ServiceMBeanSupport service) {
        this.service = service;
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templatesServiceName;
    }

    public final void setTemplatesServiceName(ObjectName templatesServiceName) {
        this.templatesServiceName = templatesServiceName;
    }

    public final String getConfigDir() {
        return this.configDir;
    }

    public final void setConfigDir(String path) {
        this.configDir = path;
    }

    public Templates getTemplates(File f) {
        try {
            return (Templates)this.service.getServer().invoke(this.templatesServiceName, "getTemplates", new Object[]{f}, new String[]{File.class.getName()});
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Templates getTemplatesForAET(String aet, String fname) {
        try {
            return (Templates)this.service.getServer().invoke(this.templatesServiceName, "getTemplatesForAET", new Object[]{this.configDir, aet, fname}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Templates findTemplates(String[] subdirs, String prefix, String[] fnames, String postfix) {
        try {
            return (Templates)this.service.getServer().invoke(this.templatesServiceName, "findTemplates", new Object[]{this.configDir, subdirs, prefix, fnames, postfix}, new String[]{String.class.getName(), String[].class.getName(), String.class.getName(), String[].class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

