/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.mbean;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;
import org.dcm4che.util.HandshakeFailedEvent;
import org.dcm4che.util.HandshakeFailedListener;
import org.dcm4che.util.SSLContextAdapter;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.SecurityAlertMessage;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.jboss.system.ServiceMBeanSupport;

public class TLSConfigService
extends ServiceMBeanSupport
implements HandshakeFailedListener,
HandshakeCompletedListener {
    private SSLContextAdapter ssl = SSLContextAdapter.getInstance();
    private String keyStoreURL = "resource:identity.p12";
    private char[] keyStorePassword = new char[]{'p', 'a', 's', 's', 'w', 'd'};
    private String trustStoreURL = "resource:cacerts.jks";
    private char[] trustStorePassword = new char[]{'p', 'a', 's', 's', 'w', 'd'};
    private KeyStore keyStore;
    private KeyStore trustStore;

    public TLSConfigService() {
        this.ssl.addHandshakeFailedListener(this);
        this.ssl.addHandshakeCompletedListener(this);
    }

    public String getEnabledProtocols() {
        return StringUtils.toString(this.ssl.getEnabledProtocols(), ',');
    }

    public void setEnabledProtocols(String protocols) {
        this.ssl.setEnabledProtocols(StringUtils.split(protocols, ','));
    }

    public String getSupportedProtocols() {
        try {
            this.initTLSConf();
            this.ssl.getSSLContext();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return StringUtils.toString(this.ssl.getSupportedProtocols(), ',');
    }

    public boolean isNeedClientAuth() {
        return this.ssl.isNeedClientAuth();
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.ssl.setNeedClientAuth(needClientAuth);
    }

    public final void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword.toCharArray();
    }

    public final String getKeyStoreURL() {
        return this.keyStoreURL;
    }

    public final void setKeyStoreURL(String keyStoreURL) {
        this.keyStoreURL = keyStoreURL;
        this.keyStore = null;
    }

    public final void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword.toCharArray();
    }

    public final String getTrustStoreURL() {
        return this.trustStoreURL;
    }

    public final void setTrustStoreURL(String trustStoreURL) {
        this.trustStoreURL = trustStoreURL;
        this.trustStore = null;
    }

    public final HandshakeFailedListener handshakeFailedListener() {
        return this;
    }

    public final HandshakeCompletedListener handshakeCompletedListener() {
        return this;
    }

    public ServerSocketFactory serverSocketFactory(String[] cipherSuites) {
        if (cipherSuites == null || cipherSuites.length == 0) {
            return ServerSocketFactory.getDefault();
        }
        try {
            this.initTLSConf();
            return this.ssl.getServerSocketFactory(cipherSuites);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public SocketFactory socketFactory(String[] cipherSuites) {
        if (cipherSuites == null || cipherSuites.length == 0) {
            return SocketFactory.getDefault();
        }
        try {
            this.initTLSConf();
            return this.ssl.getSocketFactory(cipherSuites);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public void startHandshake(Socket s) throws IOException {
        if (s instanceof SSLSocket) {
            this.ssl.startHandshake((SSLSocket)s);
        }
    }

    private void initTLSConf() throws GeneralSecurityException, IOException {
        if (this.keyStore == null) {
            this.keyStore = this.ssl.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
            this.ssl.setKey(this.keyStore, this.keyStorePassword);
        }
        if (this.trustStore == null) {
            this.trustStore = this.ssl.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
            this.ssl.setTrust(this.trustStore);
        }
    }

    protected void startService() throws Exception {
        this.keyStore = null;
        this.trustStore = null;
    }

    protected void stopService() throws Exception {
    }

    public void handshakeFailed(HandshakeFailedEvent event) {
        try {
            SSLSocket sock = event.getSocket();
            SecurityAlertMessage msg = new SecurityAlertMessage(SecurityAlertMessage.NODE_AUTHENTICATION);
            msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
            msg.addPerformingNode(AuditMessage.hostNameOf((InetAddress)sock.getInetAddress()));
            msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), event.getException().getMessage());
            msg.validate();
            Logger.getLogger((String)"auditlog").warn((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent hscEvent) {
        try {
            SSLSocket sock = hscEvent.getSocket();
            SecurityAlertMessage msg = new SecurityAlertMessage(SecurityAlertMessage.NODE_AUTHENTICATION);
            msg.addReportingProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName());
            msg.addPerformingNode(AuditMessage.hostNameOf((InetAddress)sock.getInetAddress()));
            msg.addAlertSubjectWithNodeID(AuditMessage.getLocalNodeID(), this.toText(hscEvent));
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    private String toText(HandshakeCompletedEvent hscEvent) {
        return "SSL handshake completed, cipher suite: " + hscEvent.getCipherSuite();
    }
}

